/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.legacytracker.associationMethod;

import java.util.ArrayList;
import plugins.nchenouard.particletracking.legacytracker.associationMethod.AssignProblem;
import plugins.nchenouard.particletracking.legacytracker.associationMethod.AssignProblemSolver;
import plugins.nchenouard.particletracking.legacytracker.associationMethod.Track;
import plugins.nchenouard.spot.Spot;

public class SolveMLAssociation
extends AssignProblemSolver {
    public static final int methoId = 0;
    protected final boolean addNewObjects;

    public SolveMLAssociation(boolean addNewObjects) {
        this.addNewObjects = addNewObjects;
    }

    protected void solve1(AssignProblem pb) {
        Track track = pb.tracks.get(0);
        Spot spot = pb.detections.get(0);
        track.associate(spot, pb.t);
    }

    protected void solve2(AssignProblem pb) {
        if (this.addNewObjects) {
            pb.tracksToBeCreated.add(pb.detections.get(0));
        }
    }

    protected void solve3(AssignProblem pb) {
        pb.tracksToBeProlongated.add(pb.tracks.get(0));
    }

    protected void solve4(AssignProblem pb, int num) {
        this.asignOpt(pb, num, num);
    }

    protected void solve5(AssignProblem pb, int numTracks, int numDetect) {
        this.asignOpt(pb, numTracks, numDetect);
    }

    protected void solve6(AssignProblem pb, int numTracks, int numDetect) {
        this.asignOpt(pb, numTracks, numDetect);
    }

    public void asignOpt(AssignProblem pb, int numTracks, int numDetect) {
        int[] tm = this.assignOptMax(pb.likelihoods);
        ArrayList<Integer> usedDetection = new ArrayList<Integer>();
        for (int j = 0; j < numTracks; ++j) {
            Track track = pb.tracks.get(j);
            if (tm[j] >= 0) {
                track.associate(pb.detections.get(tm[j]), pb.t);
                usedDetection.add(new Integer(tm[j]));
                continue;
            }
            pb.tracksToBeProlongated.add(track);
        }
        for (int i = 0; i < numDetect; ++i) {
            if (usedDetection.contains(new Integer(i))) continue;
            pb.tracksToBeCreated.add(pb.detections.get(i));
        }
    }

    @Override
    public void solve(AssignProblem pb) {
        int numTracks = pb.tracks.size();
        int numDetect = pb.detections.size();
        pb.tracksToBeCreated.clear();
        pb.tracksToBeProlongated.clear();
        if (numTracks == 1 && numDetect == 1) {
            this.solve1(pb);
            return;
        }
        if (numTracks == 0 && numDetect == 1) {
            this.solve2(pb);
            return;
        }
        if (numTracks == 1 && numDetect == 0) {
            this.solve3(pb);
            return;
        }
        if (numTracks == numDetect) {
            this.solve4(pb, numTracks);
            return;
        }
        if (numTracks >= numDetect) {
            this.solve6(pb, numTracks, numDetect);
            return;
        }
        this.solve5(pb, numTracks, numDetect);
    }

    protected int[] assignOptMax(double[][] d) {
        int i;
        if (d.length == 0 || d[0].length == 0) {
            return null;
        }
        int trackNumber = d[0].length;
        int measuNumber = d.length;
        int[] tm = new int[trackNumber];
        int[] t = new int[trackNumber];
        int[] m = new int[measuNumber];
        for (i = 0; i < trackNumber; ++i) {
            tm[i] = -2;
            t[i] = i;
        }
        for (i = 0; i < measuNumber; ++i) {
            m[i] = i;
        }
        int iter = trackNumber;
        while (iter-- > 0) {
            int tIndex = -1;
            int mIndex = -1;
            double opt = 0.0;
            for (int i2 = 0; i2 < trackNumber; ++i2) {
                if (t[i2] < 0) continue;
                for (int j = 0; j < measuNumber; ++j) {
                    if (m[j] < 0 || !(opt < d[j][i2])) continue;
                    tIndex = i2;
                    mIndex = j;
                    opt = d[j][i2];
                }
            }
            if (tIndex == -1 || mIndex == -1) continue;
            tm[tIndex] = opt >= 0.0 ? mIndex : -1;
            t[tIndex] = -1;
            m[mIndex] = -1;
        }
        return tm;
    }

    protected int[] assignOptMin(double[][] d) {
        int i;
        if (d.length == 0 || d[0].length == 0) {
            return null;
        }
        int trackNumber = d[0].length;
        int measuNumber = d.length;
        int iter = trackNumber;
        int[] tm = new int[trackNumber];
        int[] t = new int[trackNumber];
        int[] m = new int[measuNumber];
        for (i = 0; i < trackNumber; ++i) {
            tm[i] = -2;
        }
        for (i = 0; i < trackNumber; ++i) {
            t[i] = i;
        }
        for (i = 0; i < measuNumber; ++i) {
            m[i] = i;
        }
        while (iter-- > 0) {
            int tIndex = -1;
            int mIndex = -1;
            double opt = Double.MAX_VALUE;
            for (int i2 = 0; i2 < trackNumber; ++i2) {
                if (t[i2] == -1) continue;
                for (int j = 0; j < measuNumber; ++j) {
                    if (m[j] == -1 || !(opt > d[j][i2]) || !(d[j][i2] >= 0.0)) continue;
                    tIndex = i2;
                    mIndex = j;
                    opt = d[j][i2];
                }
            }
            if (tIndex == -1 || mIndex == -1) continue;
            tm[tIndex] = opt >= 0.0 ? mIndex : -1;
            t[tIndex] = -1;
            m[mIndex] = -1;
        }
        return tm;
    }
}

