/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.linalg.Vector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.FloatShapedVectorSpace;
import mitiv.optim.SimpleBoxedSet;

public class FloatBoxedSet
extends SimpleBoxedSet {
    private float[] lo = null;
    private float[] up = null;
    private int bound = 0;

    public FloatBoxedSet(FloatShapedVectorSpace space) {
        super(space);
    }

    private float[] getData(Vector vec) {
        this.space.check(vec);
        return ((FloatShapedVector)vec).getData();
    }

    @Override
    public void setLowerBound(double _val) {
        float val = (float)_val;
        if (val > Float.NEGATIVE_INFINITY) {
            this.lo = new float[]{val};
            this.bound = this.bound / 3 * 3 + 1;
        } else {
            this.lo = null;
            this.bound = this.bound / 3 * 3;
        }
    }

    @Override
    public void setLowerBound(Vector vec) {
        if (vec != null) {
            this.lo = this.getData(vec);
            this.bound = this.bound / 3 * 3 + 2;
        } else {
            this.lo = null;
            this.bound = this.bound / 3 * 3;
        }
    }

    @Override
    public void setUpperBound(double _val) {
        float val = (float)_val;
        if (val < Float.POSITIVE_INFINITY) {
            this.up = new float[]{val};
            this.bound = this.bound % 3 + 3;
        } else {
            this.up = null;
            this.bound %= 3;
        }
    }

    @Override
    public void setUpperBound(Vector vec) {
        if (vec != null) {
            this.up = this.getData(vec);
            this.bound = this.bound % 3 + 6;
        } else {
            this.up = null;
            this.bound %= 3;
        }
    }

    @Override
    public final void projectVariables(Vector dst, Vector vec) {
        float[] xp = this.getData(dst);
        float[] x = this.getData(vec);
        int n = x.length;
        switch (this.bound) {
            case 0: {
                if (xp == x) break;
                System.arraycopy(xp, 0, x, 0, n);
                break;
            }
            case 1: {
                float a = this.lo[0];
                for (int i = 0; i < n; ++i) {
                    float t = x[i];
                    if (t < a) {
                        t = a;
                    }
                    xp[i] = t;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n; ++i) {
                    float t = x[i];
                    float a = this.lo[i];
                    if (t < a) {
                        t = a;
                    }
                    xp[i] = t;
                }
                break;
            }
            case 3: {
                float b = this.up[0];
                for (int i = 0; i < n; ++i) {
                    float t = x[i];
                    if (t > b) {
                        t = b;
                    }
                    xp[i] = t;
                }
                break;
            }
            case 4: {
                float a = this.lo[0];
                float b = this.up[0];
                for (int i = 0; i < n; ++i) {
                    float t = x[i];
                    if (t < a) {
                        t = a;
                    }
                    if (t > b) {
                        t = b;
                    }
                    xp[i] = t;
                }
                break;
            }
            case 5: {
                float b = this.up[0];
                for (int i = 0; i < n; ++i) {
                    float t = x[i];
                    float a = this.lo[i];
                    if (t < a) {
                        t = a;
                    }
                    if (t > b) {
                        t = b;
                    }
                    xp[i] = t;
                }
                break;
            }
            case 6: {
                for (int i = 0; i < n; ++i) {
                    float t = x[i];
                    float b = this.up[i];
                    if (t > b) {
                        t = b;
                    }
                    xp[i] = t;
                }
                break;
            }
            case 7: {
                float a = this.lo[0];
                for (int i = 0; i < n; ++i) {
                    float t = x[i];
                    float b = this.up[i];
                    if (t < a) {
                        t = a;
                    }
                    if (t > b) {
                        t = b;
                    }
                    xp[i] = t;
                }
                break;
            }
            case 8: {
                for (int i = 0; i < n; ++i) {
                    float a = this.lo[i];
                    float t = x[i];
                    float b = this.up[i];
                    if (t < a) {
                        t = a;
                    }
                    if (t > b) {
                        t = b;
                    }
                    xp[i] = t;
                }
                break;
            }
        }
    }

    @Override
    public void projectDirection(Vector dst, Vector vec, Vector dir, int orient) {
        float[] dp = this.getData(dst);
        float[] x = this.getData(vec);
        float[] d = this.getData(dir);
        int n = x.length;
        switch (this.bound) {
            case 0: {
                if (dp == d) break;
                System.arraycopy(dp, 0, d, 0, n);
                break;
            }
            case 1: {
                float a = this.lo[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] >= 0.0f || x[i] > a ? d[i] : 0.0f;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] <= 0.0f || x[i] > a ? d[i] : 0.0f;
                    }
                }
                break;
            }
            case 2: {
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] >= 0.0f || x[i] > this.lo[i] ? d[i] : 0.0f;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] <= 0.0f || x[i] > this.lo[i] ? d[i] : 0.0f;
                    }
                }
                break;
            }
            case 3: {
                float b = this.up[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] <= 0.0f || x[i] < b ? d[i] : 0.0f;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] >= 0.0f || x[i] < b ? d[i] : 0.0f;
                    }
                }
                break;
            }
            case 4: {
                float a = this.lo[0];
                float b = this.up[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] < 0.0f ? (x[i] > a ? d[i] : 0.0f) : (d[i] > 0.0f ? (x[i] < b ? d[i] : 0.0f) : 0.0f);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] > 0.0f ? (x[i] > a ? d[i] : 0.0f) : (d[i] < 0.0f ? (x[i] < b ? d[i] : 0.0f) : 0.0f);
                    }
                }
                break;
            }
            case 5: {
                float b = this.up[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] < 0.0f ? (x[i] > this.lo[i] ? d[i] : 0.0f) : (d[i] > 0.0f ? (x[i] < b ? d[i] : 0.0f) : 0.0f);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] > 0.0f ? (x[i] > this.lo[i] ? d[i] : 0.0f) : (d[i] < 0.0f ? (x[i] < b ? d[i] : 0.0f) : 0.0f);
                    }
                }
                break;
            }
            case 6: {
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] <= 0.0f || x[i] < this.up[i] ? d[i] : 0.0f;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] >= 0.0f || x[i] < this.up[i] ? d[i] : 0.0f;
                    }
                }
                break;
            }
            case 7: {
                float a = this.lo[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] < 0.0f ? (x[i] > a ? d[i] : 0.0f) : (d[i] > 0.0f ? (x[i] < this.up[i] ? d[i] : 0.0f) : 0.0f);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] > 0.0f ? (x[i] > a ? d[i] : 0.0f) : (d[i] < 0.0f ? (x[i] < this.up[i] ? d[i] : 0.0f) : 0.0f);
                    }
                }
                break;
            }
            case 8: {
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] < 0.0f ? (x[i] > this.lo[i] ? d[i] : 0.0f) : (d[i] > 0.0f ? (x[i] < this.up[i] ? d[i] : 0.0f) : 0.0f);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        dp[i] = d[i] > 0.0f ? (x[i] > this.lo[i] ? d[i] : 0.0f) : (d[i] < 0.0f ? (x[i] < this.up[i] ? d[i] : 0.0f) : 0.0f);
                    }
                }
                break;
            }
        }
    }

    @Override
    public void findFreeVariables(Vector dst, Vector vec, Vector dir, int orient) {
        float[] w = this.getData(dst);
        float[] x = this.getData(vec);
        float[] d = this.getData(dir);
        int n = x.length;
        switch (this.bound) {
            case 0: {
                for (int i = 0; i < n; ++i) {
                    w[i] = 1.0f;
                }
                break;
            }
            case 1: {
                float a = this.lo[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        w[i] = d[i] < 0.0f ? (float)(x[i] > a ? 1 : 0) : (float)(d[i] > 0.0f ? 1 : 0);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        w[i] = d[i] > 0.0f ? (float)(x[i] > a ? 1 : 0) : (float)(d[i] < 0.0f ? 1 : 0);
                    }
                }
                break;
            }
            case 2: {
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        w[i] = d[i] < 0.0f ? (float)(x[i] > this.lo[i] ? 1 : 0) : (float)(d[i] > 0.0f ? 1 : 0);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        w[i] = d[i] > 0.0f ? (float)(x[i] > this.lo[i] ? 1 : 0) : (float)(d[i] < 0.0f ? 1 : 0);
                    }
                }
                break;
            }
            case 3: {
                float b = this.up[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        w[i] = d[i] < 0.0f ? 1.0f : (float)(d[i] > 0.0f ? x[i] < b : false);
                    }
                    break;
                }
                for (int i = 0; i < n; ++i) {
                    w[i] = d[i] > 0.0f ? 1.0f : (float)(d[i] < 0.0f ? x[i] < b : false);
                }
                break;
            }
            case 4: {
                float a = this.lo[0];
                float b = this.up[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        w[i] = d[i] < 0.0f ? (float)(x[i] > a ? 1 : 0) : (float)(d[i] > 0.0f ? x[i] < b : false);
                    }
                    break;
                }
                for (int i = 0; i < n; ++i) {
                    w[i] = d[i] > 0.0f ? (float)(x[i] > a ? 1 : 0) : (float)(d[i] < 0.0f ? x[i] < b : false);
                }
                break;
            }
            case 5: {
                float b = this.up[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        w[i] = d[i] < 0.0f ? (float)(x[i] > this.lo[i] ? 1 : 0) : (float)(d[i] > 0.0f ? x[i] < b : false);
                    }
                    break;
                }
                for (int i = 0; i < n; ++i) {
                    w[i] = d[i] > 0.0f ? (float)(x[i] > this.lo[i] ? 1 : 0) : (float)(d[i] < 0.0f ? x[i] < b : false);
                }
                break;
            }
            case 6: {
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        w[i] = d[i] < 0.0f ? 1.0f : (float)(d[i] > 0.0f ? x[i] < this.up[i] : false);
                    }
                    break;
                }
                for (int i = 0; i < n; ++i) {
                    w[i] = d[i] > 0.0f ? 1.0f : (float)(d[i] < 0.0f ? x[i] < this.up[i] : false);
                }
                break;
            }
            case 7: {
                float a = this.lo[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        w[i] = d[i] < 0.0f ? (float)(x[i] > a ? 1 : 0) : (float)(d[i] > 0.0f ? x[i] < this.up[i] : false);
                    }
                    break;
                }
                for (int i = 0; i < n; ++i) {
                    w[i] = d[i] > 0.0f ? (float)(x[i] > a ? 1 : 0) : (float)(d[i] < 0.0f ? x[i] < this.up[i] : false);
                }
                break;
            }
            case 8: {
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        w[i] = d[i] < 0.0f ? (float)(x[i] > this.lo[i] ? 1 : 0) : (float)(d[i] > 0.0f ? x[i] < this.up[i] : false);
                    }
                    break;
                }
                for (int i = 0; i < n; ++i) {
                    w[i] = d[i] > 0.0f ? (float)(x[i] > this.lo[i] ? 1 : 0) : (float)(d[i] < 0.0f ? x[i] < this.up[i] : false);
                }
                break;
            }
        }
    }

    @Override
    public double[] findStepLimits(Vector vec, Vector dir, int orient) {
        float[] x = this.getData(vec);
        float[] d = this.getData(dir);
        int n = x.length;
        float s3 = Float.POSITIVE_INFINITY;
        float s2 = Float.POSITIVE_INFINITY;
        float s1 = Float.POSITIVE_INFINITY;
        switch (this.bound) {
            case 1: {
                s3 = 0.0f;
                float a = this.lo[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        float p = d[i];
                        if (p < 0.0f) {
                            float s = (a - x[i]) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0f) {
                                s2 = s;
                            }
                            if (!(s > s3)) continue;
                            s3 = s;
                            continue;
                        }
                        if (!(p > 0.0f)) continue;
                        s3 = Float.POSITIVE_INFINITY;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        float p = d[i];
                        if (p > 0.0f) {
                            float s = (x[i] - a) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0f) {
                                s2 = s;
                            }
                            if (!(s > s3)) continue;
                            s3 = s;
                            continue;
                        }
                        if (!(p < 0.0f)) continue;
                        s3 = Float.POSITIVE_INFINITY;
                    }
                }
                break;
            }
            case 2: {
                s3 = 0.0f;
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        float p = d[i];
                        if (p < 0.0f) {
                            float s = (this.lo[i] - x[i]) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0f) {
                                s2 = s;
                            }
                            if (!(s > s3)) continue;
                            s3 = s;
                            continue;
                        }
                        if (!(p > 0.0f)) continue;
                        s3 = Float.POSITIVE_INFINITY;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        float p = d[i];
                        if (p > 0.0f) {
                            float s = (x[i] - this.lo[i]) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0f) {
                                s2 = s;
                            }
                            if (!(s > s3)) continue;
                            s3 = s;
                            continue;
                        }
                        if (!(p < 0.0f)) continue;
                        s3 = Float.POSITIVE_INFINITY;
                    }
                }
                break;
            }
            case 3: {
                s3 = 0.0f;
                float b = this.up[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        float p = d[i];
                        if (p > 0.0f) {
                            float s = (b - x[i]) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0f) {
                                s2 = s;
                            }
                            if (!(s > s3)) continue;
                            s3 = s;
                            continue;
                        }
                        if (!(p < 0.0f)) continue;
                        s3 = Float.POSITIVE_INFINITY;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        float p = d[i];
                        if (p < 0.0f) {
                            float s = (x[i] - b) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0f) {
                                s2 = s;
                            }
                            if (!(s > s3)) continue;
                            s3 = s;
                            continue;
                        }
                        if (!(p > 0.0f)) continue;
                        s3 = Float.POSITIVE_INFINITY;
                    }
                }
                break;
            }
            case 4: {
                s3 = 0.0f;
                float a = this.lo[0];
                float b = this.up[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        float s;
                        float p = d[i];
                        if (p > 0.0f) {
                            s = (b - x[i]) / p;
                        } else {
                            if (!(p < 0.0f)) continue;
                            s = (a - x[i]) / p;
                        }
                        if (s < s1) {
                            s1 = s;
                        }
                        if (s < s2 && s > 0.0f) {
                            s2 = s;
                        }
                        if (!(s > s3)) continue;
                        s3 = s;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        float s;
                        float p = d[i];
                        if (p < 0.0f) {
                            s = (x[i] - b) / p;
                        } else {
                            if (!(p > 0.0f)) continue;
                            s = (x[i] - a) / p;
                        }
                        if (s < s1) {
                            s1 = s;
                        }
                        if (s < s2 && s > 0.0f) {
                            s2 = s;
                        }
                        if (!(s > s3)) continue;
                        s3 = s;
                    }
                }
                break;
            }
            case 5: {
                s3 = 0.0f;
                float b = this.up[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        float s;
                        float p = d[i];
                        if (p > 0.0f) {
                            s = (b - x[i]) / p;
                        } else {
                            if (!(p < 0.0f)) continue;
                            s = (this.lo[i] - x[i]) / p;
                        }
                        if (s < s1) {
                            s1 = s;
                        }
                        if (s < s2 && s > 0.0f) {
                            s2 = s;
                        }
                        if (!(s > s3)) continue;
                        s3 = s;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        float s;
                        float p = d[i];
                        if (p < 0.0f) {
                            s = (x[i] - b) / p;
                        } else {
                            if (!(p > 0.0f)) continue;
                            s = (x[i] - this.lo[i]) / p;
                        }
                        if (s < s1) {
                            s1 = s;
                        }
                        if (s < s2 && s > 0.0f) {
                            s2 = s;
                        }
                        if (!(s > s3)) continue;
                        s3 = s;
                    }
                }
                break;
            }
            case 6: {
                s3 = 0.0f;
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        float p = d[i];
                        if (p > 0.0f) {
                            float s = (this.up[i] - x[i]) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0f) {
                                s2 = s;
                            }
                            if (!(s > s3)) continue;
                            s3 = s;
                            continue;
                        }
                        if (!(p < 0.0f)) continue;
                        s3 = Float.POSITIVE_INFINITY;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        float p = d[i];
                        if (p < 0.0f) {
                            float s = (x[i] - this.up[i]) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0f) {
                                s2 = s;
                            }
                            if (!(s > s3)) continue;
                            s3 = s;
                            continue;
                        }
                        if (!(p > 0.0f)) continue;
                        s3 = Float.POSITIVE_INFINITY;
                    }
                }
                break;
            }
            case 7: {
                s3 = 0.0f;
                float a = this.lo[0];
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        float s;
                        float p = d[i];
                        if (p > 0.0f) {
                            s = (this.up[i] - x[i]) / p;
                        } else {
                            if (!(p < 0.0f)) continue;
                            s = (a - x[i]) / p;
                        }
                        if (s < s1) {
                            s1 = s;
                        }
                        if (s < s2 && s > 0.0f) {
                            s2 = s;
                        }
                        if (!(s > s3)) continue;
                        s3 = s;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        float s;
                        float p = d[i];
                        if (p < 0.0f) {
                            s = (x[i] - this.up[i]) / p;
                        } else {
                            if (!(p > 0.0f)) continue;
                            s = (x[i] - a) / p;
                        }
                        if (s < s1) {
                            s1 = s;
                        }
                        if (s < s2 && s > 0.0f) {
                            s2 = s;
                        }
                        if (!(s > s3)) continue;
                        s3 = s;
                    }
                }
                break;
            }
            case 8: {
                s3 = 0.0f;
                if (orient > 0) {
                    for (int i = 0; i < n; ++i) {
                        float s;
                        float p = d[i];
                        if (p > 0.0f) {
                            s = (this.up[i] - x[i]) / p;
                        } else {
                            if (!(p < 0.0f)) continue;
                            s = (this.lo[i] - x[i]) / p;
                        }
                        if (s < s1) {
                            s1 = s;
                        }
                        if (s < s2 && s > 0.0f) {
                            s2 = s;
                        }
                        if (!(s > s3)) continue;
                        s3 = s;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        float s;
                        float p = d[i];
                        if (p < 0.0f) {
                            s = (x[i] - this.up[i]) / p;
                        } else {
                            if (!(p > 0.0f)) continue;
                            s = (x[i] - this.lo[i]) / p;
                        }
                        if (s < s1) {
                            s1 = s;
                        }
                        if (s < s2 && s > 0.0f) {
                            s2 = s;
                        }
                        if (!(s > s3)) continue;
                        s3 = s;
                    }
                }
                break;
            }
        }
        return new double[]{s1, s2, s3};
    }
}

