package plugins.tprovoost.Microscopy.MicroscopeLive;

import plugins.tprovoost.Microscopy.MicroManagerForIcy.MicroscopePlugin;

public class MicroscopeLivePlugin extends MicroscopePlugin
{
    // singleton Pattern
    static MicroscopeLive2D instance = null;

    public MicroscopeLivePlugin()
    {
        super();

        if (instance == null)
            instance = new MicroscopeLive2D(this);
    }

    @Override
    public void start()
    {
        if (instance != null)
            instance.toFront();
    }

    @Override
    public void shutdown()
    {
        super.shutdown();

        if (instance != null)
        {
            instance.shutdown();
            instance = null;
        }
    }

    @Override
    public void onExposureChanged(double newExposure)
    {
        if (instance != null)
            instance.onExposureChanged(newExposure);
    }

}
