/*
 * Decompiled with CFR 0.152.
 */
package icy.roi.edit;

import icy.roi.ROI;
import icy.roi.edit.AbstractROIEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class DefaultROIEdit
extends AbstractROIEdit {
    ROI previous;
    ROI current;

    public DefaultROIEdit(ROI previous, ROI current) {
        super(current);
        this.previous = previous;
        this.current = current.getCopy();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.getROI().copyFrom(this.previous);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        if (this.current != null) {
            this.getROI().copyFrom(this.current);
        }
    }

    @Override
    public boolean addEdit(UndoableEdit edit) {
        DefaultROIEdit defEdit;
        if (!this.isMergeable()) {
            return false;
        }
        if (edit instanceof DefaultROIEdit && (defEdit = (DefaultROIEdit)edit).getROI() == this.getROI()) {
            this.current = defEdit.current;
            return true;
        }
        return false;
    }

    @Override
    public void die() {
        super.die();
        this.previous = null;
        this.current = null;
    }
}

