/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.linalg.LinearEndomorphism;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.optim.LBFGSOperator;
import mitiv.optim.LineSearch;
import mitiv.optim.LineSearchTask;
import mitiv.optim.MoreThuenteLineSearch;
import mitiv.optim.OptimStatus;
import mitiv.optim.OptimTask;
import mitiv.optim.QuasiNewton;

public class LBFGS
extends QuasiNewton {
    protected LBFGSOperator H = null;
    private final boolean saveMemory = true;
    protected Vector x0 = null;
    protected double f0 = 0.0;
    protected Vector g0 = null;
    protected Vector p = null;
    protected double alpha;
    protected double dg0 = 0.0;
    protected double gnorm = 0.0;

    public LBFGS(VectorSpace space, int m) {
        this(new LBFGSOperator(space, m), (LineSearch)new MoreThuenteLineSearch(1.0E-4, 0.9, SXTOL));
    }

    public LBFGS(VectorSpace space, int m, LineSearch lnsrch) {
        this(new LBFGSOperator(space, m), lnsrch);
    }

    public LBFGS(LinearEndomorphism H0, int m, LineSearch lnsrch) {
        this(new LBFGSOperator(H0, m), lnsrch);
    }

    private LBFGS(LBFGSOperator H, LineSearch lnsrch) {
        super(H.getSpace(), lnsrch);
        this.H = H;
        this.p = H.getSpace().create();
        this.getClass();
    }

    @Override
    public OptimTask start() {
        this.evaluations = 0;
        this.iterations = 0;
        this.restarts = 0;
        return this.begin();
    }

    @Override
    public OptimTask restart() {
        ++this.restarts;
        return this.begin();
    }

    private OptimTask begin() {
        this.H.reset();
        return this.success(OptimTask.COMPUTE_FG);
    }

    @Override
    public OptimTask iterate(Vector x, double f, Vector g) {
        switch (this.getTask()) {
            case COMPUTE_FG: {
                double gtest;
                ++this.evaluations;
                if (this.evaluations > 1) {
                    LineSearchTask lnsrchTask = this.lnsrch.iterate(f, -this.p.dot(g));
                    if (lnsrchTask == LineSearchTask.SEARCH) {
                        return this.nextStep(x);
                    }
                    if (lnsrchTask != LineSearchTask.CONVERGENCE) {
                        OptimStatus lnsrchStatus = this.lnsrch.getStatus();
                        if (lnsrchTask != LineSearchTask.WARNING || lnsrchStatus != OptimStatus.ROUNDING_ERRORS_PREVENT_PROGRESS) {
                            return this.failure(lnsrchStatus);
                        }
                    }
                    ++this.iterations;
                }
                this.gnorm = g.norm2();
                if (this.evaluations == 1) {
                    this.ginit = this.gnorm;
                }
                return this.success(this.gnorm <= (gtest = this.getGradientThreshold(this.ginit)) ? OptimTask.FINAL_X : OptimTask.NEW_X);
            }
            case NEW_X: 
            case FINAL_X: {
                if (this.iterations >= 1) {
                    this.H.update(x, this.x0, g, this.g0);
                }
                while (true) {
                    this.H.apply(this.p, g);
                    this.dg0 = -this.p.dot(g);
                    if (this.checkSufficientDescent(this.dg0, this.gnorm, this.p)) break;
                    if (this.H.mp < 1) {
                        return this.failure(OptimStatus.BAD_PRECONDITIONER);
                    }
                    this.H.reset();
                    ++this.restarts;
                }
                this.alpha = this.initialStep(x, this.gnorm);
                this.x0 = this.H.s(0);
                this.g0 = this.H.y(0);
                if (this.H.mp == this.H.m) {
                    --this.H.mp;
                }
                this.x0.copy(x);
                this.g0.copy(g);
                this.f0 = f;
                LineSearchTask lnsrchTask = this.lnsrch.start(this.f0, this.dg0, this.alpha, this.stpmin * this.alpha, this.stpmax * this.alpha);
                if (lnsrchTask != LineSearchTask.SEARCH) {
                    return this.failure(this.lnsrch.getStatus());
                }
                return this.nextStep(x);
            }
        }
        return this.getTask();
    }

    protected double initialStep(Vector x, double dnorm) {
        double xnorm;
        if (this.H.mp >= 1 || this.H.rule == 0) {
            return 1.0;
        }
        if (0.0 < this.delta && this.delta < 1.0 && (xnorm = x.norm2()) > 0.0) {
            return xnorm / dnorm * this.delta;
        }
        return 1.0 / dnorm;
    }

    private OptimTask nextStep(Vector x) {
        this.alpha = this.lnsrch.getStep();
        x.combine(1.0, this.x0, -this.alpha, this.p);
        return this.success(OptimTask.COMPUTE_FG);
    }
}

