/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component;

import icy.gui.component.ui.RangeSliderUI;
import javax.swing.JSlider;
import javax.swing.plaf.SliderUI;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;

public class RangeSlider
extends JSlider {
    private static final long serialVersionUID = 2079286476964629269L;

    public RangeSlider(int orientation, int min, int max, int low, int high) {
        super(orientation, min, max, low);
        super.setFocusable(false);
        this.setExtent(high);
    }

    public RangeSlider(int min, int max, int low, int high) {
        this(0, min, max, low, high);
    }

    public RangeSlider(int min, int max) {
        this(0, min, max, (min + max) / 2, 0);
    }

    public RangeSlider(int orientation) {
        this(orientation, 0, 100, 40, 20);
    }

    public RangeSlider() {
        this(0, 0, 100, 40, 20);
    }

    @Override
    public void setFocusable(boolean focusable) {
        super.setFocusable(false);
    }

    @Override
    public void updateUI() {
        if (SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            this.setUI((SliderUI)((Object)new RangeSliderUI(this)));
            this.updateLabelUIs();
        } else {
            super.updateUI();
        }
    }

    @Override
    public int getValue() {
        return super.getValue();
    }

    @Override
    public void setValue(int value) {
        int oldValue = this.getValue();
        if (oldValue == value) {
            return;
        }
        int oldExtent = this.getExtent();
        int newValue = Math.min(Math.max(this.getMinimum(), value), oldValue + oldExtent);
        int newExtent = oldExtent + oldValue - newValue;
        this.getModel().setRangeProperties(newValue, newExtent, this.getMinimum(), this.getMaximum(), this.getValueIsAdjusting());
    }

    public int getLowerValue() {
        return this.getValue();
    }

    public void setLowerValue(int value) {
        this.setValue(value);
    }

    public int getUpperValue() {
        return this.getValue() + this.getExtent();
    }

    public void setUpperValue(int value) {
        int lowerValue = this.getValue();
        int newExtent = Math.min(Math.max(0, value - lowerValue), this.getMaximum() - lowerValue);
        this.setExtent(newExtent);
    }
}

