/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.preferences;

import icy.gui.preferences.PreferenceFrame;
import icy.gui.util.ComponentUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.tree.DefaultMutableTreeNode;

public abstract class PreferencePanel
extends JPanel {
    private static final long serialVersionUID = 4602116758638991276L;
    protected final PreferenceFrame parentFrame;
    protected final String parentName;
    protected final DefaultMutableTreeNode node;
    protected final JPanel mainPanel;

    public PreferencePanel(PreferenceFrame parentFrame, String name, String parentName) {
        this.setName(name);
        this.parentFrame = parentFrame;
        this.parentName = parentName;
        this.node = new DefaultMutableTreeNode(name);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 3));
        JLabel titleLabel = new JLabel("  " + name);
        ComponentUtil.increaseFontSize(titleLabel, 2);
        ComponentUtil.setFontBold(titleLabel);
        topPanel.add(Box.createVerticalStrut(6));
        topPanel.add(titleLabel);
        topPanel.add(Box.createVerticalStrut(6));
        topPanel.add(new JSeparator(0));
        this.mainPanel = new JPanel();
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setLayout(new BorderLayout());
        this.add((Component)topPanel, "North");
        this.add((Component)this.mainPanel, "Center");
    }

    protected void closed() {
    }

    public PreferenceFrame getPreferenceFrame() {
        return this.parentFrame;
    }

    public PreferencePanel getPreferencePanel(Class<? extends PreferencePanel> type) {
        for (PreferencePanel panel : this.parentFrame.preferencePanels) {
            if (!type.isInstance(panel)) continue;
            return panel;
        }
        return null;
    }

    public DefaultMutableTreeNode getNode() {
        return this.node;
    }

    public String getParentName() {
        return this.parentName;
    }

    protected abstract void load();

    protected abstract void save();
}

