/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.main;

import icy.gui.frame.IcyInternalFrame;
import icy.gui.util.ComponentUtil;
import icy.gui.util.LookAndFeelUtil;
import icy.gui.viewer.Viewer;
import icy.main.Icy;
import icy.math.HungarianAlgorithm;
import icy.resource.ResourceUtil;
import icy.util.GraphicsUtil;
import icy.util.Random;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class IcyDesktopPane
extends JDesktopPane
implements ContainerListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final long serialVersionUID = 7914161180763257329L;
    private final ComponentAdapter componentAdapter;
    private final ArrayList<DesktopOverlay> overlays = new ArrayList();

    public IcyDesktopPane() {
        this.componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                IcyDesktopPane.this.checkPosition((JInternalFrame)e.getSource());
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                IcyDesktopPane.this.checkPosition((JInternalFrame)e.getSource());
            }
        };
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addContainerListener(this);
        this.overlays.add(new BackgroundDesktopOverlay());
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth();
        int h = this.getHeight();
        for (DesktopOverlay overlay : this.overlays) {
            overlay.paint(g, w, h);
        }
    }

    private void registerFrame(JInternalFrame frame) {
        frame.addComponentListener(this.componentAdapter);
    }

    void unregisterFrame(JInternalFrame frame) {
        frame.removeComponentListener(this.componentAdapter);
    }

    void checkPosition(JInternalFrame frame) {
        Rectangle rect = frame.getBounds();
        if (this.fixPosition(rect)) {
            frame.setBounds(rect);
        }
    }

    boolean fixPosition(Rectangle rect) {
        int limit = this.getY();
        if (rect.y < limit) {
            rect.y = limit;
            return true;
        }
        return false;
    }

    public static Viewer[] getInternalViewers(boolean wantNotVisible, boolean wantIconized) {
        ArrayList<Viewer> result = new ArrayList<Viewer>();
        for (Viewer viewer : Icy.getMainInterface().getViewers()) {
            if (!viewer.isInternalized()) continue;
            IcyInternalFrame internalFrame = viewer.getIcyInternalFrame();
            if (!wantNotVisible && !internalFrame.isVisible() || !wantIconized && internalFrame.isIcon()) continue;
            result.add(viewer);
        }
        return result.toArray(new Viewer[result.size()]);
    }

    public void organizeCascade() {
        Viewer[] viewers = IcyDesktopPane.getInternalViewers(false, false);
        int w = this.getWidth();
        int h = this.getHeight() - 32;
        int fw = (int)((float)w * 0.6f);
        int fh = (int)((float)h * 0.6f);
        int xMax = w - 0;
        int yMax = h - 0;
        int x = 32;
        int y = 32;
        for (Viewer v : viewers) {
            IcyInternalFrame internalFrame = v.getIcyInternalFrame();
            if (internalFrame.isMaximized()) {
                internalFrame.setMaximized(false);
            }
            internalFrame.setBounds(x, y, fw, fh);
            internalFrame.toFront();
            y += 20;
            if ((x += 30) + fw > xMax) {
                x = 32;
            }
            if (y + fh <= yMax) continue;
            y = 32;
        }
    }

    public void organizeTile(int type) {
        int numLine;
        int numCol;
        Viewer[] viewers = IcyDesktopPane.getInternalViewers(false, false);
        int numFrames = viewers.length;
        if (numFrames == 0) {
            return;
        }
        int w = this.getWidth();
        int h = this.getHeight() - 32;
        switch (type) {
            case 0: {
                numCol = 1;
                numLine = numFrames;
                break;
            }
            case 1: {
                numCol = numFrames;
                numLine = 1;
                break;
            }
            default: {
                numCol = (int)Math.sqrt(numFrames);
                if (numFrames != numCol * numCol) {
                    ++numCol;
                }
                if (numFrames <= numCol * (numLine = numFrames / numCol)) break;
                ++numLine;
            }
        }
        double[][] framesDistances = new double[numCol * numLine][numFrames];
        int dx = w / numCol;
        int dy = h / numLine;
        int k = 0;
        for (int i = 0; i < numLine; ++i) {
            int j = 0;
            while (j < numCol) {
                double[] distances = framesDistances[k];
                double x = (double)(j * dx) + (double)dx / 2.0;
                double y = (double)(i * dy) + (double)dy / 2.0;
                for (int f = 0; f < numFrames; ++f) {
                    Point2D.Double center = ComponentUtil.getCenter(viewers[f].getInternalFrame());
                    distances[f] = Point2D.distanceSq(center.x, center.y, x, y);
                }
                ++j;
                ++k;
            }
        }
        int[] framePos = new HungarianAlgorithm(framesDistances).resolve();
        k = 0;
        for (int i = 0; i < numLine; ++i) {
            int j = 0;
            while (j < numCol) {
                int f = framePos[k];
                if (f < numFrames) {
                    IcyInternalFrame internalFrame = viewers[f].getIcyInternalFrame();
                    if (internalFrame.isMaximized()) {
                        internalFrame.setMaximized(false);
                    }
                    internalFrame.setBounds(j * dx, i * dy, dx, dy);
                    internalFrame.toFront();
                }
                ++j;
                ++k;
            }
        }
    }

    @Deprecated
    public void organizeTile() {
        this.organizeTile(2);
    }

    public void addOverlay(DesktopOverlay overlay) {
        if (!this.overlays.contains(overlay)) {
            this.overlays.add(overlay);
        }
    }

    public boolean removeOverlay(DesktopOverlay overlay) {
        return this.overlays.remove(overlay);
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        Component comp = e.getChild();
        if (comp instanceof JInternalFrame) {
            this.registerFrame((JInternalFrame)comp);
        }
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        Component comp = e.getChild();
        if (comp instanceof JInternalFrame) {
            this.unregisterFrame((JInternalFrame)comp);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        for (DesktopOverlay overlay : this.overlays) {
            overlay.mouseWheelMoved(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        for (DesktopOverlay overlay : this.overlays) {
            overlay.mouseDragged(e);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        for (DesktopOverlay overlay : this.overlays) {
            overlay.mouseMoved(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        for (DesktopOverlay overlay : this.overlays) {
            overlay.mouseClicked(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        for (DesktopOverlay overlay : this.overlays) {
            overlay.mousePressed(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        for (DesktopOverlay overlay : this.overlays) {
            overlay.mouseReleased(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        for (DesktopOverlay overlay : this.overlays) {
            overlay.mouseEntered(e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        for (DesktopOverlay overlay : this.overlays) {
            overlay.mouseExited(e);
        }
    }

    public class BackgroundDesktopOverlay
    extends AbstractDesktopOverlay
    implements ImageObserver {
        private static final String BACKGROUND_PATH = "background/";
        private final Image backGround = ResourceUtil.getImage("background/" + Integer.toString(Random.nextInt(1)) + ".jpg");
        private final Image icyLogo = ResourceUtil.getImage("logoICY.png");
        private final Color textColor = new Color(0.0f, 0.0f, 0.0f, 0.5f);
        private final Color bgTextColor = new Color(1.0f, 1.0f, 1.0f, 0.5f);

        @Override
        public void paint(Graphics g, int width, int height) {
            IcyDesktopPane desktop = Icy.getMainInterface().getDesktopPane();
            Color bgColor = desktop != null ? LookAndFeelUtil.getBackground(desktop) : Color.lightGray;
            int bgImgWidth = this.backGround.getWidth(this);
            int bgImgHeight = this.backGround.getHeight(this);
            double scale = Math.max((double)width / (double)bgImgWidth, (double)height / (double)bgImgHeight) * 1.5;
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setBackground(bgColor);
            g2.clearRect(0, 0, width, height);
            g2.setComposite(AlphaComposite.getInstance(10, 0.2f));
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(this.backGround, 0, 0, (int)(scale * (double)bgImgWidth), (int)(scale * (double)bgImgHeight), bgColor, this);
            String text = "Version " + Icy.version;
            int textWidth = (int)GraphicsUtil.getStringBounds(g, text).getWidth();
            g2.setComposite(AlphaComposite.getInstance(10, 0.7f));
            g2.setColor(this.bgTextColor);
            g2.drawString(text, width - (textWidth + 31), height - 8);
            g2.setColor(this.textColor);
            g2.drawString(text, width - (textWidth + 30), height - 9);
            g2.drawImage(this.icyLogo, width - 220, height - 130, this);
            g2.dispose();
        }

        @Override
        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            if ((infoflags & 0x20) != 0) {
                IcyDesktopPane.this.repaint();
                return false;
            }
            return true;
        }
    }

    public static class AbstractDesktopOverlay
    extends MouseAdapter
    implements DesktopOverlay {
        @Override
        public void paint(Graphics g, int width, int height) {
        }
    }

    public static interface DesktopOverlay
    extends MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        public void paint(Graphics var1, int var2, int var3);
    }
}

