/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;

public class SEQReader
extends BaseTiffReader {
    private static final int IMAGE_PRO_TAG_1 = 50288;
    private static final int IMAGE_PRO_TAG_2 = 40105;
    private static final int IMAGE_PRO_TAG_3 = 40100;
    private String[] files = null;

    public SEQReader() {
        super("Image-Pro Sequence", new String[]{"seq", "ips"});
        this.domains = new String[]{"Unknown"};
        this.suffixSufficient = false;
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (SEQReader.checkSuffix(name, "ips")) {
            return true;
        }
        return super.isThisType(name, open);
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser parser = new TiffParser(stream);
        parser.setDoCaching(false);
        IFD ifd = parser.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        parser.fillInIFD(ifd);
        Object tag1 = ifd.get(50288);
        Object tag3 = ifd.get(40100);
        return tag1 != null && tag1 instanceof short[] || tag3 != null && tag3 instanceof int[];
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        if (this.files == null) {
            return super.getSeriesUsedFiles(noPixels);
        }
        if (noPixels) {
            return new String[]{this.getCurrentFile()};
        }
        String[] seriesFiles = new String[this.files.length / this.core.size() + 1];
        seriesFiles[0] = this.getCurrentFile();
        int[] coords = new int[]{0, 0, this.getCoreIndex(), 0};
        int[] lengths = new int[]{this.getSizeZ(), this.getEffectiveSizeC(), this.core.size(), this.getSizeT()};
        int next = 1;
        for (int t = 0; t < this.getSizeT(); ++t) {
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                int z = 0;
                while (z < this.getSizeZ()) {
                    coords[0] = z++;
                    coords[1] = c;
                    coords[3] = t;
                    int index = FormatTools.positionToRaster(lengths, coords);
                    seriesFiles[next++] = this.files[index];
                }
            }
        }
        return seriesFiles;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.files = null;
        }
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        if (this.files == null) {
            return super.openBytes(no, buf, x, y, w, h2);
        }
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        int[] zct = this.getZCTCoords(no);
        int[] coords = new int[]{zct[0], zct[1], this.getCoreIndex(), zct[2]};
        int[] lengths = new int[]{this.getSizeZ(), this.getEffectiveSizeC(), this.core.size(), this.getSizeT()};
        int index = FormatTools.positionToRaster(lengths, coords);
        try (RandomAccessInputStream in = new RandomAccessInputStream(this.files[index]);){
            TiffParser p = new TiffParser(in);
            IFD ifd = p.getFirstIFD();
            p.getSamples(ifd, buf, x, y, w, h2);
        }
        return buf;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        if (!SEQReader.checkSuffix(id, "ips")) {
            super.initFile(id);
            return;
        }
        this.in = new RandomAccessInputStream(id);
        this.in.order(true);
        this.in.seek(27L);
        int channelCount = this.in.readInt();
        String[] channelNames = new String[channelCount];
        for (int c = 0; c < channelCount; ++c) {
            channelNames[c] = this.in.readString(this.in.read());
        }
        int fileCount = this.in.readInt();
        String[] pixelsFiles = new String[fileCount];
        Location current = new Location(id).getAbsoluteFile();
        String ips = current.getAbsolutePath();
        Location parent = current.getParentFile();
        for (int f = 0; f < fileCount; ++f) {
            pixelsFiles[f] = this.in.readString(this.in.read());
            pixelsFiles[f] = new Location(parent, pixelsFiles[f]).getAbsolutePath();
        }
        int tCount = this.in.readInt();
        int posCount = this.in.readInt();
        int unknownCount = this.in.readInt();
        int zCount = this.in.readInt();
        this.initFile(pixelsFiles[0]);
        this.currentId = ips;
        this.files = pixelsFiles;
        CoreMetadata m3 = (CoreMetadata)this.core.get(0, 0);
        m3.sizeT = tCount;
        m3.sizeZ = zCount;
        m3.sizeC *= channelCount;
        m3.imageCount *= this.getSizeZ() * this.getSizeT() * channelCount;
        for (int i = 1; i < posCount; ++i) {
            this.core.add(new CoreMetadata(m3));
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        for (int i = 0; i < posCount; ++i) {
            for (int c = 0; c < channelCount; ++c) {
                store.setChannelName(channelNames[c], i, c);
            }
        }
    }

    @Override
    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        CoreMetadata m3 = (CoreMetadata)this.core.get(0, 0);
        m3.sizeZ = 0;
        m3.sizeT = 0;
        MetadataLevel level = this.getMetadataOptions().getMetadataLevel();
        for (IFD ifd : this.ifds) {
            int tag2;
            short[] tag1;
            if (level != MetadataLevel.MINIMUM && (tag1 = (short[])ifd.getIFDValue(50288)) != null) {
                StringBuilder seqId = new StringBuilder();
                for (int i = 0; i < tag1.length; ++i) {
                    seqId.append(tag1[i]);
                }
                this.addGlobalMeta("Image-Pro SEQ ID", seqId.toString());
            }
            if ((tag2 = ((IFD)this.ifds.get(0)).getIFDIntValue(40105)) != -1) {
                ++m3.sizeZ;
                this.addGlobalMeta("Frame Rate", tag2);
            }
            this.addGlobalMeta("Number of images", this.getSizeZ());
        }
        if (this.getSizeZ() == 0) {
            m3.sizeZ = 1;
        }
        if (this.getSizeT() == 0) {
            m3.sizeT = 1;
        }
        if (this.getSizeZ() == 1 && this.getSizeT() == 1) {
            m3.sizeZ = this.ifds.size();
        }
        this.addGlobalMeta("frames", this.getSizeZ());
        this.addGlobalMeta("channels", super.getSizeC());
        this.addGlobalMeta("slices", this.getSizeT());
        String descr = ((IFD)this.ifds.get(0)).getComment();
        this.metadata.remove("Comment");
        if (descr != null) {
            String[] lines;
            for (String token : lines = descr.split("\n")) {
                int eq = (token = token.trim()).indexOf(61);
                if (eq == -1) {
                    eq = token.indexOf(58);
                }
                if (eq == -1) continue;
                String label = token.substring(0, eq);
                String data = token.substring(eq + 1);
                this.addGlobalMeta(label, data);
                if (label.equals("channels")) {
                    m3.sizeC = Integer.parseInt(data);
                    continue;
                }
                if (label.equals("frames")) {
                    m3.sizeT = Integer.parseInt(data);
                    continue;
                }
                if (!label.equals("slices")) continue;
                m3.sizeZ = Integer.parseInt(data);
            }
        }
        if (this.isRGB() && this.getSizeC() != 3) {
            m3.sizeC *= 3;
        }
        m3.dimensionOrder = "XY";
        int maxNdx = 0;
        int max = 0;
        int[] dims = new int[]{this.getSizeZ(), this.getSizeC(), this.getSizeT()};
        String[] axes = new String[]{"Z", "C", "T"};
        for (int i = 0; i < dims.length; ++i) {
            if (dims[i] <= max) continue;
            max = dims[i];
            maxNdx = i;
        }
        m3.dimensionOrder = m3.dimensionOrder + axes[maxNdx];
        if (maxNdx != 1) {
            if (this.getSizeC() > 1) {
                m3.dimensionOrder = m3.dimensionOrder + 'C';
                m3.dimensionOrder = m3.dimensionOrder + (maxNdx == 0 ? axes[2] : axes[0]);
            } else {
                m3.dimensionOrder = m3.dimensionOrder + (maxNdx == 0 ? axes[2] : axes[0]) + "C";
            }
        } else {
            m3.dimensionOrder = this.getSizeZ() > this.getSizeT() ? m3.dimensionOrder + "ZT" : m3.dimensionOrder + "TZ";
        }
    }
}

