package plugins.tprovoost.painting.shapes;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.ArrayList;

import plugins.tprovoost.painting.PaintingTools;

public class Cloud extends PaintingShape
{

    ArrayList<Point> list = new ArrayList<Point>();

    public Cloud(PaintingTools tools)
    {
        this(tools, null);
    }

    public Cloud(PaintingTools tools, Point p)
    {
        super(tools);

        setStroke(new BasicStroke(getThickness(), BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
        shape = new GeneralPath();

        if (p != null)
            update(p);
    }

    @Override
    public void update(Point p)
    {
        list.add(p);
        GeneralPath path = new GeneralPath();
        for (int i = 0; i < list.size() - 1; ++i)
        {
            Point p1 = list.get(i);
            Point p2 = list.get(i + 1);
            path.append(new Line2D.Double(p1.x, p1.y, p2.x, p2.y), true);
        }
        shape = path;
    }

    @Override
    public void drawShape(Graphics2D g)
    {
        final Graphics2D g2 = (Graphics2D) g.create();

        g2.setColor(getShapeColor());

        if (fill)
        {
            if (list.size() == 1)
            {
                Point p = list.get(0);
                g2.drawLine(p.x, p.y, p.x, p.y);
            }
            else
                g2.fill(shape);
        }
        else
        {
            if (list.size() == 1)
            {
                Point p = list.get(0);
                g2.drawLine(p.x, p.y, p.x, p.y);
            }
            else
                g2.draw(shape);
        }

        g2.dispose();
    }
}
