/*
 * Decompiled with CFR 0.152.
 */
package icy.math;

import icy.math.ArrayMath;
import java.util.Arrays;

public class HungarianAlgorithm {
    final int numRow;
    final int numCol;
    final int k;
    final double[][] costs;
    final int[] rowsStar;
    final int[] colsStar;
    final int[] rowsPrime;
    final boolean[] rowsCovered;
    final boolean[] colsCovered;
    final int[] colsUnStar;
    final int[] rowsDoStar;
    int step;
    boolean done;

    public HungarianAlgorithm(double[][] values) {
        int r;
        int initialNumCol = values[0].length;
        this.numRow = values.length;
        this.numCol = Math.max(initialNumCol, this.numRow);
        this.k = Math.min(this.numRow, this.numCol);
        this.costs = new double[this.numRow][this.numCol];
        double max = values[0][0];
        if (initialNumCol < this.numRow) {
            for (r = 0; r < values.length; ++r) {
                double v = ArrayMath.max(values[r]);
                if (!(v > max)) continue;
                max = v;
            }
        }
        for (r = 0; r < values.length; ++r) {
            int c;
            double[] rowValues = values[r];
            double[] rowCosts = this.costs[r];
            for (c = 0; c < rowValues.length; ++c) {
                rowCosts[c] = rowValues[c];
            }
            while (c < this.numCol) {
                rowCosts[c] = max;
                ++c;
            }
        }
        this.rowsStar = new int[this.numRow];
        this.colsStar = new int[this.numCol];
        this.rowsPrime = new int[this.numRow];
        this.rowsCovered = new boolean[this.numRow];
        this.colsCovered = new boolean[this.numCol];
        this.colsUnStar = new int[this.numCol];
        this.rowsDoStar = new int[this.numRow];
        Arrays.fill(this.rowsPrime, -1);
    }

    public int[] resolve() {
        this.initialReduce();
        this.done = false;
        this.step = 2;
        while (!this.done) {
            switch (this.step) {
                case 2: {
                    this.updateStar();
                    break;
                }
                case 3: {
                    this.doColCover();
                    break;
                }
                case 4: {
                    this.doPrime();
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    this.reduce();
                }
            }
        }
        return this.rowsStar;
    }

    private void initialReduce() {
        for (int r = 0; r < this.numRow; ++r) {
            double[] rowCosts = this.costs[r];
            double min = ArrayMath.min(rowCosts);
            int c = 0;
            while (c < this.numCol) {
                int n = c++;
                rowCosts[n] = rowCosts[n] - min;
            }
        }
    }

    private void updateStar() {
        Arrays.fill(this.rowsStar, -1);
        Arrays.fill(this.colsStar, -1);
        for (int r = 0; r < this.numRow; ++r) {
            this.updateRowStar(r);
        }
        this.step = 3;
    }

    private void updateRowStar(int r) {
        double[] rowCosts = this.costs[r];
        for (int c = 0; c < this.numCol; ++c) {
            if (this.colsStar[c] != -1 || rowCosts[c] != 0.0) continue;
            this.rowsStar[r] = c;
            this.colsStar[c] = r;
            return;
        }
    }

    private void doColCover() {
        Arrays.fill(this.colsCovered, false);
        int numColCovered = 0;
        for (int c = 0; c < this.numCol; ++c) {
            if (this.colsStar[c] == -1) continue;
            this.colsCovered[c] = true;
            ++numColCovered;
        }
        if (numColCovered == this.k) {
            this.done = true;
        } else {
            this.step = 4;
        }
    }

    private void doPrime() {
        for (int c = 0; c < this.numCol; ++c) {
            if (this.colsCovered[c] || !this.doPrimCol(c)) continue;
            return;
        }
        this.step = 6;
    }

    private boolean doPrimCol(int c) {
        for (int r = 0; r < this.numRow; ++r) {
            if (this.rowsCovered[r] || this.costs[r][c] != 0.0) continue;
            this.rowsPrime[r] = c;
            int starCol = this.rowsStar[r];
            if (starCol == -1) {
                this.convertPrimeToStar(r, c);
                return true;
            }
            this.rowsCovered[r] = true;
            this.colsCovered[starCol] = false;
            if (starCol >= c || !this.doPrimCol(starCol)) continue;
            return true;
        }
        return false;
    }

    private void convertPrimeToStar(int r, int c) {
        int i;
        int nb = 0;
        int primeCol = c;
        int starRow = this.colsStar[primeCol];
        while (starRow != -1) {
            this.colsUnStar[nb] = primeCol;
            this.rowsDoStar[nb] = starRow;
            ++nb;
            primeCol = this.rowsPrime[starRow];
            starRow = this.colsStar[primeCol];
        }
        for (i = 0; i < nb; ++i) {
            int startCol = this.colsUnStar[i];
            this.rowsStar[this.colsStar[startCol]] = -1;
            this.colsStar[startCol] = -1;
        }
        for (i = 0; i < nb; ++i) {
            int primeRow = this.rowsDoStar[i];
            int pc = this.rowsPrime[primeRow];
            this.colsStar[pc] = primeRow;
            this.rowsStar[primeRow] = pc;
        }
        this.colsStar[c] = r;
        this.rowsStar[r] = c;
        Arrays.fill(this.rowsPrime, -1);
        Arrays.fill(this.rowsCovered, false);
        Arrays.fill(this.colsCovered, false);
        this.step = 3;
    }

    private void reduce() {
        int c;
        double[] rowCosts;
        int r;
        double min = Double.MAX_VALUE;
        for (r = 0; r < this.numRow; ++r) {
            if (this.rowsCovered[r]) continue;
            rowCosts = this.costs[r];
            for (c = 0; c < this.numCol; ++c) {
                double v;
                if (this.colsCovered[c] || !((v = rowCosts[c]) < min)) continue;
                min = v;
            }
        }
        for (r = 0; r < this.numRow; ++r) {
            rowCosts = this.costs[r];
            if (this.rowsCovered[r]) {
                for (c = 0; c < this.numCol; ++c) {
                    if (!this.colsCovered[c]) continue;
                    int n = c;
                    rowCosts[n] = rowCosts[n] + min;
                }
                continue;
            }
            for (c = 0; c < this.numCol; ++c) {
                if (this.colsCovered[c]) continue;
                int n = c;
                rowCosts[n] = rowCosts[n] - min;
            }
        }
        this.step = 4;
    }
}

