/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.av;

import com.jogamp.opengl.util.TimeFrameI;
import java.nio.ByteBuffer;
import jogamp.opengl.Debug;

public interface AudioSink {
    public static final boolean DEBUG = Debug.debug("AudioSink");
    public static final int DefaultFrameDuration = 32;
    public static final int DefaultInitialQueueSize = 512;
    public static final int DefaultQueueGrowAmount = 512;
    public static final int DefaultQueueLimitWithVideo = 3072;
    public static final int DefaultQueueLimitAudioOnly = 1024;
    public static final AudioFormat DefaultFormat = new AudioFormat(44100, 16, 2, true, true, false, true);

    public boolean isInitialized();

    public float getPlaySpeed();

    public boolean setPlaySpeed(float var1);

    public float getVolume();

    public boolean setVolume(float var1);

    public AudioFormat getPreferredFormat();

    public int getMaxSupportedChannels();

    public boolean isSupported(AudioFormat var1);

    public boolean init(AudioFormat var1, float var2, int var3, int var4, int var5);

    public AudioFormat getChosenFormat();

    public boolean isPlaying();

    public void play();

    public void pause();

    public void flush();

    public void destroy();

    public int getFrameCount();

    public int getEnqueuedFrameCount();

    public int getQueuedFrameCount();

    public int getQueuedByteCount();

    public int getQueuedTime();

    public int getPTS();

    public int getFreeFrameCount();

    public AudioFrame enqueueData(int var1, ByteBuffer var2, int var3);

    public static class AudioDataFrame
    extends AudioFrame {
        protected final ByteBuffer data;

        public AudioDataFrame(int n, int n2, ByteBuffer byteBuffer, int n3) {
            super(n, n2, n3);
            if (n3 > byteBuffer.remaining()) {
                throw new IllegalArgumentException("Give size " + n3 + " exceeds remaining bytes in ls " + byteBuffer + ". " + this);
            }
            this.data = byteBuffer;
        }

        public final ByteBuffer getData() {
            return this.data;
        }

        @Override
        public String toString() {
            return "AudioDataFrame[pts " + this.pts + " ms, l " + this.duration + " ms, " + this.byteSize + " bytes, " + this.data + "]";
        }
    }

    public static abstract class AudioFrame
    extends TimeFrameI {
        protected int byteSize;

        public AudioFrame() {
            this.byteSize = 0;
        }

        public AudioFrame(int n, int n2, int n3) {
            super(n, n2);
            this.byteSize = n3;
        }

        public final int getByteSize() {
            return this.byteSize;
        }

        public final void setByteSize(int n) {
            this.byteSize = n;
        }

        @Override
        public String toString() {
            return "AudioFrame[pts " + this.pts + " ms, l " + this.duration + " ms, " + this.byteSize + " bytes]";
        }
    }

    public static class AudioFormat {
        public final int sampleRate;
        public final int sampleSize;
        public final int channelCount;
        public final boolean signed;
        public final boolean fixedP;
        public final boolean planar;
        public final boolean littleEndian;

        public AudioFormat(int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.sampleRate = n;
            this.sampleSize = n2;
            this.channelCount = n3;
            this.signed = bl;
            this.fixedP = bl2;
            this.planar = bl3;
            this.littleEndian = bl4;
            if (!bl2) {
                if (n2 != 32 && n2 != 64) {
                    throw new IllegalArgumentException("Floating point: sampleSize " + n2 + " bits");
                }
                if (!bl) {
                    throw new IllegalArgumentException("Floating point: unsigned");
                }
            }
        }

        public final int getDurationsByteSize(int n) {
            int n2 = this.sampleSize >>> 3;
            return n * (this.channelCount * n2 * (this.sampleRate / 1000));
        }

        public final int getBytesDuration(int n) {
            int n2 = this.sampleSize >>> 3;
            return n / (this.channelCount * n2 * (this.sampleRate / 1000));
        }

        public final float getSamplesDuration(int n) {
            return 1000.0f * (float)n / (float)this.sampleRate;
        }

        public final int getFrameCount(int n, float f) {
            return Math.max(1, (int)((float)n / f + 0.5f));
        }

        public final int getSamplesByteCount(int n) {
            return n * (this.sampleSize >>> 3);
        }

        public final int getBytesSampleCount(int n) {
            return (n << 3) / this.sampleSize;
        }

        public String toString() {
            return "AudioDataFormat[sampleRate " + this.sampleRate + ", sampleSize " + this.sampleSize + ", channelCount " + this.channelCount + ", signed " + this.signed + ", fixedP " + this.fixedP + ", " + (this.planar ? "planar" : "packed") + ", " + (this.littleEndian ? "little" : "big") + "-endian]";
        }
    }
}

