/*
 * Decompiled with CFR 0.152.
 */
package icy.type.geom;

import icy.type.geom.BoxShape3D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;

public class Cylinder3D
extends BoxShape3D {
    public Ellipse2D.Double ellipse;
    public double z;
    public double sizeZ;

    public Cylinder3D(double x, double y, double z, double sizeX, double sizeY, double sizeZ) {
        this.ellipse = new Ellipse2D.Double(x, y, sizeX, sizeY);
        this.z = z;
        this.sizeZ = sizeZ;
    }

    public Cylinder3D(BoxShape3D boxShape) {
        this(boxShape.getX(), boxShape.getY(), boxShape.getZ(), boxShape.getSizeX(), boxShape.getSizeY(), boxShape.getSizeZ());
    }

    public Cylinder3D(Ellipse2D e, double z, double sizeZ) {
        this(e.getX(), e.getY(), z, e.getWidth(), e.getHeight(), sizeZ);
    }

    public Cylinder3D() {
        this(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public double getX() {
        return this.ellipse.getX();
    }

    @Override
    public double getY() {
        return this.ellipse.getY();
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public double getSizeX() {
        return this.ellipse.getWidth();
    }

    @Override
    public double getSizeY() {
        return this.ellipse.getHeight();
    }

    @Override
    public double getSizeZ() {
        return this.sizeZ;
    }

    @Override
    public void setZ(double value) {
        this.z = value;
    }

    @Override
    public void setSizeZ(double value) {
        this.sizeZ = value;
    }

    @Override
    public boolean isEmpty() {
        return this.ellipse.isEmpty() || this.getSizeZ() <= 0.0;
    }

    @Override
    public void setFrame(double x, double y, double z, double sx, double sy, double sz) {
        this.ellipse.setFrame(x, y, sx, sy);
        this.z = z;
        this.sizeZ = sz;
    }

    @Override
    public boolean contains(double x, double y, double z) {
        return this.ellipse.contains(x, y) && this.containsZ(z);
    }

    @Override
    public boolean intersects(double x, double y, double z, double sizeX, double sizeY, double sizeZ) {
        return this.ellipse.intersects(x, y, sizeX, sizeY) && this.intersectsZ(z, sizeZ);
    }

    @Override
    public boolean contains(double x, double y, double z, double sizeX, double sizeY, double sizeZ) {
        return this.ellipse.contains(sizeX, y, sizeX, sizeY) && this.containsZ(z, sizeZ);
    }

    @Override
    public Shape getShape2D() {
        return new Ellipse2D.Double(this.getX(), this.getY(), this.getSizeX(), this.getSizeY());
    }
}

