/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.blocks.tools.roi;

import icy.plugin.abstract_.Plugin;
import icy.roi.ROI;
import icy.sequence.Sequence;
import java.util.ArrayList;
import plugins.adufour.blocks.tools.roi.ROIBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarEnum;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;

public class GetROIFromSequence
extends Plugin
implements ROIBlock {
    VarEnum<ROIFilter> filter = new VarEnum("ROI to get", (Enum)ROIFilter.ALL);
    VarROIArray rois = new VarROIArray("List of ROI");
    VarSequence sequence = new VarSequence("Source", null);

    @Override
    public void run() {
        Sequence s = (Sequence)this.sequence.getValue();
        if (s == null) {
            this.rois.setValue((Object)new ROI[0]);
            return;
        }
        ArrayList inputROI = s.getROIs();
        switch ((ROIFilter)((Object)this.filter.getValue())) {
            case SELECTED: {
                for (int i = 0; i < inputROI.size(); ++i) {
                    if (((ROI)inputROI.get(i)).isSelected()) continue;
                    inputROI.remove(i--);
                }
                break;
            }
            case NON_SELECTED: {
                for (int i = 0; i < inputROI.size(); ++i) {
                    if (!((ROI)inputROI.get(i)).isSelected()) continue;
                    inputROI.remove(i--);
                }
                break;
            }
            case ALL: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown ROI selection option: " + this.filter.getValueAsString());
            }
        }
        this.rois.setValue((Object)inputROI.toArray(new ROI[inputROI.size()]));
    }

    @Override
    public void declareInput(VarList inputMap) {
        inputMap.add("input sequence", (Var<?>)this.sequence);
        inputMap.add("selection state of ROI to extract", (Var<?>)this.filter);
    }

    @Override
    public void declareOutput(VarList outputMap) {
        outputMap.add("extracted rois", (Var<?>)this.rois);
    }

    public static enum ROIFilter {
        SELECTED,
        NON_SELECTED,
        ALL;

    }
}

