/*
 * Decompiled with CFR 0.152.
 */
package mitiv.psf;

import java.util.Arrays;
import mitiv.array.Array1D;
import mitiv.array.ArrayFactory;
import mitiv.array.ArrayUtils;
import mitiv.array.Double1D;
import mitiv.array.Double2D;
import mitiv.array.DoubleArray;
import mitiv.array.Float1D;
import mitiv.array.Float2D;
import mitiv.array.FloatArray;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.FloatFunction;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.psf.PsfModel;
import mitiv.utils.FFTUtils;

public class GaussianPsf
extends PsfModel {
    double[] scale = null;
    int rank;

    public GaussianPsf(Shape psfShape, double[] scale, boolean single) {
        super(psfShape, single);
        this.rank = psfShape.rank();
        if (scale == null) {
            scale = new double[this.rank];
            Arrays.fill(scale, 1.0);
        } else if (this.rank != scale.length) {
            throw new IllegalArgumentException("Scale and shape must have the same rank");
        }
        this.scale = Arrays.copyOf(scale, this.rank);
    }

    @Override
    public ShapedArray getPsf() {
        if (this.psf == null) {
            if (this.isSingle()) {
                this.psf = FFTUtils.generateFrequels2(this.psfShape.dimension(0)).toFloat();
                ((Float1D)this.psf).map(new FloatGaussian((double)((float)Math.sqrt(0.5)) * this.scale[0]));
            } else {
                this.psf = FFTUtils.generateFrequels2(this.psfShape.dimension(0)).toDouble();
                ((Double1D)this.psf).map(new DoubleGaussian(Math.sqrt(0.5) * this.scale[0]));
            }
            for (int j = 1; j < this.rank; ++j) {
                Array1D nextdim;
                if (this.isSingle()) {
                    nextdim = FFTUtils.generateFrequels2(this.psfShape.dimension(j)).toFloat();
                    ((Float1D)nextdim).map(new FloatGaussian((double)((float)Math.sqrt(0.5)) * this.scale[j]));
                } else {
                    nextdim = FFTUtils.generateFrequels2(this.psfShape.dimension(j)).toDouble();
                    ((Double1D)nextdim).map(new DoubleGaussian(Math.sqrt(0.5) * this.scale[j]));
                }
                this.psf = ArrayUtils.outer(this.psf, nextdim);
            }
            if (this.isSingle()) {
                ((FloatArray)this.psf).scale(1.0f / ((FloatArray)this.psf).sum());
            } else {
                ((DoubleArray)this.psf).scale(1.0 / ((DoubleArray)this.psf).sum());
            }
        }
        return this.psf;
    }

    @Override
    public ShapedArray getMtf() {
        Array1D nextdim;
        ShapedArray mtf;
        int[] firstdims = new int[]{2, this.psfShape.dimension(0)};
        if (this.isSingle()) {
            mtf = ArrayFactory.create(4, firstdims);
            nextdim = FFTUtils.generateFrequels2(this.psfShape.dimension(0), true).toFloat();
            ((Float1D)nextdim).map(new FloatGaussian(3.1415927410125732 / this.scale[0]));
            ((Float2D)mtf).slice(0, 0).assign(nextdim);
        } else {
            mtf = ArrayFactory.create(5, firstdims);
            nextdim = FFTUtils.generateFrequels2(this.psfShape.dimension(0), true).toDouble();
            ((Double1D)nextdim).map(new DoubleGaussian(Math.sqrt(2.0) * Math.PI / this.scale[0]));
            ((Double2D)mtf).slice(0, 0).assign(nextdim);
        }
        for (int j = 1; j < this.rank; ++j) {
            Array1D nextdim2;
            if (this.isSingle()) {
                nextdim2 = FFTUtils.generateFrequels2(this.psfShape.dimension(j)).toFloat();
                nextdim2.map(new FloatGaussian((double)((float)Math.sqrt(2.0)) * Math.PI / this.scale[j]));
            } else {
                nextdim2 = FFTUtils.generateFrequels2(this.psfShape.dimension(j), true).toDouble();
                ((Double1D)nextdim2).map(new DoubleGaussian(Math.sqrt(2.0) * Math.PI / this.scale[j]));
            }
            mtf = ArrayUtils.outer(mtf, nextdim2);
        }
        return mtf;
    }

    @Override
    public void setParam(DoubleShapedVector param) {
        this.setParam(param.getData());
    }

    @Override
    public void setParam(double[] param) {
        if (param.length == 1) {
            Arrays.fill(this.scale, param[0]);
        } else if (param.length == this.rank) {
            System.arraycopy(param, 0, this.scale, 0, this.rank);
        } else if (param.length == 2) {
            switch (this.rank) {
                case 3: {
                    this.scale[0] = param[0];
                    this.scale[1] = param[0];
                    this.scale[2] = param[1];
                    break;
                }
                default: {
                    throw new IllegalArgumentException(" psf dimension>3 not implemented");
                }
            }
        }
        this.psf = null;
    }

    private class FloatGaussian
    implements FloatFunction {
        double factor = 1.0;
        double scale2;

        public FloatGaussian(double sc) {
            this.scale2 = -sc * sc;
        }

        @Override
        public float apply(float arg) {
            return (float)(this.factor * Math.exp(this.scale2 * (double)arg));
        }
    }

    private class DoubleGaussian
    implements DoubleFunction {
        double factor = 1.0;
        double scale2;

        public DoubleGaussian(double sc) {
            this.scale2 = -sc * sc;
        }

        @Override
        public double apply(double arg) {
            return this.factor * Math.exp(this.scale2 * arg);
        }
    }
}

