/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.ribbon.gallery.oob;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.HashMap;
import java.util.Map;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class WatermarkResizableIcon
implements ResizableIcon {
    private int currWidth;
    private int currHeight;
    private SubstanceWatermark watermark;
    private static Map<Integer, BufferedImage> waterSigns = new HashMap<Integer, BufferedImage>();

    public WatermarkResizableIcon(SubstanceWatermark watermark, int startWidth, int startHeight) {
        this.watermark = watermark;
        this.currWidth = startWidth;
        this.currHeight = startHeight;
    }

    @Override
    public void setDimension(Dimension newDimension) {
        this.currWidth = newDimension.width;
        this.currHeight = newDimension.height;
    }

    @Override
    public int getIconHeight() {
        return this.currHeight;
    }

    @Override
    public int getIconWidth() {
        return this.currWidth;
    }

    private static BufferedImage getWatermarkSign(int size) {
        if (waterSigns.containsKey(size)) {
            return waterSigns.get(size);
        }
        BufferedImage blurred = SubstanceCoreUtilities.getBlankImage(size, size);
        Font font = new Font("Tahoma", size > 15 ? 0 : 1, size);
        Graphics2D blurredGraphics = (Graphics2D)blurred.getGraphics().create();
        blurredGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        blurredGraphics.setColor(new Color(255, 255, 255, 96));
        blurredGraphics.fillRect(0, 0, size, size);
        blurredGraphics.setColor(Color.white);
        blurredGraphics.setFont(font);
        blurredGraphics.drawString("\u2248", 1, size - 1);
        float[] data = new float[]{0.0625f, 0.125f, 0.0625f, 0.125f, 0.25f, 0.125f, 0.0625f, 0.125f, 0.0625f};
        Kernel kernel = new Kernel(3, 3, data);
        ConvolveOp convolve = new ConvolveOp(kernel, 1, null);
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(size, size);
        convolve.filter(blurred, result);
        Graphics2D graphics = (Graphics2D)result.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics.setColor(new Color(0, 0, 255));
        graphics.setFont(font);
        graphics.drawString("\u2248", 1, size - 1);
        blurredGraphics.dispose();
        waterSigns.put(size, result);
        return result;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.translate(x, y);
        graphics.clipRect(0, 0, this.currWidth, this.currHeight);
        if (this.watermark != null) {
            graphics.setColor(SubstanceCoreUtilities.getSkin(c).getEnabledColorScheme(SubstanceLookAndFeel.getDecorationType(c)).getExtraLightColor());
            graphics.fillRect(0, 0, this.currWidth, this.currHeight);
            Composite oldComp = graphics.getComposite();
            graphics.setComposite(AlphaComposite.getInstance(3, 0.6f));
            this.watermark.previewWatermark(graphics, SubstanceColorSchemeUtilities.METALLIC_SKIN, 0, 0, this.currWidth, this.currHeight);
            graphics.setComposite(oldComp);
            int waterSize = this.currHeight / 2;
            graphics.drawImage((Image)WatermarkResizableIcon.getWatermarkSign(waterSize), this.currWidth - waterSize - 2, this.currHeight - waterSize - 2, null);
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, this.currWidth - 1, this.currHeight - 1);
        } else {
            int waterSize = Math.min(this.currHeight, this.currWidth) - 2;
            graphics.drawImage((Image)WatermarkResizableIcon.getWatermarkSign(waterSize), (this.currWidth - waterSize) / 2, (this.currHeight - waterSize) / 2, null);
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, this.currWidth - 1, this.currHeight - 1);
        }
        graphics.dispose();
    }
}

