/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.WindowManager;
import ij.gui.GUI;
import ij.macro.MacroRunner;
import ij.util.Java2;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class HTMLDialog
extends JDialog
implements ActionListener,
KeyListener,
HyperlinkListener {
    private boolean escapePressed;
    private JEditorPane editorPane;
    private boolean modal = true;

    public HTMLDialog(String title, String message) {
        super(IJ.getInstance(), title, true);
        this.init(message);
    }

    public HTMLDialog(Dialog parent, String title, String message) {
        super(parent, title, true);
        this.init(message);
    }

    public HTMLDialog(String title, String message, boolean modal) {
        super(IJ.getInstance(), title, modal);
        this.modal = modal;
        this.init(message);
    }

    private void init(String message) {
        Java2.setSystemLookAndFeel();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        if (message == null) {
            message = "";
        }
        this.editorPane = new JEditorPane("text/html", "");
        this.editorPane.setEditable(false);
        HTMLEditorKit kit = new HTMLEditorKit();
        this.editorPane.setEditorKit(kit);
        StyleSheet styleSheet = kit.getStyleSheet();
        styleSheet.addRule("body{font-family:Verdana,sans-serif; font-size:11.5pt; margin:5px 10px 5px 10px;}");
        styleSheet.addRule("h1{font-size:18pt;}");
        styleSheet.addRule("h2{font-size:15pt;}");
        styleSheet.addRule("dl dt{font-face:bold;}");
        this.editorPane.setText(message);
        this.editorPane.getActionMap().put("insert-break", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.editorPane);
        container.add(scrollPane);
        JButton button = new JButton("OK");
        button.addActionListener(this);
        button.addKeyListener(this);
        this.editorPane.addKeyListener(this);
        this.editorPane.addHyperlinkListener(this);
        JPanel panel = new JPanel();
        panel.add(button);
        container.add((Component)panel, "South");
        this.setForeground(Color.black);
        this.pack();
        Dimension screenD = IJ.getScreenSize();
        Dimension dialogD = this.getSize();
        int maxWidth = (int)Math.min(0.7 * (double)screenD.width, 800.0);
        if (maxWidth > 400 && dialogD.width > maxWidth) {
            dialogD.width = maxWidth;
        }
        if ((double)dialogD.height > 0.8 * (double)screenD.height && screenD.height > 400) {
            dialogD.height = (int)(0.8 * (double)screenD.height);
        }
        this.setSize(dialogD);
        GUI.centerOnImageJScreen(this);
        if (!this.modal) {
            WindowManager.addWindow(this);
        }
        this.show();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.dispose();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        IJ.setKeyDown(keyCode);
        boolean bl = this.escapePressed = keyCode == 27;
        if (keyCode == 67) {
            if (this.editorPane.getSelectedText() == null || this.editorPane.getSelectedText().length() == 0) {
                this.editorPane.selectAll();
            }
            this.editorPane.copy();
            this.editorPane.select(0, 0);
        } else if (keyCode == 10 || keyCode == 87 || this.escapePressed) {
            this.dispose();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
        IJ.setKeyUp(keyCode);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public boolean escapePressed() {
        return this.escapePressed;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String url = e.getDescription();
            if (url == null) {
                return;
            }
            if (url.startsWith("#")) {
                this.editorPane.scrollToReference(url.substring(1));
            } else {
                String macro = "run('URL...', 'url=" + url + "');";
                new MacroRunner(macro);
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (!this.modal) {
            WindowManager.removeWindow(this);
        }
    }
}

