/*
 * Decompiled with CFR 0.152.
 */
package icy.type.rectangle;

import icy.type.dimension.Dimension4D;
import icy.type.point.Point4D;
import icy.type.rectangle.Rectangle3D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public abstract class Rectangle4D
implements Cloneable {
    public static Rectangle4D intersect(Rectangle4D src1, Rectangle4D src2, Rectangle4D dest) {
        Rectangle4D result = dest == null ? new Double() : dest;
        double x1 = Math.max(src1.getMinX(), src2.getMinX());
        double y1 = Math.max(src1.getMinY(), src2.getMinY());
        double z1 = Math.max(src1.getMinZ(), src2.getMinZ());
        double t1 = Math.max(src1.getMinT(), src2.getMinT());
        double x2 = Math.min(src1.getMaxX(), src2.getMaxX());
        double y2 = Math.min(src1.getMaxY(), src2.getMaxY());
        double z2 = Math.min(src1.getMaxZ(), src2.getMaxZ());
        double t2 = Math.min(src1.getMaxT(), src2.getMaxT());
        double dx = x2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : x2 - x1;
        double dy = y2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : y2 - y1;
        double dz = z2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : z2 - z1;
        double dt = t2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : t2 - t1;
        result.setRect(x1, y1, z1, t1, dx, dy, dz, dt);
        return result;
    }

    public abstract Rectangle4D createIntersection(Rectangle4D var1);

    public static Rectangle4D union(Rectangle4D src1, Rectangle4D src2, Rectangle4D dest) {
        Rectangle4D result = dest == null ? new Double() : dest;
        double x1 = Math.min(src1.getMinX(), src2.getMinX());
        double y1 = Math.min(src1.getMinY(), src2.getMinY());
        double z1 = Math.min(src1.getMinZ(), src2.getMinZ());
        double t1 = Math.min(src1.getMinT(), src2.getMinT());
        double x2 = Math.max(src1.getMaxX(), src2.getMaxX());
        double y2 = Math.max(src1.getMaxY(), src2.getMaxY());
        double z2 = Math.max(src1.getMaxZ(), src2.getMaxZ());
        double t2 = Math.max(src1.getMaxT(), src2.getMaxT());
        double dx = x2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : x2 - x1;
        double dy = y2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : y2 - y1;
        double dz = z2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : z2 - z1;
        double dt = t2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : t2 - t1;
        result.setRect(x1, y1, z1, t1, dx, dy, dz, dt);
        return result;
    }

    public abstract Rectangle4D createUnion(Rectangle4D var1);

    public abstract void setRect(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15);

    public abstract double getX();

    public abstract double getY();

    public abstract double getZ();

    public abstract double getT();

    public abstract double getSizeX();

    public abstract double getSizeY();

    public abstract double getSizeZ();

    public abstract double getSizeT();

    public abstract Point4D getPosition();

    public abstract Dimension4D getDimension();

    public Integer toInteger() {
        double sx = this.getSizeX();
        double sy = this.getSizeY();
        double sz = this.getSizeZ();
        double st = this.getSizeT();
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        double t = this.getT();
        int ix = (int)Math.floor(x);
        int iy = (int)Math.floor(y);
        int iz = (int)Math.floor(z);
        int it = (int)Math.floor(t);
        int isx = sx < 0.0 ? 0 : (sx >= 2.147483647E9 ? java.lang.Integer.MAX_VALUE : (int)Math.ceil(x + sx) - ix);
        int isy = sy < 0.0 ? 0 : (sy >= 2.147483647E9 ? java.lang.Integer.MAX_VALUE : (int)Math.ceil(y + sy) - iy);
        int isz = sz < 0.0 ? 0 : (sz >= 2.147483647E9 ? java.lang.Integer.MAX_VALUE : (int)Math.ceil(z + sz) - iz);
        int ist = st < 0.0 ? 0 : (st >= 2.147483647E9 ? java.lang.Integer.MAX_VALUE : (int)Math.ceil(t + st) - it);
        return new Integer(ix, iy, iz, it, isx, isy, isz, ist);
    }

    public abstract void setX(double var1);

    public abstract void setY(double var1);

    public abstract void setZ(double var1);

    public abstract void setT(double var1);

    public abstract void setSizeX(double var1);

    public abstract void setSizeY(double var1);

    public abstract void setSizeZ(double var1);

    public abstract void setSizeT(double var1);

    public double getMinX() {
        return this.getX();
    }

    public double getMinY() {
        return this.getY();
    }

    public double getMinZ() {
        return this.getZ();
    }

    public double getMinT() {
        return this.getT();
    }

    public double getMaxX() {
        if (this.getSizeX() == java.lang.Double.POSITIVE_INFINITY) {
            return java.lang.Double.POSITIVE_INFINITY;
        }
        return this.getX() + this.getSizeX();
    }

    public double getMaxY() {
        if (this.getSizeY() == java.lang.Double.POSITIVE_INFINITY) {
            return java.lang.Double.POSITIVE_INFINITY;
        }
        return this.getY() + this.getSizeY();
    }

    public double getMaxZ() {
        if (this.getSizeZ() == java.lang.Double.POSITIVE_INFINITY) {
            return java.lang.Double.POSITIVE_INFINITY;
        }
        return this.getZ() + this.getSizeZ();
    }

    public double getMaxT() {
        if (this.getSizeT() == java.lang.Double.POSITIVE_INFINITY) {
            return java.lang.Double.POSITIVE_INFINITY;
        }
        return this.getT() + this.getSizeT();
    }

    public double getCenterX() {
        if (this.isInfiniteX()) {
            return 0.0;
        }
        return this.getX() + this.getSizeX() / 2.0;
    }

    public double getCenterY() {
        if (this.isInfiniteY()) {
            return 0.0;
        }
        return this.getY() + this.getSizeY() / 2.0;
    }

    public double getCenterZ() {
        if (this.isInfiniteZ()) {
            return 0.0;
        }
        return this.getZ() + this.getSizeZ() / 2.0;
    }

    public double getCenterT() {
        if (this.isInfiniteT()) {
            return 0.0;
        }
        return this.getT() + this.getSizeT() / 2.0;
    }

    public boolean isEmpty() {
        return this.getSizeX() <= 0.0 || this.getSizeY() <= 0.0 || this.getSizeZ() <= 0.0 || this.getSizeT() <= 0.0;
    }

    public boolean isInfiniteX() {
        return this.getX() == java.lang.Double.NEGATIVE_INFINITY && this.getSizeX() == java.lang.Double.POSITIVE_INFINITY;
    }

    public boolean isInfiniteY() {
        return this.getY() == java.lang.Double.NEGATIVE_INFINITY && this.getSizeY() == java.lang.Double.POSITIVE_INFINITY;
    }

    public boolean isInfiniteZ() {
        return this.getZ() == java.lang.Double.NEGATIVE_INFINITY && this.getSizeZ() == java.lang.Double.POSITIVE_INFINITY;
    }

    public boolean isInfiniteT() {
        return this.getT() == java.lang.Double.NEGATIVE_INFINITY && this.getSizeT() == java.lang.Double.POSITIVE_INFINITY;
    }

    public void setInfiniteX() {
        this.setX(java.lang.Double.NEGATIVE_INFINITY);
        this.setSizeX(java.lang.Double.POSITIVE_INFINITY);
    }

    public void setInfiniteY() {
        this.setY(java.lang.Double.NEGATIVE_INFINITY);
        this.setSizeY(java.lang.Double.POSITIVE_INFINITY);
    }

    public void setInfiniteZ() {
        this.setZ(java.lang.Double.NEGATIVE_INFINITY);
        this.setSizeZ(java.lang.Double.POSITIVE_INFINITY);
    }

    public void setInfiniteT() {
        this.setT(java.lang.Double.NEGATIVE_INFINITY);
        this.setSizeT(java.lang.Double.POSITIVE_INFINITY);
    }

    public boolean contains(double x, double y, double z, double t) {
        return x >= this.getMinX() && y >= this.getMaxY() && z >= this.getMinZ() && t >= this.getMinT() && x < this.getMaxX() && y < this.getMaxY() && z < this.getMaxZ() && t < this.getMaxT();
    }

    public boolean contains(double x, double y, double z, double t, double sizeX, double sizeY, double sizeZ, double sizeT) {
        double maxX = sizeX == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : x + sizeX;
        double maxY = sizeY == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : y + sizeY;
        double maxZ = sizeZ == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : z + sizeZ;
        double maxT = sizeT == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : t + sizeT;
        return x >= this.getMinX() && y >= this.getMinY() && z >= this.getMinZ() && t >= this.getMinT() && maxX <= this.getMaxX() && maxY <= this.getMaxY() && maxZ <= this.getMaxZ() && maxT <= this.getMaxT();
    }

    public boolean contains(Rectangle4D rect) {
        return this.contains(rect.getX(), rect.getY(), rect.getZ(), rect.getT(), rect.getSizeX(), rect.getSizeY(), rect.getSizeZ(), rect.getSizeT());
    }

    public boolean intersects(double x, double y, double z, double t, double sizeX, double sizeY, double sizeZ, double sizeT) {
        double maxX = sizeX == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : x + sizeX;
        double maxY = sizeY == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : y + sizeY;
        double maxZ = sizeZ == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : z + sizeZ;
        double maxT = sizeT == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : t + sizeT;
        return maxX > this.getMinX() && maxY > this.getMinY() && maxZ > this.getMinZ() && maxT > this.getMinT() && x < this.getMaxX() && y < this.getMaxY() && z < this.getMaxZ() && t < this.getMaxT();
    }

    public boolean intersects(Rectangle4D rect) {
        return this.intersects(rect.getX(), rect.getY(), rect.getZ(), rect.getT(), rect.getSizeX(), rect.getSizeY(), rect.getSizeZ(), rect.getSizeT());
    }

    public void add(double newx, double newy, double newz, double newt) {
        double x1 = Math.min(this.getMinX(), newx);
        double x2 = Math.max(this.getMaxX(), newx);
        double y1 = Math.min(this.getMinY(), newy);
        double y2 = Math.max(this.getMaxY(), newy);
        double z1 = Math.min(this.getMinZ(), newz);
        double z2 = Math.max(this.getMaxZ(), newz);
        double t1 = Math.min(this.getMinT(), newt);
        double t2 = Math.max(this.getMaxT(), newt);
        double dx = x2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : x2 - x1;
        double dy = y2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : y2 - y1;
        double dz = z2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : z2 - z1;
        double dt = t2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : t2 - t1;
        this.setRect(x1, y1, z1, t1, dx, dy, dz, dt);
    }

    public void add(Point4D pt) {
        this.add(pt.getX(), pt.getY(), pt.getZ(), pt.getT());
    }

    public void add(Rectangle4D r) {
        Rectangle4D.union(this, r, this);
    }

    public abstract Rectangle2D toRectangle2D();

    public abstract Rectangle3D toRectangle3D();

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Rectangle4D) {
            Rectangle4D rect = (Rectangle4D)obj;
            return this.getX() == rect.getX() && this.getY() == rect.getY() && this.getZ() == rect.getZ() && this.getT() == rect.getT() && this.getSizeX() == rect.getSizeX() && this.getSizeY() == rect.getSizeY() && this.getSizeZ() == rect.getSizeZ() && this.getSizeT() == rect.getSizeT();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        long bits = java.lang.Double.doubleToLongBits(this.getX());
        bits ^= java.lang.Double.doubleToLongBits(this.getY());
        bits ^= java.lang.Double.doubleToLongBits(this.getZ());
        bits ^= java.lang.Double.doubleToLongBits(this.getT());
        bits ^= java.lang.Double.doubleToLongBits(this.getSizeX());
        bits ^= java.lang.Double.doubleToLongBits(this.getSizeY());
        bits ^= java.lang.Double.doubleToLongBits(this.getSizeZ());
        return (int)(bits ^= java.lang.Double.doubleToLongBits(this.getSizeT())) ^ (int)(bits >> 32);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getX() + "," + this.getY() + "," + this.getZ() + "," + this.getT() + " - " + this.getSizeX() + "," + this.getSizeY() + "," + this.getSizeZ() + "," + this.getSizeT() + "]";
    }

    public static class Integer
    extends Rectangle4D {
        public int x;
        public int y;
        public int z;
        public int t;
        public int sizeX;
        public int sizeY;
        public int sizeZ;
        public int sizeT;

        public Integer(int x, int y, int z, int t, int sizeX, int sizeY, int sizeZ, int sizeT) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.t = t;
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
            this.sizeT = sizeT;
        }

        public Integer(Integer r) {
            this(r.x, r.y, r.z, r.t, r.sizeX, r.sizeY, r.sizeZ, r.sizeT);
        }

        public Integer(Rectangle4D r) {
            this(r.toInteger());
        }

        public Integer() {
            this(0, 0, 0, 0, 0, 0, 0, 0);
        }

        @Override
        public void setRect(double x, double y, double z, double t, double sizeX, double sizeY, double sizeZ, double sizeT) {
            Integer r = new Double(x, y, z, t, sizeX, sizeY, sizeZ, sizeT).toInteger();
            this.setRect(r.x, r.y, r.z, r.t, r.sizeX, r.sizeY, r.sizeZ, r.sizeT);
        }

        public void setRect(int x, int y, int z, int t, int sizeX, int sizeY, int sizeZ, int sizeT) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.t = t;
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
            this.sizeT = sizeT;
        }

        @Override
        public double getX() {
            if (this.x == java.lang.Integer.MIN_VALUE) {
                return java.lang.Double.NEGATIVE_INFINITY;
            }
            if (this.x == java.lang.Integer.MAX_VALUE) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.x;
        }

        @Override
        public void setX(double value) {
            this.x = (int)value;
        }

        @Override
        public double getY() {
            if (this.y == java.lang.Integer.MIN_VALUE) {
                return java.lang.Double.NEGATIVE_INFINITY;
            }
            if (this.y == java.lang.Integer.MAX_VALUE) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.y;
        }

        @Override
        public void setY(double value) {
            this.y = (int)value;
        }

        @Override
        public double getZ() {
            if (this.z == java.lang.Integer.MIN_VALUE) {
                return java.lang.Double.NEGATIVE_INFINITY;
            }
            if (this.z == java.lang.Integer.MAX_VALUE) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.z;
        }

        @Override
        public void setZ(double value) {
            this.z = (int)value;
        }

        @Override
        public double getT() {
            if (this.t == java.lang.Integer.MIN_VALUE) {
                return java.lang.Double.NEGATIVE_INFINITY;
            }
            if (this.t == java.lang.Integer.MAX_VALUE) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.t;
        }

        @Override
        public void setT(double value) {
            this.t = (int)value;
        }

        @Override
        public double getSizeX() {
            if (this.sizeX == java.lang.Integer.MAX_VALUE) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.sizeX;
        }

        @Override
        public void setSizeX(double value) {
            this.sizeX = (int)value;
        }

        @Override
        public double getSizeY() {
            if (this.sizeY == java.lang.Integer.MAX_VALUE) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.sizeY;
        }

        @Override
        public void setSizeY(double value) {
            this.sizeY = (int)value;
        }

        @Override
        public double getSizeZ() {
            if (this.sizeZ == java.lang.Integer.MAX_VALUE) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.sizeZ;
        }

        @Override
        public void setSizeZ(double value) {
            this.sizeZ = (int)value;
        }

        @Override
        public double getSizeT() {
            if (this.sizeT == java.lang.Integer.MAX_VALUE) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.sizeT;
        }

        @Override
        public void setSizeT(double value) {
            this.sizeT = (int)value;
        }

        @Override
        public Point4D.Integer getPosition() {
            return new Point4D.Integer(this.x, this.y, this.z, this.t);
        }

        @Override
        public Dimension4D.Integer getDimension() {
            return new Dimension4D.Integer(this.sizeX, this.sizeY, this.sizeZ, this.sizeT);
        }

        @Override
        public Integer toInteger() {
            return (Integer)this.clone();
        }

        @Override
        public Rectangle4D createIntersection(Rectangle4D r) {
            Integer result = new Integer();
            Integer.intersect(this, r, result);
            return result;
        }

        @Override
        public Rectangle4D createUnion(Rectangle4D r) {
            Integer result = new Integer();
            Integer.union(this, r, result);
            return result;
        }

        @Override
        public Rectangle2D toRectangle2D() {
            return new Rectangle(this.x, this.y, this.sizeX, this.sizeY);
        }

        @Override
        public Rectangle3D toRectangle3D() {
            return new Rectangle3D.Integer(this.x, this.y, this.z, this.sizeX, this.sizeY, this.sizeZ);
        }
    }

    public static class Float
    extends Rectangle4D {
        public float x;
        public float y;
        public float z;
        public float t;
        public float sizeX;
        public float sizeY;
        public float sizeZ;
        public float sizeT;

        public Float(float x, float y, float z, float t, float sizeX, float sizeY, float sizeZ, float sizeT) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.t = t;
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
            this.sizeT = sizeT;
        }

        public Float(Rectangle4D r) {
            this((float)r.getX(), (float)r.getY(), (float)r.getZ(), (float)r.getT(), (float)r.getSizeX(), (float)r.getSizeY(), (float)r.getSizeZ(), (float)r.getSizeT());
        }

        public Float() {
            this(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }

        @Override
        public void setRect(double x, double y, double z, double t, double sizeX, double sizeY, double sizeZ, double sizeT) {
            this.x = (float)x;
            this.y = (float)y;
            this.z = (float)z;
            this.t = (float)t;
            this.sizeX = (float)sizeX;
            this.sizeY = (float)sizeY;
            this.sizeZ = (float)sizeZ;
            this.sizeT = (float)sizeT;
        }

        @Override
        public double getX() {
            if (this.x == java.lang.Float.NEGATIVE_INFINITY) {
                return java.lang.Double.NEGATIVE_INFINITY;
            }
            if (this.x == java.lang.Float.POSITIVE_INFINITY) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.x;
        }

        @Override
        public void setX(double value) {
            this.x = (float)value;
        }

        @Override
        public double getY() {
            if (this.y == java.lang.Float.NEGATIVE_INFINITY) {
                return java.lang.Double.NEGATIVE_INFINITY;
            }
            if (this.y == java.lang.Float.POSITIVE_INFINITY) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.y;
        }

        @Override
        public void setY(double value) {
            this.y = (float)value;
        }

        @Override
        public double getZ() {
            if (this.z == java.lang.Float.NEGATIVE_INFINITY) {
                return java.lang.Double.NEGATIVE_INFINITY;
            }
            if (this.z == java.lang.Float.POSITIVE_INFINITY) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.z;
        }

        @Override
        public void setZ(double value) {
            this.z = (float)value;
        }

        @Override
        public double getT() {
            if (this.t == java.lang.Float.NEGATIVE_INFINITY) {
                return java.lang.Double.NEGATIVE_INFINITY;
            }
            if (this.t == java.lang.Float.POSITIVE_INFINITY) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.t;
        }

        @Override
        public void setT(double value) {
            this.t = (float)value;
        }

        @Override
        public double getSizeX() {
            if (this.sizeX == java.lang.Float.POSITIVE_INFINITY) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.sizeX;
        }

        @Override
        public void setSizeX(double value) {
            this.sizeX = (float)value;
        }

        @Override
        public double getSizeY() {
            if (this.sizeY == java.lang.Float.POSITIVE_INFINITY) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.sizeY;
        }

        @Override
        public void setSizeY(double value) {
            this.sizeY = (float)value;
        }

        @Override
        public double getSizeZ() {
            if (this.sizeZ == java.lang.Float.POSITIVE_INFINITY) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.sizeZ;
        }

        @Override
        public void setSizeZ(double value) {
            this.sizeZ = (float)value;
        }

        @Override
        public double getSizeT() {
            if (this.sizeT == java.lang.Float.POSITIVE_INFINITY) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.sizeT;
        }

        @Override
        public void setSizeT(double value) {
            this.sizeT = (float)value;
        }

        @Override
        public Point4D.Float getPosition() {
            return new Point4D.Float(this.x, this.y, this.z, this.t);
        }

        @Override
        public Dimension4D.Float getDimension() {
            return new Dimension4D.Float(this.sizeX, this.sizeY, this.sizeZ, this.sizeT);
        }

        @Override
        public Rectangle4D createIntersection(Rectangle4D r) {
            Float result = new Float();
            Float.intersect(this, r, result);
            return result;
        }

        @Override
        public Rectangle4D createUnion(Rectangle4D r) {
            Float result = new Float();
            Float.union(this, r, result);
            return result;
        }

        @Override
        public Rectangle2D toRectangle2D() {
            return new Rectangle2D.Float(this.x, this.y, this.sizeX, this.sizeY);
        }

        @Override
        public Rectangle3D toRectangle3D() {
            return new Rectangle3D.Float(this.x, this.y, this.z, this.sizeX, this.sizeY, this.sizeZ);
        }
    }

    public static class Double
    extends Rectangle4D {
        public double x;
        public double y;
        public double z;
        public double t;
        public double sizeX;
        public double sizeY;
        public double sizeZ;
        public double sizeT;

        public Double(double x, double y, double z, double t, double sizeX, double sizeY, double sizeZ, double sizeT) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.t = t;
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
            this.sizeT = sizeT;
        }

        public Double(Rectangle4D r) {
            this(r.getX(), r.getY(), r.getZ(), r.getT(), r.getSizeX(), r.getSizeY(), r.getSizeZ(), r.getSizeT());
        }

        public Double() {
            this(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }

        @Override
        public void setRect(double x, double y, double z, double t, double sizeX, double sizeY, double sizeZ, double sizeT) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.t = t;
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
            this.sizeT = sizeT;
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public void setX(double value) {
            this.x = value;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public void setY(double value) {
            this.y = value;
        }

        @Override
        public double getZ() {
            return this.z;
        }

        @Override
        public void setZ(double value) {
            this.z = value;
        }

        @Override
        public double getT() {
            return this.t;
        }

        @Override
        public void setT(double value) {
            this.t = value;
        }

        @Override
        public double getSizeX() {
            return this.sizeX;
        }

        @Override
        public void setSizeX(double value) {
            this.sizeX = value;
        }

        @Override
        public double getSizeY() {
            return this.sizeY;
        }

        @Override
        public void setSizeY(double value) {
            this.sizeY = value;
        }

        @Override
        public double getSizeZ() {
            return this.sizeZ;
        }

        @Override
        public void setSizeZ(double value) {
            this.sizeZ = value;
        }

        @Override
        public double getSizeT() {
            return this.sizeT;
        }

        @Override
        public void setSizeT(double value) {
            this.sizeT = value;
        }

        @Override
        public Point4D.Double getPosition() {
            return new Point4D.Double(this.x, this.y, this.z, this.t);
        }

        @Override
        public Dimension4D.Double getDimension() {
            return new Dimension4D.Double(this.sizeX, this.sizeY, this.sizeZ, this.sizeT);
        }

        @Override
        public Rectangle4D createIntersection(Rectangle4D r) {
            Double result = new Double();
            Double.intersect(this, r, result);
            return result;
        }

        @Override
        public Rectangle4D createUnion(Rectangle4D r) {
            Double result = new Double();
            Double.union(this, r, result);
            return result;
        }

        @Override
        public Rectangle2D toRectangle2D() {
            return new Rectangle2D.Double(this.x, this.y, this.sizeX, this.sizeY);
        }

        @Override
        public Rectangle3D toRectangle3D() {
            return new Rectangle3D.Double(this.x, this.y, this.z, this.sizeX, this.sizeY, this.sizeZ);
        }
    }
}

