/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.optim.BoundProjector;

public class SimpleLowerBound
extends BoundProjector {
    private final double lowerBound;
    private final boolean single;

    public SimpleLowerBound(ShapedVectorSpace vsp, double lowerBound) {
        super(vsp);
        if (vsp.getType() == 5) {
            this.single = false;
        } else if (vsp.getType() == 4) {
            this.single = true;
        } else {
            throw new IllegalArgumentException("Only double/double type supported");
        }
        this.checkLowerBound(lowerBound, this.single);
        this.lowerBound = lowerBound;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    @Override
    protected void _projectVariables(Vector dst, Vector src) {
        int n = src.getNumber();
        if (this.single) {
            float xmin = this.convertToFloat(this.getLowerBound());
            float[] x = ((FloatShapedVector)src).getData();
            float[] xp = ((FloatShapedVector)dst).getData();
            for (int j = 0; j < n; ++j) {
                xp[j] = SimpleLowerBound.max(x[j], xmin);
            }
        } else {
            double xmin = this.getLowerBound();
            double[] x = ((DoubleShapedVector)src).getData();
            double[] xp = ((DoubleShapedVector)dst).getData();
            for (int j = 0; j < n; ++j) {
                xp[j] = SimpleLowerBound.max(x[j], xmin);
            }
        }
    }

    @Override
    protected void _projectDirection(Vector vx, Vector vd, boolean ascent, Vector vdp, double[] bnd) {
        int n = vx.getNumber();
        if (this.single) {
            float zero = 0.0f;
            float xmin = this.convertToFloat(this.getLowerBound());
            float[] x = ((FloatShapedVector)vx).getData();
            float[] d = ((FloatShapedVector)vd).getData();
            float[] dp = ((FloatShapedVector)vdp).getData();
            if (bnd == null) {
                if (ascent) {
                    for (int j = 0; j < n; ++j) {
                        dp[j] = d[j] < 0.0f || x[j] > xmin ? d[j] : 0.0f;
                    }
                } else {
                    for (int j = 0; j < n; ++j) {
                        dp[j] = d[j] > 0.0f || x[j] > xmin ? d[j] : 0.0f;
                    }
                }
            } else {
                float amin = Float.POSITIVE_INFINITY;
                float amax = 0.0f;
                if (ascent) {
                    for (int j = 0; j < n; ++j) {
                        if (d[j] < 0.0f) {
                            dp[j] = d[j];
                            amax = Float.POSITIVE_INFINITY;
                            continue;
                        }
                        if (d[j] > 0.0f) {
                            if (x[j] > xmin) {
                                dp[j] = d[j];
                                if (xmin == Float.NEGATIVE_INFINITY) {
                                    amax = Float.POSITIVE_INFINITY;
                                    continue;
                                }
                                float tmp = (x[j] - xmin) / d[j];
                                if (tmp < amin) {
                                    amin = tmp;
                                }
                                if (!(tmp > amax)) continue;
                                amax = tmp;
                                continue;
                            }
                            dp[j] = 0.0f;
                            continue;
                        }
                        dp[j] = 0.0f;
                    }
                } else {
                    for (int j = 0; j < n; ++j) {
                        if (d[j] > 0.0f) {
                            dp[j] = d[j];
                            amax = Float.POSITIVE_INFINITY;
                            continue;
                        }
                        if (d[j] < 0.0f) {
                            if (x[j] > xmin) {
                                dp[j] = d[j];
                                if (xmin == Float.NEGATIVE_INFINITY) {
                                    amax = Float.POSITIVE_INFINITY;
                                    continue;
                                }
                                float tmp = (xmin - x[j]) / d[j];
                                if (tmp < amin) {
                                    amin = tmp;
                                }
                                if (!(tmp > amax)) continue;
                                amax = tmp;
                                continue;
                            }
                            dp[j] = 0.0f;
                            continue;
                        }
                        dp[j] = 0.0f;
                    }
                }
                bnd[0] = amin;
                bnd[1] = amax;
            }
        } else {
            double zero = 0.0;
            double xmin = this.getLowerBound();
            double[] x = ((DoubleShapedVector)vx).getData();
            double[] d = ((DoubleShapedVector)vd).getData();
            double[] dp = ((DoubleShapedVector)vdp).getData();
            if (bnd == null) {
                if (ascent) {
                    for (int j = 0; j < n; ++j) {
                        dp[j] = d[j] < 0.0 || x[j] > xmin ? d[j] : 0.0;
                    }
                } else {
                    for (int j = 0; j < n; ++j) {
                        dp[j] = d[j] > 0.0 || x[j] > xmin ? d[j] : 0.0;
                    }
                }
            } else {
                double amin = Double.POSITIVE_INFINITY;
                double amax = 0.0;
                if (ascent) {
                    for (int j = 0; j < n; ++j) {
                        if (d[j] < 0.0) {
                            dp[j] = d[j];
                            amax = Double.POSITIVE_INFINITY;
                            continue;
                        }
                        if (d[j] > 0.0) {
                            if (x[j] > xmin) {
                                dp[j] = d[j];
                                if (xmin == Double.NEGATIVE_INFINITY) {
                                    amax = Double.POSITIVE_INFINITY;
                                    continue;
                                }
                                double tmp = (x[j] - xmin) / d[j];
                                if (tmp < amin) {
                                    amin = tmp;
                                }
                                if (!(tmp > amax)) continue;
                                amax = tmp;
                                continue;
                            }
                            dp[j] = 0.0;
                            continue;
                        }
                        dp[j] = 0.0;
                    }
                } else {
                    for (int j = 0; j < n; ++j) {
                        if (d[j] > 0.0) {
                            dp[j] = d[j];
                            amax = Double.POSITIVE_INFINITY;
                            continue;
                        }
                        if (d[j] < 0.0) {
                            if (x[j] > xmin) {
                                dp[j] = d[j];
                                if (xmin == Double.NEGATIVE_INFINITY) {
                                    amax = Double.POSITIVE_INFINITY;
                                    continue;
                                }
                                double tmp = (xmin - x[j]) / d[j];
                                if (tmp < amin) {
                                    amin = tmp;
                                }
                                if (!(tmp > amax)) continue;
                                amax = tmp;
                                continue;
                            }
                            dp[j] = 0.0;
                            continue;
                        }
                        dp[j] = 0.0;
                    }
                }
                bnd[0] = amin;
                bnd[1] = amax;
            }
        }
    }
}

