/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.Array7D;
import mitiv.array.ArrayFactory;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;

public abstract class Array8D
implements ShapedArray {
    protected final Shape shape;
    protected final int number;
    protected final int dim1;
    protected final int dim2;
    protected final int dim3;
    protected final int dim4;
    protected final int dim5;
    protected final int dim6;
    protected final int dim7;
    protected final int dim8;

    protected Array8D(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8) {
        this.shape = new Shape(dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8);
        if (this.shape.number() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total number of elements is too large");
        }
        this.number = (int)this.shape.number();
        this.dim1 = dim1;
        this.dim2 = dim2;
        this.dim3 = dim3;
        this.dim4 = dim4;
        this.dim5 = dim5;
        this.dim6 = dim6;
        this.dim7 = dim7;
        this.dim8 = dim8;
    }

    protected Array8D(int[] dims) {
        this(new Shape(dims));
    }

    protected Array8D(Shape shape) {
        if (shape.rank() != 8) {
            throw new IllegalArgumentException("Bad number of dimensions for 8-D array");
        }
        if (shape.number() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total number of elements is too large");
        }
        this.number = (int)shape.number();
        this.shape = shape;
        this.dim1 = shape.dimension(0);
        this.dim2 = shape.dimension(1);
        this.dim3 = shape.dimension(2);
        this.dim4 = shape.dimension(3);
        this.dim5 = shape.dimension(4);
        this.dim6 = shape.dimension(5);
        this.dim7 = shape.dimension(6);
        this.dim8 = shape.dimension(7);
    }

    @Override
    public final int getRank() {
        return 8;
    }

    @Override
    public final Shape getShape() {
        return this.shape;
    }

    @Override
    public final int getNumber() {
        return this.number;
    }

    @Override
    public final int getDimension(int k) {
        return this.shape.dimension(k);
    }

    public final Array8D reshape(Shape shape) {
        if (this.number == (int)shape.number()) {
            return (Array8D)ArrayFactory.wrap(this.getData(), shape);
        }
        throw new IllegalArgumentException("The new shape is not commensurate with the old shape");
    }

    @Override
    public final Array8D movedims(int initpos, int finalpos) {
        int k;
        if (finalpos > 7 || initpos > 7) {
            throw new IllegalArgumentException("The permutation should not change the rank");
        }
        if (initpos == finalpos) {
            return this.copy();
        }
        int[] newdims = new int[8];
        if (initpos < finalpos) {
            for (k = 0; k < initpos; ++k) {
                newdims[k] = this.shape.dimension(k);
            }
            for (k = initpos; k < finalpos; ++k) {
                newdims[k] = this.shape.dimension(k + 1);
            }
            newdims[finalpos] = this.shape.dimension(initpos);
            for (k = finalpos + 1; k < 8; ++k) {
                newdims[k] = this.shape.dimension(k);
            }
        } else {
            for (k = 0; k < finalpos; ++k) {
                newdims[k] = this.shape.dimension(k);
            }
            newdims[finalpos] = this.shape.dimension(initpos);
            for (k = finalpos + 1; k < initpos + 1; ++k) {
                newdims[k] = this.shape.dimension(k - 1);
            }
            for (k = initpos + 1; k < 8; ++k) {
                newdims[k] = this.shape.dimension(k);
            }
        }
        Array8D newArray = (Array8D)ArrayFactory.create(this.getType(), newdims);
        for (int n = 0; n < this.shape.dimension(initpos); ++n) {
            newArray.slice(n, finalpos).assign(this.slice(n, initpos));
        }
        return newArray;
    }

    @Override
    public abstract Array8D copy();

    public abstract Array7D slice(int var1);

    public abstract Array7D slice(int var1, int var2);

    public abstract Array8D view(Range var1, Range var2, Range var3, Range var4, Range var5, Range var6, Range var7, Range var8);

    public abstract Array8D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8);

    @Override
    public abstract Array1D as1D();

    public static int checkViewStrides(int number, int offset, int stride1, int stride2, int stride3, int stride4, int stride5, int stride6, int stride7, int stride8, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8) {
        int imax;
        int imin;
        int itmp = (dim1 - 1) * stride1;
        if (itmp >= 0) {
            imin = offset;
            imax = offset + itmp;
        } else {
            imin = offset + itmp;
            imax = offset;
        }
        itmp = (dim2 - 1) * stride2;
        if (itmp >= 0) {
            imax += itmp;
        } else {
            imin += itmp;
        }
        itmp = (dim3 - 1) * stride3;
        if (itmp >= 0) {
            imax += itmp;
        } else {
            imin += itmp;
        }
        itmp = (dim4 - 1) * stride4;
        if (itmp >= 0) {
            imax += itmp;
        } else {
            imin += itmp;
        }
        itmp = (dim5 - 1) * stride5;
        if (itmp >= 0) {
            imax += itmp;
        } else {
            imin += itmp;
        }
        itmp = (dim6 - 1) * stride6;
        if (itmp >= 0) {
            imax += itmp;
        } else {
            imin += itmp;
        }
        itmp = (dim7 - 1) * stride7;
        if (itmp >= 0) {
            imax += itmp;
        } else {
            imin += itmp;
        }
        itmp = (dim8 - 1) * stride8;
        if (itmp >= 0) {
            imax += itmp;
        } else {
            imin += itmp;
        }
        if (imin < 0 || imax >= number) {
            throw new IndexOutOfBoundsException("8D view is not within available space");
        }
        int s1 = Math.abs(stride1);
        int s2 = Math.abs(stride2);
        int s3 = Math.abs(stride3);
        int s4 = Math.abs(stride4);
        int s5 = Math.abs(stride5);
        int s6 = Math.abs(stride6);
        int s7 = Math.abs(stride7);
        int s8 = Math.abs(stride8);
        if (s1 <= s2 && s2 <= s3 && s3 <= s4 && s4 <= s5 && s5 <= s6 && s6 <= s7 && s7 <= s8) {
            return 1;
        }
        if (s1 >= s2 && s2 >= s3 && s3 >= s4 && s4 >= s5 && s5 >= s6 && s6 >= s7 && s7 >= s8) {
            return 2;
        }
        return 0;
    }
}

