package plugins.tprovoost.Microscopy.microscopelive3d;

import plugins.tprovoost.Microscopy.MicroManagerForIcy.MicroscopePlugin;

public class MicroscopeLive3DPlugin extends MicroscopePlugin
{
    /**
     * static instance
     */
    static MicroscopeLive3D instance = null;

    public MicroscopeLive3DPlugin()
    {
        super();

        if (instance == null)
            instance = new MicroscopeLive3D(this);
    }

    @Override
    public void start()
    {
        if (instance != null)
            instance.toFront();
    }

    @Override
    public void shutdown()
    {
        super.shutdown();

        if (instance != null)
        {
            instance.shutdown();
            instance = null;
        }
    }

    @Override
    public void onExposureChanged(double newExposure)
    {
        if (instance != null)
            instance.onExposureChanged(newExposure);
    }
}