/*
 * Decompiled with CFR 0.152.
 */
package vtk.sample.rendering;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import vtk.rendering.jogl.vtkAbstractJoglComponent;
import vtk.rendering.jogl.vtkJoglCanvasComponent;
import vtk.rendering.jogl.vtkJoglPanelComponent;
import vtk.rendering.vtkAbstractEventInterceptor;
import vtk.vtkActor;
import vtk.vtkBoxRepresentation;
import vtk.vtkBoxWidget2;
import vtk.vtkCell;
import vtk.vtkCellPicker;
import vtk.vtkConeSource;
import vtk.vtkLookupTable;
import vtk.vtkNativeLibrary;
import vtk.vtkPolyDataMapper;
import vtk.vtkScalarBarRepresentation;
import vtk.vtkScalarBarWidget;
import vtk.vtkTransform;

public class JoglConeRendering {
    public static void main(String[] stringArray) {
        final boolean bl = Boolean.getBoolean("usePanel");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                vtkConeSource vtkConeSource2 = new vtkConeSource();
                vtkConeSource2.SetResolution(8);
                vtkConeSource2.Update();
                vtkPolyDataMapper vtkPolyDataMapper2 = new vtkPolyDataMapper();
                vtkPolyDataMapper2.SetInputConnection(vtkConeSource2.GetOutputPort());
                final vtkActor vtkActor2 = new vtkActor();
                vtkActor2.SetMapper(vtkPolyDataMapper2);
                final vtkAbstractJoglComponent vtkAbstractJoglComponent2 = bl ? new vtkJoglPanelComponent() : new vtkJoglCanvasComponent();
                System.out.println("We are using " + vtkAbstractJoglComponent2.getComponent().getClass().getName() + " for the rendering.");
                vtkAbstractJoglComponent2.getRenderer().AddActor(vtkActor2);
                vtkAbstractJoglComponent.attachOrientationAxes(vtkAbstractJoglComponent2);
                vtkLookupTable vtkLookupTable2 = new vtkLookupTable();
                vtkLookupTable2.SetHueRange(0.66, 0.0);
                vtkLookupTable2.Build();
                vtkScalarBarWidget vtkScalarBarWidget2 = new vtkScalarBarWidget();
                vtkScalarBarWidget2.SetInteractor(vtkAbstractJoglComponent2.getRenderWindowInteractor());
                vtkScalarBarWidget2.GetScalarBarActor().SetTitle("Example");
                vtkScalarBarWidget2.GetScalarBarActor().SetLookupTable(vtkLookupTable2);
                vtkScalarBarWidget2.GetScalarBarActor().SetOrientationToHorizontal();
                vtkScalarBarWidget2.GetScalarBarActor().SetTextPositionToPrecedeScalarBar();
                vtkScalarBarRepresentation vtkScalarBarRepresentation2 = (vtkScalarBarRepresentation)vtkScalarBarWidget2.GetRepresentation();
                vtkScalarBarRepresentation2.SetPosition(0.5, 0.053796);
                vtkScalarBarRepresentation2.SetPosition2(0.33, 0.106455);
                vtkScalarBarWidget2.EnabledOn();
                vtkScalarBarWidget2.RepositionableOn();
                vtkBoxRepresentation vtkBoxRepresentation2 = new vtkBoxRepresentation();
                vtkBoxRepresentation2.SetPlaceFactor(1.25);
                vtkBoxRepresentation2.PlaceWidget(vtkConeSource2.GetOutput().GetBounds());
                final vtkBoxWidget2 vtkBoxWidget22 = new vtkBoxWidget2();
                vtkBoxWidget22.SetRepresentation(vtkBoxRepresentation2);
                vtkBoxWidget22.SetInteractor(vtkAbstractJoglComponent2.getRenderWindowInteractor());
                vtkBoxWidget22.SetPriority(1.0);
                Runnable runnable = new Runnable(){
                    vtkTransform trasform = new vtkTransform();

                    @Override
                    public void run() {
                        vtkBoxRepresentation vtkBoxRepresentation2 = (vtkBoxRepresentation)vtkBoxWidget22.GetRepresentation();
                        vtkBoxRepresentation2.GetTransform(this.trasform);
                        vtkActor2.SetUserTransform(this.trasform);
                    }
                };
                vtkBoxWidget22.AddObserver("InteractionEvent", runnable, "run");
                vtkBoxRepresentation2.VisibilityOn();
                vtkBoxRepresentation2.HandlesOn();
                vtkBoxWidget22.SetEnabled(1);
                vtkBoxWidget22.SetMoveFacesEnabled(1);
                final vtkCellPicker vtkCellPicker2 = new vtkCellPicker();
                Runnable runnable2 = new Runnable(){

                    @Override
                    public void run() {
                        if (vtkCellPicker2.GetCellId() != -1) {
                            vtkCell vtkCell2 = vtkCellPicker2.GetDataSet().GetCell(vtkCellPicker2.GetCellId());
                            System.out.println("Pick cell: " + vtkCellPicker2.GetCellId() + " - Bounds: " + Arrays.toString(vtkCell2.GetBounds()));
                        }
                    }
                };
                vtkAbstractJoglComponent2.getRenderWindowInteractor().SetPicker(vtkCellPicker2);
                vtkCellPicker2.AddObserver("EndPickEvent", runnable2, "run");
                vtkAbstractJoglComponent2.getInteractorForwarder().setEventInterceptor(new vtkAbstractEventInterceptor(){

                    @Override
                    public boolean mouseClicked(MouseEvent mouseEvent) {
                        double[] dArray = new double[]{mouseEvent.getX(), ((Component)vtkAbstractJoglComponent2.getComponent()).getHeight() - mouseEvent.getY(), 0.0};
                        if (mouseEvent.getClickCount() == 2) {
                            System.out.println("Click trigger the picking (" + dArray[0] + ", " + dArray[1] + ")");
                            vtkCellPicker2.Pick(dArray, vtkAbstractJoglComponent2.getRenderer());
                        }
                        return false;
                    }
                });
                JFrame jFrame = new JFrame("SimpleVTK");
                jFrame.setDefaultCloseOperation(3);
                jFrame.getContentPane().setLayout(new BorderLayout());
                jFrame.getContentPane().add((Component)vtkAbstractJoglComponent2.getComponent(), "Center");
                jFrame.setSize(400, 400);
                jFrame.setLocationRelativeTo(null);
                jFrame.setVisible(true);
                vtkAbstractJoglComponent2.resetCamera();
                ((Component)vtkAbstractJoglComponent2.getComponent()).requestFocus();
                ((Component)vtkAbstractJoglComponent2.getComponent()).addKeyListener(new KeyListener(){

                    @Override
                    public void keyTyped(KeyEvent keyEvent) {
                        if (keyEvent.getKeyChar() == 'r') {
                            vtkAbstractJoglComponent2.resetCamera();
                        } else if (keyEvent.getKeyChar() == 'q') {
                            System.exit(0);
                        }
                    }

                    @Override
                    public void keyReleased(KeyEvent keyEvent) {
                    }

                    @Override
                    public void keyPressed(KeyEvent keyEvent) {
                    }
                });
            }
        });
    }

    static {
        if (!vtkNativeLibrary.LoadAllNativeLibraries()) {
            for (vtkNativeLibrary vtkNativeLibrary2 : vtkNativeLibrary.values()) {
                if (vtkNativeLibrary2.IsLoaded()) continue;
                System.out.println(vtkNativeLibrary2.GetLibraryName() + " not loaded");
            }
        }
        vtkNativeLibrary.DisableOutputWindow(null);
    }
}

