/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.lang;

import plugins.adufour.vars.gui.VarEditor;
import plugins.adufour.vars.gui.VarEditorFactory;
import plugins.adufour.vars.gui.model.RangeModel;
import plugins.adufour.vars.gui.model.VarEditorModel;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.util.VarListener;

public abstract class VarNumber<N extends Number>
extends Var<N>
implements Comparable<N> {
    public VarNumber(String name, Class<N> type, N defaultValue) {
        this(name, type, defaultValue, (VarListener<N>)null);
    }

    public VarNumber(String name, Class<N> type, N defaultValue, VarListener<N> defaultListener) {
        super(name, type, defaultValue, defaultListener);
    }

    public VarNumber(String name, VarEditorModel<N> editorModel) {
        super(name, editorModel);
    }

    @Override
    public boolean isAssignableFrom(Var<?> source) {
        if (source.getType() == null) {
            return false;
        }
        Class<?> sourceType = source.getType();
        return sourceType == Double.TYPE || sourceType == Float.TYPE || sourceType == Integer.TYPE || Number.class.isAssignableFrom(source.getType());
    }

    @Override
    public VarEditor<N> createVarEditor() {
        VarEditorFactory factory = VarEditorFactory.getDefaultFactory();
        if (this.getDefaultEditorModel() instanceof RangeModel) {
            RangeModel.RangeEditorType editorType = ((RangeModel)this.getDefaultEditorModel()).getEditorType();
            switch (editorType) {
                case SLIDER: {
                    return factory.createSlider(this);
                }
                case SPINNER: {
                    return factory.createSpinner(this);
                }
            }
            throw new UnsupportedOperationException("Editor not yet implemented: " + (Object)((Object)editorType));
        }
        if (this.getDefaultEditorModel() == null) {
            return factory.createTextField(this);
        }
        return super.createVarEditor();
    }

    @Override
    protected boolean areValuesEqual(Number a, Object b) {
        if (b instanceof Number) {
            return Double.compare(a.doubleValue(), ((Number)b).doubleValue()) == 0;
        }
        return false;
    }
}

