/*
 * Decompiled with CFR 0.152.
 */
package plugins.stef.roi.quantify;

import icy.gui.dialog.MessageDialog;
import icy.math.Line3DIterator;
import icy.math.MathUtil;
import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI3D;
import icy.sequence.Sequence;
import icy.type.collection.CollectionUtil;
import icy.type.geom.Line3D;
import icy.type.point.Point3D;
import icy.type.point.Point4D;
import icy.type.rectangle.Rectangle5D;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzGUI;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.vars.gui.swing.WorkbookEditor;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.lang.VarWorkbook;
import plugins.adufour.workbooks.IcySpreadSheet;
import plugins.adufour.workbooks.Workbooks;
import plugins.kernel.roi.roi2d.ROI2DLine;
import plugins.kernel.roi.roi2d.ROI2DPoint;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DRectangle;
import plugins.kernel.roi.roi2d.ROI2DShape;
import plugins.kernel.roi.roi3d.ROI3DLine;
import plugins.kernel.roi.roi3d.ROI3DPoint;
import plugins.kernel.roi.roi3d.ROI3DPolyLine;
import plugins.kernel.roi.roi3d.ROI3DShape;

public class PathIntensityProfiler
extends EzPlug
implements Block,
EzStoppable {
    public final VarSequence varSequence = new VarSequence("Sequence", null);
    public final VarROIArray varRois = new VarROIArray("Roi(s)");
    public final EzVarBoolean varRealUnit = new EzVarBoolean("Use real unit", false);
    public final VarWorkbook varWorkbook = new VarWorkbook("WorkBook", Workbooks.createEmptyWorkbook((Workbooks.WorkbookFormat)Workbooks.WorkbookFormat.XLSX));

    protected void initialize() {
        WorkbookEditor viewer = (WorkbookEditor)this.varWorkbook.createVarViewer();
        viewer.setEnabled(true);
        viewer.setFirstRowAsHeader(true);
        JComponent jc = viewer.getEditorComponent();
        jc.setPreferredSize(new Dimension(400, 300));
        this.addComponent(jc);
        this.addEzComponent((EzComponent)this.varRealUnit);
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("sequence", (Var)this.varSequence);
        inputMap.add("rois", (Var)this.varRois);
        inputMap.add("realUnit", this.varRealUnit.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("workbook", (Var)this.varWorkbook);
    }

    public void clean() {
        this.varWorkbook.setValue((Object)Workbooks.createEmptyWorkbook((Workbooks.WorkbookFormat)Workbooks.WorkbookFormat.XLSX));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() {
        Sequence sequence;
        this.varWorkbook.setValue((Object)Workbooks.createEmptyWorkbook((Workbooks.WorkbookFormat)Workbooks.WorkbookFormat.XLSX));
        if (!this.isHeadLess()) {
            Sequence seq = this.getActiveSequence();
            if (seq != null) {
                this.varSequence.setValue(seq);
                this.varRois.setValue((Object)seq.getROIs().toArray(new ROI[0]));
            } else {
                MessageDialog.showDialog((String)"You need to open an image containing ROI(s).", (int)1);
                return;
            }
        }
        if ((sequence = (Sequence)this.varSequence.getValue()) != null) {
            ROI[] rois = (ROI[])this.varRois.getValue();
            ArrayList<ROI> validRois = new ArrayList<ROI>();
            for (ROI roi : rois) {
                if (roi instanceof ROI2D) {
                    validRois.add(roi);
                    continue;
                }
                if (!(roi instanceof ROI3D)) continue;
                validRois.add(roi);
            }
            if (validRois.size() == 0) {
                if (!this.isHeadLess()) {
                    MessageDialog.showDialog((String)"The selected Sequence doesn't contain any ROI where we can compute intensity profil.", (int)1);
                }
                return;
            }
            if (!this.isHeadLess()) {
                this.getUI().setProgressBarMessage("Computing...");
            }
            try {
                this.varWorkbook.setValue((Object)PathIntensityProfiler.getPathIntensityProfil(sequence, validRois, (Boolean)this.varRealUnit.getValue(), this.getUI()));
            }
            finally {
                if (!this.isHeadLess()) {
                    this.getUI().setProgressBarMessage("Done");
                    this.getUI().setProgressBarValue(0.0);
                }
            }
        }
    }

    private static XSSFWorkbook getPathIntensityProfil(Sequence sequence, List<ROI> rois, boolean useRealUnit, EzGUI ui) {
        XSSFWorkbook result = (XSSFWorkbook)Workbooks.createEmptyWorkbook((Workbooks.WorkbookFormat)Workbooks.WorkbookFormat.XLSX);
        if (rois.isEmpty()) {
            return result;
        }
        int sizeT = sequence.getSizeT();
        int sizeZ = sequence.getSizeZ();
        int sizeC = sequence.getSizeC();
        Point4D.Double unitScale = new Point4D.Double();
        if (useRealUnit) {
            unitScale.x = sequence.getPixelSizeX();
            unitScale.y = sequence.getPixelSizeY();
            unitScale.z = sequence.getPixelSizeZ();
            unitScale.t = sequence.getTimeInterval();
        } else {
            unitScale.x = 1.0;
            unitScale.y = 1.0;
            unitScale.z = 1.0;
            unitScale.t = 1.0;
        }
        double progressRatio = rois.size() * sizeT * sizeZ * sizeC;
        int roiIndex = 0;
        for (ROI roi : rois) {
            IcySpreadSheet sh = new IcySpreadSheet((Sheet)result.createSheet(String.format("S%04d - ", roiIndex) + roi.getName().replace(':', '_')));
            int indCol = 0;
            sh.setValue(0, indCol++, (Object)"Point #");
            sh.setValue(0, indCol++, (Object)("X" + (useRealUnit ? " (um)" : "")));
            sh.setValue(0, indCol++, (Object)("Y" + (useRealUnit ? " (um)" : "")));
            sh.setValue(0, indCol++, (Object)("Z" + (useRealUnit ? " (um)" : "")));
            sh.setValue(0, indCol++, (Object)("T" + (useRealUnit ? " (s)" : "")));
            for (int c = 0; c < sizeC; ++c) {
                sh.setValue(0, indCol++, (Object)("ch " + c + " (" + sequence.getChannelName(c) + ")"));
            }
            Rectangle5D roiBounds = roi.getBounds5D();
            int row = 1;
            for (int t = 0; t < sizeT; ++t) {
                int roiT;
                if (roi instanceof ROI2D ? (roiT = ((ROI2D)roi).getT()) != -1 && roiT != t : (roi instanceof ROI3D ? (roiT = ((ROI3D)roi).getT()) != -1 && roiT != t : roiBounds.getMinT() > (double)t || roiBounds.getMaxT() < (double)t)) continue;
                for (int z = 0; z < sizeZ; ++z) {
                    int roiZ;
                    if (!(roi instanceof ROI2D) ? z > 0 : (roiZ = ((ROI2D)roi).getZ()) != -1 && roiZ != z) continue;
                    if (Thread.currentThread().isInterrupted()) {
                        return result;
                    }
                    int ptIndex = 0;
                    int zStartRow = row;
                    for (int c = 0; c < sizeC; ++c) {
                        ArrayList pts;
                        if (roiBounds.getMinC() > (double)c || roiBounds.getMaxC() < (double)c) continue;
                        if (ui != null) {
                            double progress = roiIndex;
                            progress *= (double)(sizeT * sizeZ * sizeC);
                            progress += (double)(t * sizeZ * sizeC);
                            progress += (double)(z * sizeC);
                            progress += (double)c;
                            ui.setProgressBarValue(progress /= progressRatio);
                        }
                        if (c > 0) {
                            row = zStartRow;
                        }
                        boolean interpolate = true;
                        if (roi instanceof ROI3DPoint || roi instanceof ROI3DLine || roi instanceof ROI3DPolyLine) {
                            pts = ((ROI3DShape)roi).getPoints();
                        } else if (roi instanceof ROI2DPoint || roi instanceof ROI2DLine || roi instanceof ROI2DPolyLine || roi instanceof ROI2DPolygon || roi instanceof ROI2DRectangle) {
                            pts = ((ROI2DShape)roi).getPoints();
                        } else {
                            pts = new ArrayList();
                            interpolate = false;
                            if (roi instanceof ROI2D) {
                                for (BooleanMask2D mask : ((ROI2D)roi).getBooleanMask(true).getComponents()) {
                                    pts.addAll(mask.getConnectedContourPoints());
                                }
                            } else if (roi instanceof ROI3D) {
                                pts.addAll(CollectionUtil.asList((Object[])((ROI3D)roi).getBooleanMask(true).getContourPoints()));
                            }
                        }
                        if (interpolate) {
                            Point3D startPt = PathIntensityProfiler.getPoint3D(pts.get(0), z);
                            if (pts.size() == 1) {
                                PathIntensityProfiler.writeRow(sh, row++, ptIndex++, t, c, sequence, startPt, (Point4D)unitScale);
                                continue;
                            }
                            for (int i = 1; i < pts.size(); ++i) {
                                Point3D endPt = PathIntensityProfiler.getPoint3D(pts.get(i), z);
                                Line3DIterator lineIt = new Line3DIterator(new Line3D(startPt, endPt), 1.0, false);
                                while (lineIt.hasNext()) {
                                    PathIntensityProfiler.writeRow(sh, row++, ptIndex++, t, c, sequence, lineIt.next(), (Point4D)unitScale);
                                }
                                startPt = endPt;
                            }
                            continue;
                        }
                        for (int i = 0; i < pts.size(); ++i) {
                            PathIntensityProfiler.writeRow(sh, row++, ptIndex++, t, c, sequence, PathIntensityProfiler.getPoint3D(pts.get(i), z), (Point4D)unitScale);
                        }
                    }
                }
            }
            ++roiIndex;
        }
        return result;
    }

    public static XSSFWorkbook getPathIntensityProfil(Sequence sequence, List<ROI> rois, boolean useRealUnit) {
        return PathIntensityProfiler.getPathIntensityProfil(sequence, rois, useRealUnit, null);
    }

    private static Point3D getPoint3D(Object obj, int curZ) {
        Point3D result;
        if (obj instanceof Point) {
            Point pt2d = (Point)obj;
            result = new Point3D.Double(pt2d.getX(), pt2d.getY(), (double)curZ);
        } else if (obj instanceof Point2D) {
            Point2D pt2d = (Point2D)obj;
            result = new Point3D.Double(pt2d.getX(), pt2d.getY(), (double)curZ);
        } else {
            result = obj instanceof Point3D ? (Point3D)obj : null;
        }
        return result;
    }

    private static void writeRow(IcySpreadSheet sh, int row, int ind, int t, int c, Sequence sequence, Point3D pt, Point4D unitScale) {
        sh.setValue(row, 0, (Object)ind);
        sh.setValue(row, 1, (Object)MathUtil.roundSignificant((double)(pt.getX() * unitScale.getX()), (int)5, (boolean)true));
        sh.setValue(row, 2, (Object)MathUtil.roundSignificant((double)(pt.getY() * unitScale.getY()), (int)5, (boolean)true));
        sh.setValue(row, 3, (Object)MathUtil.roundSignificant((double)(pt.getZ() * unitScale.getZ()), (int)5, (boolean)true));
        if (unitScale.getT() == 1.0) {
            sh.setValue(row, 4, (Object)t);
        } else {
            sh.setValue(row, 4, (Object)MathUtil.roundSignificant((double)((double)t * unitScale.getT()), (int)5, (boolean)true));
        }
        sh.setValue(row, 5 + c, (Object)MathUtil.roundSignificant((double)sequence.getDataInterpolated(t, pt.getZ(), c, pt.getY(), pt.getX()), (int)5, (boolean)true));
    }
}

