/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.frame.progress;

import icy.gui.frame.progress.ProgressFrame;
import icy.system.thread.ThreadUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class CancelableProgressFrame
extends ProgressFrame
implements ActionListener {
    JButton cancelBtn;
    private boolean cancelRequested = false;

    public CancelableProgressFrame(String message) {
        super(message);
        if (this.headless) {
            return;
        }
        ThreadUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                CancelableProgressFrame.this.cancelBtn = new JButton("Cancel");
                CancelableProgressFrame.this.cancelBtn.setFocusPainted(false);
                CancelableProgressFrame.this.cancelBtn.addActionListener(CancelableProgressFrame.this);
                CancelableProgressFrame.this.mainPanel.add((Component)CancelableProgressFrame.this.cancelBtn, "East");
                CancelableProgressFrame.this.pack();
            }
        });
    }

    @Override
    public void onClosed() {
        super.onClosed();
        this.cancelRequested = true;
    }

    public void cancel() {
        this.cancelRequested = true;
        this.close();
    }

    public boolean isCancelRequested() {
        return this.cancelRequested;
    }

    public void setCancelEnabled(boolean enabled) {
        if (this.cancelBtn != null) {
            this.cancelBtn.setEnabled(enabled);
        }
    }

    public void addCancelListener(ActionListener listener) {
        this.cancelBtn.addActionListener(listener);
    }

    public void removeCancelListener(ActionListener listener) {
        this.cancelBtn.removeActionListener(listener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.cancelRequested = true;
        this.close();
    }

    @Override
    public boolean notifyProgress(double position, double length) {
        if (this.isCancelRequested()) {
            return false;
        }
        return super.notifyProgress(position, length);
    }
}

