/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.viewer;

import icy.action.CanvasActions;
import icy.action.SequenceOperationActions;
import icy.action.ViewerActions;
import icy.action.WindowActions;
import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.canvas.IcyCanvasEvent;
import icy.canvas.IcyCanvasListener;
import icy.common.MenuCallback;
import icy.common.listener.ProgressListener;
import icy.gui.component.button.IcyButton;
import icy.gui.component.button.IcyToggleButton;
import icy.gui.component.renderer.LabelComboBoxRenderer;
import icy.gui.dialog.ConfirmDialog;
import icy.gui.dialog.MessageDialog;
import icy.gui.dialog.SaverDialog;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.IcyFrameAdapter;
import icy.gui.frame.IcyFrameEvent;
import icy.gui.frame.progress.ToolTipFrame;
import icy.gui.lut.LUTViewer;
import icy.gui.lut.abstract_.IcyLutViewer;
import icy.gui.plugin.PluginComboBoxRenderer;
import icy.gui.util.ComponentUtil;
import icy.gui.viewer.TNavigationPanel;
import icy.gui.viewer.ViewerEvent;
import icy.gui.viewer.ViewerListener;
import icy.image.IcyBufferedImage;
import icy.image.cache.ImageCache;
import icy.image.lut.LUT;
import icy.main.Icy;
import icy.plugin.PluginLoader;
import icy.preferences.GeneralPreferences;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import icy.system.IcyExceptionHandler;
import icy.system.IcyHandledException;
import icy.system.thread.ThreadUtil;
import icy.util.GraphicsUtil;
import icy.util.Random;
import icy.util.StringUtil;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.event.EventListenerList;
import plugins.kernel.canvas.VtkCanvas;
import plugins.kernel.canvas.VtkCanvasPlugin;

public class Viewer
extends IcyFrame
implements KeyListener,
SequenceListener,
IcyCanvasListener,
PluginLoader.PluginLoaderListener {
    private static boolean toolTipVirtualDone = false;
    private LUT lut;
    private IcyCanvas canvas;
    Sequence sequence;
    private final EventListenerList listeners = new EventListenerList();
    private JToolBar toolBar;
    private ViewerMainPanel mainPanel;
    private LUTViewer lutViewer;
    JComboBox canvasComboBox;
    JComboBox lockComboBox;
    IcyToggleButton layersEnabledButton;
    IcyButton screenShotButton;
    IcyButton screenShotAlternateButton;
    IcyButton duplicateButton;
    IcyButton switchStateButton;
    IcyToggleButton virtualButton;
    boolean initialized;
    private final Runnable lutUpdater;
    boolean settingCanvas;

    public Viewer(Sequence sequence, boolean visible) {
        super("Viewer", true, true, true, true);
        if (sequence == null) {
            throw new IllegalArgumentException("Can't open a null sequence.");
        }
        this.sequence = sequence;
        this.canvas = null;
        this.lut = null;
        this.lutViewer = null;
        this.initialized = false;
        this.settingCanvas = false;
        this.lutUpdater = new Runnable(){

            @Override
            public void run() {
                ThreadUtil.sleep(1);
                ThreadUtil.invokeNow(new Runnable(){

                    @Override
                    public void run() {
                        LUT lut = Viewer.this.getLut();
                        if (lut != null) {
                            Viewer.this.setLutViewer(new LUTViewer(Viewer.this, lut));
                            Viewer.this.fireViewerChanged(ViewerEvent.ViewerEventType.LUT_CHANGED);
                        }
                    }
                });
            }
        };
        this.mainPanel = new ViewerMainPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.setSystemMenuCallback(new MenuCallback(){

            @Override
            public JMenu getMenu() {
                return Viewer.this.getMenu();
            }
        });
        this.buildToolBar();
        LUT lut = sequence.createCompatibleLUT();
        if (sequence.hasUserLUT()) {
            LUT userLut = sequence.getUserLUT();
            lut.setColorMaps(userLut, false);
            lut.setScalers(userLut);
        }
        this.setLut(lut);
        this.setCanvas(IcyCanvas.getCanvasPluginNames().get(0));
        this.setLayout(new BorderLayout());
        this.add(this.toolBar, "North");
        this.add(this.mainPanel, "Center");
        this.refreshViewerTitle();
        this.setFocusable(true);
        this.setLocationInternal(20 + Random.nextInt(100), 20 + Random.nextInt(60));
        this.setLocationExternal(100 + Random.nextInt(200), 100 + Random.nextInt(150));
        this.setSize(640, 480);
        if (sequence.isEmpty()) {
            this.setPositionZ(0);
        } else {
            this.setPositionZ((sequence.getSizeZ() + 1) / 2 - 1);
        }
        this.addFrameListener(new IcyFrameAdapter(){

            @Override
            public void icyFrameOpened(IcyFrameEvent e) {
                if (!Viewer.this.initialized && Viewer.this.sequence != null && !Viewer.this.sequence.isEmpty()) {
                    Viewer.this.adjustViewerToImageSize();
                    Viewer.this.initialized = true;
                }
            }

            @Override
            public void icyFrameActivated(IcyFrameEvent e) {
                Icy.getMainInterface().setActiveViewer(Viewer.this);
            }

            @Override
            public void icyFrameExternalized(IcyFrameEvent e) {
                Viewer.this.refreshToolBar();
            }

            @Override
            public void icyFrameInternalized(IcyFrameEvent e) {
                Viewer.this.refreshToolBar();
            }

            @Override
            public void icyFrameClosing(IcyFrameEvent e) {
                Viewer.this.onClosing();
            }
        });
        this.addKeyListener(this);
        sequence.addListener(this);
        PluginLoader.addListener(this);
        Icy.getMainInterface().registerViewer(this);
        this.addToDesktopPane();
        if (visible) {
            this.setVisible(true);
            this.requestFocus();
            this.toFront();
        } else {
            this.setVisible(false);
        }
        this.buildActionMap();
    }

    public Viewer(Sequence sequence) {
        this(sequence, true);
    }

    void buildActionMap() {
        this.buildActionMap(this.getInputMap(0), this.getActionMap());
    }

    protected void buildActionMap(InputMap imap, ActionMap amap) {
        imap.put(WindowActions.gridTileAction.getKeyStroke(), WindowActions.gridTileAction.getName());
        imap.put(WindowActions.horizontalTileAction.getKeyStroke(), WindowActions.horizontalTileAction.getName());
        imap.put(WindowActions.verticalTileAction.getKeyStroke(), WindowActions.verticalTileAction.getName());
        imap.put(CanvasActions.globalDisableSyncAction.getKeyStroke(), CanvasActions.globalDisableSyncAction.getName());
        imap.put(CanvasActions.globalSyncGroup1Action.getKeyStroke(), CanvasActions.globalSyncGroup1Action.getName());
        imap.put(CanvasActions.globalSyncGroup2Action.getKeyStroke(), CanvasActions.globalSyncGroup2Action.getName());
        imap.put(CanvasActions.globalSyncGroup3Action.getKeyStroke(), CanvasActions.globalSyncGroup3Action.getName());
        imap.put(CanvasActions.globalSyncGroup4Action.getKeyStroke(), CanvasActions.globalSyncGroup4Action.getName());
        amap.put(WindowActions.gridTileAction.getName(), WindowActions.gridTileAction);
        amap.put(WindowActions.horizontalTileAction.getName(), WindowActions.horizontalTileAction);
        amap.put(WindowActions.verticalTileAction.getName(), WindowActions.verticalTileAction);
        amap.put(CanvasActions.globalDisableSyncAction.getName(), CanvasActions.globalDisableSyncAction);
        amap.put(CanvasActions.globalSyncGroup1Action.getName(), CanvasActions.globalSyncGroup1Action);
        amap.put(CanvasActions.globalSyncGroup2Action.getName(), CanvasActions.globalSyncGroup2Action);
        amap.put(CanvasActions.globalSyncGroup3Action.getName(), CanvasActions.globalSyncGroup3Action);
        amap.put(CanvasActions.globalSyncGroup4Action.getName(), CanvasActions.globalSyncGroup4Action);
    }

    protected void onClosing() {
        if (this.sequence != null && this.sequence.getFilename() == null && GeneralPreferences.getSaveNewSequence()) {
            int res = ConfirmDialog.confirmEx("Save sequence", "Do you want to save '" + this.sequence.getName() + "' before closing it ?", 1);
            switch (res) {
                case 0: {
                    new SaverDialog(this.sequence);
                }
                case 1: {
                    this.setDefaultCloseOperation(2);
                    break;
                }
                default: {
                    this.setDefaultCloseOperation(0);
                }
            }
            return;
        }
        this.setDefaultCloseOperation(2);
    }

    @Override
    public void onClosed() {
        ViewerListener[] vls;
        this.fireViewerClosed();
        this.sequence.removeListener(this);
        if (this.canvas != null) {
            this.canvas.removeCanvasListener(this);
        }
        PluginLoader.removeListener(this);
        Icy.getMainInterface().unRegisterViewer(this);
        if (this.canvas != null) {
            this.canvas.shutDown();
        }
        if (this.lutViewer != null) {
            this.lutViewer.dispose();
        }
        if (this.mainPanel != null) {
            this.mainPanel.removeAll();
        }
        if (this.toolBar != null) {
            this.toolBar.removeAll();
        }
        for (ViewerListener vl : vls = (ViewerListener[])this.listeners.getListeners(ViewerListener.class)) {
            this.listeners.remove(ViewerListener.class, vl);
        }
        this.lutViewer = null;
        this.mainPanel = null;
        this.canvas = null;
        this.sequence = null;
        this.lut = null;
        this.toolBar = null;
        this.canvasComboBox = null;
        this.lockComboBox = null;
        this.duplicateButton = null;
        this.layersEnabledButton = null;
        this.screenShotAlternateButton = null;
        this.screenShotButton = null;
        this.switchStateButton = null;
        this.virtualButton = null;
        super.onClosed();
    }

    void adjustViewerToImageSize() {
        if (this.canvas instanceof IcyCanvas2D) {
            IcyCanvas2D cnv = (IcyCanvas2D)this.canvas;
            int ix = cnv.getImageSizeX();
            int iy = cnv.getImageSizeY();
            if (ix > 0 && iy > 0) {
                double scale = Math.min(Math.min(640.0 / (double)ix, 540.0 / (double)iy), 1.0);
                cnv.setScaleX(scale);
                cnv.setScaleY(scale);
                cnv.fitCanvasToImage();
            }
        }
        Dimension size = new Dimension(Math.max(this.getWidth(), 400), Math.max(this.getHeight(), 240));
        Dimension minSize = new Dimension(200, 140);
        this.setSizeExternal(size);
        this.setSizeInternal(size);
        this.setMinimumSizeInternal(minSize);
        this.setMinimumSizeExternal(minSize);
    }

    JMenu getMenu() {
        JMenu result = this.getDefaultSystemMenu();
        JMenuItem overlayItem = new JMenuItem(CanvasActions.toggleLayersAction);
        if (this.canvas != null && this.canvas.isLayersVisible()) {
            overlayItem.setText("Hide layers");
        } else {
            overlayItem.setText("Show layers");
        }
        JMenuItem duplicateItem = new JMenuItem(ViewerActions.duplicateAction);
        result.insert(overlayItem, 0);
        result.insertSeparator(1);
        result.insert(duplicateItem, 2);
        return result;
    }

    protected void buildLockCombo() {
        ArrayList<JLabel> labels = new ArrayList<JLabel>();
        labels.add(CanvasActions.disableSyncAction.getLabelComponent(true, false));
        labels.add(CanvasActions.syncGroup1Action.getLabelComponent(true, false));
        labels.add(CanvasActions.syncGroup2Action.getLabelComponent(true, false));
        labels.add(CanvasActions.syncGroup3Action.getLabelComponent(true, false));
        labels.add(CanvasActions.syncGroup4Action.getLabelComponent(true, false));
        this.lockComboBox = new JComboBox<Object>(labels.toArray());
        this.lockComboBox.setRenderer(new LabelComboBoxRenderer(this.lockComboBox));
        ComponentUtil.setFixedWidth(this.lockComboBox, 48);
        this.lockComboBox.setToolTipText("Select synchronisation group");
        this.lockComboBox.setFocusable(false);
        this.lockComboBox.setLightWeightPopupEnabled(false);
        this.lockComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Viewer.this.setViewSyncId(Viewer.this.lockComboBox.getSelectedIndex());
            }
        });
    }

    void buildCanvasCombo() {
        this.canvasComboBox = new JComboBox<Object>(IcyCanvas.getCanvasPluginNames().toArray());
        this.canvasComboBox.setRenderer(new PluginComboBoxRenderer(this.canvasComboBox, false));
        ComponentUtil.setFixedWidth(this.canvasComboBox, 48);
        this.canvasComboBox.setToolTipText("Select canvas type");
        this.canvasComboBox.setFocusable(false);
        this.canvasComboBox.setLightWeightPopupEnabled(false);
        this.canvasComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Viewer.this.setCanvas((String)Viewer.this.canvasComboBox.getSelectedItem());
            }
        });
    }

    protected void buildToolBar() {
        this.buildLockCombo();
        this.buildCanvasCombo();
        this.layersEnabledButton = new IcyToggleButton(new CanvasActions.ToggleLayersAction(true));
        this.layersEnabledButton.setHideActionText(true);
        this.layersEnabledButton.setFocusable(false);
        this.layersEnabledButton.setSelected(true);
        this.screenShotButton = new IcyButton(CanvasActions.screenShotAction);
        this.screenShotButton.setFocusable(false);
        this.screenShotButton.setHideActionText(true);
        this.screenShotAlternateButton = new IcyButton(CanvasActions.screenShotAlternateAction);
        this.screenShotAlternateButton.setFocusable(false);
        this.screenShotAlternateButton.setHideActionText(true);
        this.duplicateButton = new IcyButton(ViewerActions.duplicateAction);
        this.duplicateButton.setFocusable(false);
        this.duplicateButton.setHideActionText(true);
        this.switchStateButton = new IcyButton(this.getSwitchStateAction());
        this.switchStateButton.setFocusable(false);
        this.switchStateButton.setHideActionText(true);
        this.virtualButton = new IcyToggleButton(new SequenceOperationActions.ToggleVirtualSequenceAction(false));
        this.virtualButton.setFocusable(false);
        this.virtualButton.setHideActionText(true);
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.toolBar.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
        ComponentUtil.setPreferredHeight(this.toolBar, 26);
        this.updateToolbarComponents();
    }

    void updateToolbarComponents() {
        if (this.toolBar != null) {
            this.toolBar.removeAll();
            this.toolBar.add(this.lockComboBox);
            this.toolBar.addSeparator();
            this.toolBar.add(this.canvasComboBox);
            this.toolBar.addSeparator();
            this.toolBar.add(this.layersEnabledButton);
            if (this.canvas != null) {
                this.canvas.customizeToolbar(this.toolBar);
            }
            this.toolBar.add(Box.createHorizontalGlue());
            this.toolBar.addSeparator();
            this.toolBar.add(this.screenShotButton);
            this.toolBar.add(this.screenShotAlternateButton);
            this.toolBar.addSeparator();
            this.toolBar.add(this.duplicateButton);
            this.toolBar.add(this.switchStateButton);
            this.toolBar.addSeparator();
            this.toolBar.add(this.virtualButton);
        }
    }

    public void refreshLockCombo() {
        int syncId = this.getViewSyncId();
        this.lockComboBox.setEnabled(this.isSynchronizedViewSupported());
        this.lockComboBox.setSelectedIndex(syncId);
        switch (syncId) {
            case 0: {
                this.lockComboBox.setBackground(Color.gray);
                this.lockComboBox.setToolTipText("Synchronization disabled");
                break;
            }
            case 1: {
                this.lockComboBox.setBackground(Color.green);
                this.lockComboBox.setToolTipText("Full synchronization group 1 (view and Z/T position)");
                break;
            }
            case 2: {
                this.lockComboBox.setBackground(Color.yellow);
                this.lockComboBox.setToolTipText("Full synchronization group 2 (view and Z/T position)");
                break;
            }
            case 3: {
                this.lockComboBox.setBackground(Color.blue);
                this.lockComboBox.setToolTipText("View synchronization group (view synched but not Z/T position)");
                break;
            }
            case 4: {
                this.lockComboBox.setBackground(Color.red);
                this.lockComboBox.setToolTipText("Slice synchronization group (Z/T position synched but not view)");
            }
        }
    }

    public void refreshCanvasCombo() {
        String pluginName;
        if (this.canvas != null && (pluginName = IcyCanvas.getPluginClassName(this.canvas.getClass().getName())) != null && !this.canvasComboBox.getSelectedItem().equals(pluginName)) {
            this.canvasComboBox.setSelectedItem(pluginName);
        }
    }

    public void refreshToolBar() {
        boolean layersVisible = this.canvas != null ? this.canvas.isLayersVisible() : false;
        this.layersEnabledButton.setSelected(layersVisible);
        if (layersVisible) {
            this.layersEnabledButton.setToolTipText("Hide layers");
        } else {
            this.layersEnabledButton.setToolTipText("Show layers");
        }
        Sequence seq = this.getSequence();
        boolean virtual = seq != null && seq.isVirtual();
        this.virtualButton.setSelected(virtual);
        if (!ImageCache.isEnabled()) {
            this.virtualButton.setToolTipText("Image cache is disabled, cannot use virtual sequence");
        } else if (virtual) {
            this.virtualButton.setToolTipText("Disable virtual sequence (caching)");
            if (!toolTipVirtualDone) {
                ToolTipFrame tooltip = new ToolTipFrame("<html><img src=\"" + Icy.class.getResource("/image/help/viewer_virtual.jpg").toString() + "\" /><br><b>Your image has been made <i>virtual</i></b>.<br> This means that its data can be stored on disk to spare memory but this is at the cost of slower display / processing.<br>Also you should note that <b>some plugins aren't compatible with <i>virtual</i> images</b> and so the result may be inconsistent (possible data lost).</html>", 30, "viewerVirtual");
                tooltip.setSize(400, 180);
                toolTipVirtualDone = true;
            }
        } else {
            this.virtualButton.setToolTipText("Enable virtual sequence (caching)");
        }
        this.refreshLockCombo();
        this.refreshCanvasCombo();
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setLut(LUT value) {
        if (this.lut != value && this.sequence.isLutCompatible(value)) {
            this.lut = value;
            this.lutChanged();
        }
    }

    public LUT getLut() {
        if (this.sequence == null) {
            return this.lut;
        }
        if (this.lut == null || !this.sequence.isLutCompatible(this.lut)) {
            LUT newLut = this.sequence.createCompatibleLUT();
            if (this.lut != null && this.lut.getNumChannel() == newLut.getNumChannel()) {
                newLut.getColorSpace().setColorMaps(this.lut.getColorSpace(), true);
            }
            this.setLut(newLut);
        }
        return this.lut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCanvas(String pluginClassName) {
        if (this.canvas == null || !StringUtil.equals(this.canvas.getClass().getName(), IcyCanvas.getCanvasClassName(pluginClassName))) {
            try {
                int saveC;
                int saveT;
                int saveZ;
                int saveY;
                int saveX;
                IcyCanvas newCanvas;
                String className = pluginClassName;
                if (StringUtil.equals(className, VtkCanvasPlugin.class.getName())) {
                    for (Viewer v : Icy.getMainInterface().getViewers()) {
                        if (v == this || v.getSequence() != this.getSequence() || !(v.getCanvas() instanceof VtkCanvas)) continue;
                        if (ConfirmDialog.confirm("Caution", "You may experience problems using duplicated 3D view containing objects (ROI). Do you want to continue ?", 2)) break;
                        className = this.canvas.getClass().getName();
                        break;
                    }
                }
                this.settingCanvas = true;
                this.mainPanel.paintImmediately(this.mainPanel.getBounds());
                try {
                    newCanvas = IcyCanvas.create(className, this);
                }
                catch (Throwable e) {
                    if (!(e instanceof IcyHandledException)) {
                        if (e instanceof UnsupportedOperationException) {
                            MessageDialog.showDialog(e.getLocalizedMessage(), 0);
                        } else if (e instanceof Exception) {
                            IcyExceptionHandler.handleException(new ClassNotFoundException("Cannot find '" + className + "' class --> cannot create the canvas.", e), true);
                        } else {
                            IcyExceptionHandler.handleException(e, true);
                        }
                    }
                    newCanvas = IcyCanvas.create(this.canvas.getClass().getName(), this);
                }
                finally {
                    this.settingCanvas = false;
                }
                if (this.canvas != null) {
                    saveX = this.canvas.getPositionX();
                    saveY = this.canvas.getPositionY();
                    saveZ = this.canvas.getPositionZ();
                    saveT = this.canvas.getPositionT();
                    saveC = this.canvas.getPositionC();
                    this.canvas.removePropertyChangeListener("layersVisible", this);
                    this.canvas.removeCanvasListener(this);
                    this.canvas.shutDown();
                    this.mainPanel.remove(this.canvas);
                } else {
                    saveC = -1;
                    saveT = -1;
                    saveZ = -1;
                    saveY = -1;
                    saveX = -1;
                }
                newCanvas.addCanvasListener(this);
                newCanvas.addPropertyChangeListener("layersVisible", this);
                this.mainPanel.add((Component)newCanvas, "Center");
                if (saveX != -1) {
                    newCanvas.setPositionX(saveX);
                }
                if (saveY != -1) {
                    newCanvas.setPositionY(saveY);
                }
                if (saveZ != -1) {
                    newCanvas.setPositionZ(saveZ);
                }
                if (saveT != -1) {
                    newCanvas.setPositionT(saveT);
                }
                if (saveC != -1) {
                    newCanvas.setPositionC(saveC);
                }
                this.canvas = newCanvas;
            }
            catch (Throwable e) {
                IcyExceptionHandler.handleException(e, true);
            }
            this.mainPanel.revalidate();
            this.updateSystemMenu();
            this.updateToolbarComponents();
            this.refreshToolBar();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().upFocusCycle(this.getCanvas());
            this.fireViewerChanged(ViewerEvent.ViewerEventType.CANVAS_CHANGED);
        }
    }

    @Deprecated
    public void setCanvas(IcyCanvas value) {
        int saveC;
        int saveT;
        int saveZ;
        int saveY;
        int saveX;
        if (this.canvas == value) {
            return;
        }
        if (this.canvas != null) {
            saveX = this.canvas.getPositionX();
            saveY = this.canvas.getPositionY();
            saveZ = this.canvas.getPositionZ();
            saveT = this.canvas.getPositionT();
            saveC = this.canvas.getPositionC();
            this.canvas.removePropertyChangeListener("layersVisible", this);
            this.canvas.removeCanvasListener(this);
            this.canvas.shutDown();
            this.mainPanel.remove(this.canvas);
        } else {
            saveC = -1;
            saveT = -1;
            saveZ = -1;
            saveY = -1;
            saveX = -1;
        }
        this.canvas = value;
        if (this.canvas != null) {
            this.canvas.addCanvasListener(this);
            this.canvas.addPropertyChangeListener("layersVisible", this);
            this.mainPanel.add((Component)this.canvas, "Center");
            if (saveX != -1) {
                this.canvas.setPositionX(saveX);
            }
            if (saveY != -1) {
                this.canvas.setPositionY(saveY);
            }
            if (saveZ != -1) {
                this.canvas.setPositionZ(saveZ);
            }
            if (saveT != -1) {
                this.canvas.setPositionT(saveT);
            }
            if (saveC != -1) {
                this.canvas.setPositionC(saveC);
            }
        }
        this.mainPanel.revalidate();
        this.updateSystemMenu();
        this.updateToolbarComponents();
        this.refreshToolBar();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().upFocusCycle(this.getCanvas());
        this.fireViewerChanged(ViewerEvent.ViewerEventType.CANVAS_CHANGED);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public IcyCanvas getCanvas() {
        return this.canvas;
    }

    public JPanel getCanvasPanel() {
        if (this.canvas != null) {
            return this.canvas.getPanel();
        }
        return null;
    }

    public LUTViewer getLutViewer() {
        return this.lutViewer;
    }

    public void setLutViewer(LUTViewer value) {
        if (this.lutViewer != value) {
            if (this.lutViewer != null) {
                this.lutViewer.dispose();
            }
            this.lutViewer = value;
        }
    }

    @Deprecated
    public IcyLutViewer getLutPanel() {
        return this.getLutViewer();
    }

    @Deprecated
    public void setLutPanel(IcyLutViewer lutViewer) {
        this.setLutViewer((LUTViewer)lutViewer);
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public int getPositionT() {
        if (this.canvas != null) {
            return this.canvas.getPositionT();
        }
        return 0;
    }

    public void setPositionT(int t) {
        if (this.canvas != null) {
            this.canvas.setPositionT(t);
        }
    }

    public int getPositionZ() {
        if (this.canvas != null) {
            return this.canvas.getPositionZ();
        }
        return 0;
    }

    public void setPositionZ(int z) {
        if (this.canvas != null) {
            this.canvas.setPositionZ(z);
        }
    }

    public int getPositionC() {
        if (this.canvas != null) {
            return this.canvas.getPositionC();
        }
        return 0;
    }

    public void setPositionC(int c) {
        if (this.canvas != null) {
            this.canvas.setPositionC(c);
        }
    }

    @Deprecated
    public int getT() {
        return this.getPositionT();
    }

    @Deprecated
    public void setT(int t) {
        this.setPositionT(t);
    }

    @Deprecated
    public int getZ() {
        return this.getPositionZ();
    }

    @Deprecated
    public void setZ(int z) {
        this.setPositionZ(z);
    }

    @Deprecated
    public int getC() {
        return this.getPositionC();
    }

    @Deprecated
    public void setC(int c) {
        this.setPositionC(c);
    }

    public int getMaxT() {
        if (this.canvas != null) {
            return this.canvas.getMaxPositionT();
        }
        return 0;
    }

    public int getMaxZ() {
        if (this.canvas != null) {
            return this.canvas.getMaxPositionZ();
        }
        return 0;
    }

    public int getMaxC() {
        if (this.canvas != null) {
            return this.canvas.getMaxPositionC();
        }
        return 0;
    }

    public boolean isSynchronizedViewSupported() {
        if (this.canvas != null) {
            return this.canvas.isSynchronizationSupported();
        }
        return false;
    }

    public int getViewSyncId() {
        if (this.canvas != null) {
            return this.canvas.getSyncId();
        }
        return -1;
    }

    public boolean setViewSyncId(int id) {
        if (this.canvas != null) {
            return this.canvas.setSyncId(id);
        }
        return false;
    }

    public boolean isViewSynchronized() {
        if (this.canvas != null) {
            return this.canvas.isSynchronized();
        }
        return false;
    }

    public IcyBufferedImage getImage(int t, int z, int c) {
        if (this.canvas != null) {
            return this.canvas.getImage(t, z, c);
        }
        return null;
    }

    @Deprecated
    public IcyBufferedImage getImage(int t, int z) {
        return this.getImage(t, z, -1);
    }

    public IcyBufferedImage getCurrentImage() {
        if (this.canvas != null) {
            return this.canvas.getCurrentImage();
        }
        return null;
    }

    public int getNumSelectedSamples() {
        if (this.canvas != null) {
            return this.canvas.getNumSelectedSamples();
        }
        return 0;
    }

    public BufferedImage getRenderedImage(int t, int z, int c, boolean canvasView) {
        if (this.canvas == null) {
            return null;
        }
        return this.canvas.getRenderedImage(t, z, c, canvasView);
    }

    public Sequence getRenderedSequence(boolean canvasView, ProgressListener progressListener) {
        if (this.canvas == null) {
            return null;
        }
        return this.canvas.getRenderedSequence(canvasView, progressListener);
    }

    protected TNavigationPanel getTNavigationPanel() {
        if (this.canvas == null) {
            return null;
        }
        return this.canvas.getTNavigationPanel();
    }

    public int getFrameRate() {
        TNavigationPanel tNav = this.getTNavigationPanel();
        if (tNav != null) {
            return tNav.getFrameRate();
        }
        return 0;
    }

    public void setFrameRate(int fps) {
        TNavigationPanel tNav = this.getTNavigationPanel();
        if (tNav != null) {
            tNav.setFrameRate(fps);
        }
    }

    public boolean isRepeat() {
        TNavigationPanel tNav = this.getTNavigationPanel();
        if (tNav != null) {
            return tNav.isRepeat();
        }
        return false;
    }

    public void setRepeat(boolean value) {
        TNavigationPanel tNav = this.getTNavigationPanel();
        if (tNav != null) {
            tNav.setRepeat(value);
        }
    }

    public boolean isPlaying() {
        TNavigationPanel tNav = this.getTNavigationPanel();
        if (tNav != null) {
            return tNav.isPlaying();
        }
        return false;
    }

    public void startPlay() {
        TNavigationPanel tNav = this.getTNavigationPanel();
        if (tNav != null) {
            tNav.startPlay();
        }
    }

    public void stopPlay() {
        TNavigationPanel tNav = this.getTNavigationPanel();
        if (tNav != null) {
            tNav.stopPlay();
        }
    }

    public boolean isUnique() {
        return Icy.getMainInterface().isUniqueViewer(this);
    }

    protected void lutChanged() {
        ThreadUtil.bgRunSingle(this.lutUpdater);
    }

    protected void positionChanged(DimensionId dim) {
        this.fireViewerChanged(ViewerEvent.ViewerEventType.POSITION_CHANGED, dim);
    }

    public void addListener(ViewerListener listener) {
        this.listeners.add(ViewerListener.class, listener);
    }

    public void removeListener(ViewerListener listener) {
        this.listeners.remove(ViewerListener.class, listener);
    }

    void fireViewerChanged(ViewerEvent.ViewerEventType eventType, DimensionId dim) {
        ViewerEvent event = new ViewerEvent(this, eventType, dim);
        for (ViewerListener viewerListener : (ViewerListener[])this.listeners.getListeners(ViewerListener.class)) {
            viewerListener.viewerChanged(event);
        }
    }

    void fireViewerChanged(ViewerEvent.ViewerEventType event) {
        this.fireViewerChanged(event, DimensionId.NULL);
    }

    protected void fireViewerClosed() {
        for (ViewerListener viewerListener : (ViewerListener[])this.listeners.getListeners(ViewerListener.class)) {
            viewerListener.viewerClosed(this);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.canvas != null && !e.isConsumed()) {
            this.canvas.keyPressed(e);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.canvas != null && !e.isConsumed()) {
            this.canvas.keyReleased(e);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (this.canvas != null && !e.isConsumed()) {
            this.canvas.keyTyped(e);
        }
    }

    public void refreshViewerTitle() {
        if (this.sequence != null) {
            this.setTitle(this.sequence.getName());
        }
    }

    @Override
    public void sequenceChanged(SequenceEvent event) {
        switch (event.getSourceType()) {
            case SEQUENCE_META: {
                String meta = (String)event.getSource();
                if (StringUtil.isEmpty(meta) || StringUtil.equals(meta, "name")) {
                    this.refreshViewerTitle();
                }
                if (!this.initialized || !StringUtil.equals(meta, "virtual")) break;
                this.refreshToolBar();
                break;
            }
            case SEQUENCE_DATA: {
                break;
            }
            case SEQUENCE_TYPE: {
                if (!this.initialized && this.sequence != null && !this.sequence.isEmpty()) {
                    this.adjustViewerToImageSize();
                    this.initialized = true;
                }
                if (this.sequence.isLutCompatible(this.lut)) break;
                this.setLut(this.sequence.createCompatibleLUT());
                break;
            }
            case SEQUENCE_COLORMAP: {
                break;
            }
            case SEQUENCE_COMPONENTBOUNDS: {
                LUT sequenceLut = this.sequence.getDefaultLUT();
                if (sequenceLut.isCompatible(this.lut) && this.lutViewer != null) break;
                this.lut.setScalers(sequenceLut);
            }
        }
    }

    @Override
    public void sequenceClosed(Sequence sequence) {
    }

    @Override
    public void canvasChanged(IcyCanvasEvent event) {
        switch (event.getType()) {
            case POSITION_CHANGED: {
                this.positionChanged(event.getDim());
                break;
            }
            case SYNC_CHANGED: {
                ThreadUtil.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Viewer.this.refreshLockCombo();
                    }
                });
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (StringUtil.equals(evt.getPropertyName(), "layersVisible")) {
            this.refreshToolBar();
            this.updateSystemMenu();
        }
    }

    @Override
    public void pluginLoaderChanged(PluginLoader.PluginLoaderEvent e) {
        ThreadUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                Viewer.this.buildCanvasCombo();
                Viewer.this.refreshCanvasCombo();
                Viewer.this.updateToolbarComponents();
            }
        });
    }

    private class ViewerMainPanel
    extends JPanel {
        public void drawTextCenter(Graphics2D g, String text, float alpha) {
            Rectangle2D rect = GraphicsUtil.getStringBounds(g, text);
            int w = (int)rect.getWidth();
            int h = (int)rect.getHeight();
            int x = (this.getWidth() - (w + 8 + 2)) / 2;
            int y = (this.getHeight() - (h + 8 + 2)) / 2;
            g.setColor(Color.gray);
            g.setComposite(AlphaComposite.getInstance(3, alpha));
            g.fillRoundRect(x, y, w + 8, h + 8, 8, 8);
            g.setColor(Color.white);
            g.drawString(text, x + 4, y + 2 + h);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (Viewer.this.settingCanvas) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setFont(new Font("Arial", 1, 16));
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.drawTextCenter(g2, "Loading canvas...", 0.8f);
                g2.dispose();
            }
        }
    }
}

