/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.descriptor.logical;

import icy.roi.ROI;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;

public class ROIIntersectedDescriptor
extends ROIDescriptor {
    public static final String ID = "Intersected";

    public ROIIntersectedDescriptor() {
        super(ID, ID, Double.class);
    }

    @Override
    public String getDescription() {
        return "Number of intersected ROI(s)";
    }

    @Override
    public boolean separateChannel() {
        return false;
    }

    @Override
    public boolean needRecompute(SequenceEvent change) {
        return change.getSourceType() == SequenceEvent.SequenceEventSourceType.SEQUENCE_ROI;
    }

    @Override
    public Object compute(ROI roi, Sequence sequence) throws InterruptedException {
        return ROIIntersectedDescriptor.computeIntersectedROIs(roi, sequence);
    }

    public static double computeIntersectedROIs(ROI roi, Sequence sequence) throws InterruptedException {
        if (roi == null || sequence == null) {
            return 0.0;
        }
        int result = 0;
        for (ROI r : sequence.getROIs()) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            if (r == roi || r == null || !roi.intersects(r)) continue;
            ++result;
        }
        return result;
    }
}

