/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.thresholder;

import icy.sequence.Sequence;
import icy.type.collection.array.Array1DUtil;
import java.util.Arrays;

public class KMeans {
    public static final int DEFAULT_KMEANS_BINS = 255;

    public static double[][] computeKMeansThresholds(Sequence input, int nbClasses) {
        return KMeans.computeKMeansThresholds(input, nbClasses, 255);
    }

    public static double[][] computeKMeansThresholds(Sequence input, int nbClasses, int binPrecision) {
        double[][] thrs = new double[input.getSizeC()][];
        for (int c = 0; c < input.getSizeC(); ++c) {
            thrs[c] = KMeans.computeKMeansThresholds(input, c, nbClasses, binPrecision);
        }
        return thrs;
    }

    public static double[] computeKMeansThresholds(Sequence input, int c, int nbClasses, int binPrecision) {
        double[] thresholds = new double[nbClasses - 1];
        input.loadAllData();
        input.updateChannelsBounds(true);
        double[] minmax = input.getChannelBounds(c);
        double min = minmax[0];
        double max = minmax[1];
        double fact = (double)(binPrecision - 1) / (max - min);
        double[] histo = new double[binPrecision];
        double[] sliceXY = new double[input.getSizeX() * input.getSizeY()];
        for (int t = 0; t < input.getSizeT(); ++t) {
            for (int z = 0; z < input.getSizeZ(); ++z) {
                Array1DUtil.arrayToDoubleArray((Object)input.getDataXY(t, z, c), (double[])sliceXY, (boolean)input.isSignedDataType());
                for (double d : sliceXY) {
                    int n = (int)((d - min) * fact);
                    histo[n] = histo[n] + 1.0;
                }
            }
        }
        int[] centers = KMeans.kMeans_Histogram1D(histo, nbClasses);
        Arrays.sort(centers);
        for (int k = 1; k < nbClasses; ++k) {
            thresholds[k - 1] = min + ((double)centers[k - 1] + (double)(centers[k] - centers[k - 1]) / 2.0) / fact;
        }
        return thresholds;
    }

    public static double[] computeKMeansThresholds(Sequence input, int c, int t, int nbClasses, int binPrecision) {
        double[] thresholds = new double[nbClasses - 1];
        input.getImage(t, 0).loadData();
        double min = input.getImage(t, 0).getChannelMin(c);
        double max = input.getImage(t, 0).getChannelMax(c);
        for (int z = 1; z < input.getSizeZ(); ++z) {
            double[] sliceBounds = input.getImage(t, z).getChannelBounds(c);
            if (sliceBounds[0] < min) {
                min = sliceBounds[0];
            }
            if (!(sliceBounds[1] > max)) continue;
            max = sliceBounds[1];
        }
        double fact = (double)(binPrecision - 1) / (max - min);
        double[] histo = new double[binPrecision];
        double[] sliceXY = new double[input.getSizeX() * input.getSizeY()];
        for (int z = 0; z < input.getSizeZ(); ++z) {
            Array1DUtil.arrayToDoubleArray((Object)input.getDataXY(t, z, c), (double[])sliceXY, (boolean)input.isSignedDataType());
            for (double d : sliceXY) {
                int n = (int)((d - min) * fact);
                histo[n] = histo[n] + 1.0;
            }
        }
        int[] centers = KMeans.kMeans_Histogram1D(histo, nbClasses);
        Arrays.sort(centers);
        for (int k = 1; k < nbClasses; ++k) {
            thresholds[k - 1] = min + ((double)centers[k - 1] + (double)(centers[k] - centers[k - 1]) / 2.0) / fact;
        }
        return thresholds;
    }

    public static double[][] computeKMeansThresholds(Sequence inSeq, int c, boolean timeDependent, short nbClasses, int nbBins) {
        double[][] thrs = new double[inSeq.getSizeT()][];
        if (timeDependent) {
            for (int t = 0; t < thrs.length; ++t) {
                thrs[t] = KMeans.computeKMeansThresholds(inSeq, c, t, (int)nbClasses, nbBins);
            }
        } else {
            double[] thr = KMeans.computeKMeansThresholds(inSeq, c, nbClasses, nbBins);
            for (int i = 0; i < thrs.length; ++i) {
                thrs[i] = thr;
            }
        }
        return thrs;
    }

    public static int[] kMeans_Histogram1D(double[] histogram, int nbClasses) {
        int[] centers = new int[nbClasses];
        double[] sums = new double[nbClasses];
        double[] nbElements = new double[nbClasses];
        for (int i = 0; i < nbClasses; ++i) {
            centers[i] = (int)(((float)histogram.length - 1.0f) * ((float)i + 1.0f) / ((float)nbClasses + 1.0f));
        }
        boolean convergence = false;
        while (!convergence) {
            convergence = true;
            Arrays.fill(nbElements, 0.0);
            Arrays.fill(sums, 0.0);
            for (int i = 0; i < histogram.length; ++i) {
                int closestClass = 0;
                double minDistance = Double.MAX_VALUE;
                for (int k = 0; k < nbClasses; ++k) {
                    double distance = Math.abs(i - centers[k]);
                    if (!(distance < minDistance)) continue;
                    minDistance = distance;
                    closestClass = k;
                }
                double nbElemInCurrentBin = histogram[i];
                int n = closestClass;
                sums[n] = sums[n] + (double)i * nbElemInCurrentBin;
                int n2 = closestClass;
                nbElements[n2] = nbElements[n2] + nbElemInCurrentBin;
            }
            for (int k = 0; k < nbClasses; ++k) {
                int oldCenter = centers[k];
                int newCenter = (int)(sums[k] / nbElements[k]);
                convergence &= oldCenter == newCenter;
                centers[k] = newCenter;
            }
        }
        return centers;
    }
}

