/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.legacytracker.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.DecimalFormat;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FilterCovariancesPanel
extends JPanel {
    private static final long serialVersionUID = -6540605877193830658L;
    private DecimalFormat f1 = new DecimalFormat("000");
    private double[] trackCov = new double[]{3.0, 3.0, 1.0, 150.0, 150.0};
    private JSlider xSens = new JSlider(0, 0, 60, (int)Math.round(this.trackCov[0]));
    private JSlider ySens = new JSlider(0, 0, 60, (int)Math.round(this.trackCov[1]));
    private JSlider zSens = new JSlider(0, 0, 60, (int)Math.round(this.trackCov[2]));
    private JLabel xLab = new JLabel();
    private JLabel yLab = new JLabel();
    private JLabel zLab = new JLabel();
    private JLabel aLab = new JLabel();
    private JLabel iLab = new JLabel();
    private JCheckBox icheckB = new JCheckBox("Intensity");
    private JCheckBox acheckB = new JCheckBox("Area");

    public void setDefaultValues() {
        this.xSens.setValue((int)Math.round(this.trackCov[0]));
        this.ySens.setValue((int)Math.round(this.trackCov[1]));
        this.zSens.setValue((int)Math.round(this.trackCov[2]));
        this.xLab.setText(this.f1.format(new Double(this.trackCov[0])));
        this.yLab.setText(this.f1.format(new Double(this.trackCov[1])));
        this.zLab.setText(this.f1.format(new Double(this.trackCov[2])));
        this.aLab.setText(this.f1.format(new Double(this.trackCov[3])));
        this.iLab.setText(this.f1.format(new Double(this.trackCov[4])));
        this.acheckB.setSelected(false);
        this.icheckB.setSelected(false);
    }

    public FilterCovariancesPanel() {
        GridBagLayout mainLayout = new GridBagLayout();
        this.setLayout(mainLayout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        this.xSens.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                FilterCovariancesPanel.this.xLab.setText(FilterCovariancesPanel.this.f1.format(FilterCovariancesPanel.this.xSens.getValue()));
            }
        });
        this.ySens.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                FilterCovariancesPanel.this.yLab.setText(FilterCovariancesPanel.this.f1.format(FilterCovariancesPanel.this.ySens.getValue()));
            }
        });
        this.zSens.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                FilterCovariancesPanel.this.zLab.setText(FilterCovariancesPanel.this.f1.format(FilterCovariancesPanel.this.zSens.getValue()));
            }
        });
        JPanel jpx = new JPanel();
        jpx.setLayout(new BoxLayout(jpx, 0));
        jpx.add(new JLabel("x"));
        jpx.add(this.xSens);
        jpx.add(this.xLab);
        JPanel jpy = new JPanel();
        jpy.setLayout(new BoxLayout(jpy, 0));
        jpy.add(new JLabel("y"));
        jpy.add(this.ySens);
        jpy.add(this.yLab);
        JPanel jpz = new JPanel();
        jpz.setLayout(new BoxLayout(jpz, 0));
        jpz.add(new JLabel("z"));
        jpz.add(this.zSens);
        jpz.add(this.zLab);
        this.add((Component)jpx, constraints);
        ++constraints.gridy;
        this.add((Component)jpy, constraints);
        ++constraints.gridy;
        this.add((Component)jpz, constraints);
        ++constraints.gridy;
    }

    public boolean isAreaSelected() {
        return this.acheckB.isSelected();
    }

    public boolean isIntensitySelected() {
        return this.icheckB.isSelected();
    }

    public double getTrackingCovX() {
        return this.xSens.getValue();
    }

    public double getTrackingCovY() {
        return this.ySens.getValue();
    }

    public double getTrackingCovZ() {
        return this.zSens.getValue();
    }
}

