/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums;

import ome.units.quantity.Frequency;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.handlers.UnitsFrequencyEnumHandler;
import ome.xml.model.primitives.PrimitiveNumber;

public enum UnitsFrequency implements Enumeration
{
    YOTTAHERTZ("YHz"),
    ZETTAHERTZ("ZHz"),
    EXAHERTZ("EHz"),
    PETAHERTZ("PHz"),
    TERAHERTZ("THz"),
    GIGAHERTZ("GHz"),
    MEGAHERTZ("MHz"),
    KILOHERTZ("kHz"),
    HECTOHERTZ("hHz"),
    DECAHERTZ("daHz"),
    HERTZ("Hz"),
    DECIHERTZ("dHz"),
    CENTIHERTZ("cHz"),
    MILLIHERTZ("mHz"),
    MICROHERTZ("\u00b5Hz"),
    NANOHERTZ("nHz"),
    PICOHERTZ("pHz"),
    FEMTOHERTZ("fHz"),
    ATTOHERTZ("aHz"),
    ZEPTOHERTZ("zHz"),
    YOCTOHERTZ("yHz");

    private final String value;

    private UnitsFrequency(String value) {
        this.value = value;
    }

    public static UnitsFrequency fromString(String value) throws EnumerationException {
        if ("YHz".equals(value)) {
            return YOTTAHERTZ;
        }
        if ("ZHz".equals(value)) {
            return ZETTAHERTZ;
        }
        if ("EHz".equals(value)) {
            return EXAHERTZ;
        }
        if ("PHz".equals(value)) {
            return PETAHERTZ;
        }
        if ("THz".equals(value)) {
            return TERAHERTZ;
        }
        if ("GHz".equals(value)) {
            return GIGAHERTZ;
        }
        if ("MHz".equals(value)) {
            return MEGAHERTZ;
        }
        if ("kHz".equals(value)) {
            return KILOHERTZ;
        }
        if ("hHz".equals(value)) {
            return HECTOHERTZ;
        }
        if ("daHz".equals(value)) {
            return DECAHERTZ;
        }
        if ("Hz".equals(value)) {
            return HERTZ;
        }
        if ("dHz".equals(value)) {
            return DECIHERTZ;
        }
        if ("cHz".equals(value)) {
            return CENTIHERTZ;
        }
        if ("mHz".equals(value)) {
            return MILLIHERTZ;
        }
        if ("\u00b5Hz".equals(value)) {
            return MICROHERTZ;
        }
        if ("nHz".equals(value)) {
            return NANOHERTZ;
        }
        if ("pHz".equals(value)) {
            return PICOHERTZ;
        }
        if ("fHz".equals(value)) {
            return FEMTOHERTZ;
        }
        if ("aHz".equals(value)) {
            return ATTOHERTZ;
        }
        if ("zHz".equals(value)) {
            return ZEPTOHERTZ;
        }
        if ("yHz".equals(value)) {
            return YOCTOHERTZ;
        }
        String s2 = String.format("'%s' not a supported value of '%s'", value, UnitsFrequency.class);
        throw new EnumerationException(s2);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public static <T extends PrimitiveNumber> Frequency create(T newValue, UnitsFrequency newUnit) {
        Frequency theQuantity = null;
        try {
            theQuantity = UnitsFrequencyEnumHandler.getQuantity(newValue, newUnit);
            return theQuantity;
        }
        finally {
            return theQuantity;
        }
    }

    public static <T extends Number> Frequency create(T newValue, UnitsFrequency newUnit) {
        Frequency theQuantity = null;
        try {
            theQuantity = UnitsFrequencyEnumHandler.getQuantity(newValue, newUnit);
            return theQuantity;
        }
        finally {
            return theQuantity;
        }
    }
}

