/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations;

import icy.system.IcyHandledException;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.vars.gui.model.VarEditorModel;
import plugins.adufour.vars.lang.Var;
import plugins.ylemontag.mathoperations.Functor;
import plugins.ylemontag.mathoperations.MathOperationAbstractPlugin;
import plugins.ylemontag.mathoperations.Operation;
import plugins.ylemontag.mathoperations.VarOperation;
import plugins.ylemontag.mathoperations.operations.Operation1;
import plugins.ylemontag.mathoperations.operations.Operation2;

public class MathOperationPlugin
extends MathOperationAbstractPlugin {
    private EzVar<Operation> _operation = new EzVarOperation("Operation", Operation2.ADD);
    private MathOperationAbstractPlugin.EzGroupVariant _group0 = new MathOperationAbstractPlugin.EzGroupVariant("Input");
    private MathOperationAbstractPlugin.EzGroupVariant _group1 = new MathOperationAbstractPlugin.EzGroupVariant("Input 1");
    private MathOperationAbstractPlugin.EzGroupVariant _group2 = new MathOperationAbstractPlugin.EzGroupVariant("Input 2");

    private void refreshVisibility() {
        boolean unaryOp = this._operation.getValue() instanceof Operation1;
        boolean binaryOp = this._operation.getValue() instanceof Operation2;
        this._group0.setVisible(unaryOp);
        this._group1.setVisible(binaryOp);
        this._group2.setVisible(binaryOp);
    }

    protected void initialize() {
        this.addEzComponent((EzComponent)this._operation);
        this.addEzComponent((EzComponent)this._group0);
        this.addEzComponent((EzComponent)this._group1);
        this.addEzComponent((EzComponent)this._group2);
        this._operation.addVarChangeListener((EzVarListener)new EzVarListener<Operation>(){

            public void variableChanged(EzVar<Operation> source, Operation newValue) {
                MathOperationPlugin.this.refreshVisibility();
            }
        });
        this.refreshVisibility();
    }

    protected void execute() {
        Operation op = (Operation)this._operation.getValue();
        Functor fun = op.getRawFunctor();
        if (op instanceof Operation2) {
            this.coreExecute(fun, this._group1, this._group2);
        } else if (op instanceof Operation1) {
            this.coreExecute(fun, this._group0);
        } else {
            throw new IcyHandledException("No operation selected");
        }
    }

    private static class EzVarOperation
    extends EzVar<Operation> {
        public EzVarOperation(String name, Operation defaultValue) {
            super((Var)new VarOperation(name, defaultValue), (VarEditorModel)new VarEditorModel<Operation>(){

                public boolean isValid(Operation value) {
                    return true;
                }

                public Operation getDefaultValue() {
                    return Operation2.ADD;
                }
            });
        }
    }
}

