/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Short1D;
import mitiv.array.Short2D;
import mitiv.array.impl.FlatShort1D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedShort2D;
import mitiv.array.impl.StriddenShort1D;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ShortFunction;
import mitiv.base.mapping.ShortScanner;
import mitiv.random.ShortGenerator;

public class StriddenShort2D
extends Short2D {
    final int order;
    final short[] data;
    final int offset;
    final int stride1;
    final int stride2;
    final boolean flat;

    public StriddenShort2D(short[] arr, int offset, int[] stride, int[] dims) {
        super(dims);
        if (stride.length != 2) {
            throw new IllegalArgumentException("There must be as many strides as the rank");
        }
        this.data = arr;
        this.offset = offset;
        this.stride1 = stride[0];
        this.stride2 = stride[1];
        this.order = Short2D.checkViewStrides(this.data.length, offset, this.stride1, this.stride2, this.dim1, this.dim2);
        this.flat = offset == 0 && this.stride1 == 1 && this.stride2 == this.dim1;
    }

    public StriddenShort2D(short[] arr, int offset, int stride1, int stride2, int dim1, int dim2) {
        super(dim1, dim2);
        this.data = arr;
        this.offset = offset;
        this.stride1 = stride1;
        this.stride2 = stride2;
        this.order = Short2D.checkViewStrides(this.data.length, offset, stride1, stride2, dim1, dim2);
        this.flat = offset == 0 && stride1 == 1 && stride2 == dim1;
    }

    @Override
    public void checkSanity() {
        Short2D.checkViewStrides(this.data.length, this.offset, this.stride1, this.stride2, this.dim1, this.dim2);
    }

    final int index(int i1, int i2) {
        return this.offset + this.stride2 * i2 + this.stride1 * i1;
    }

    @Override
    public final short get(int i1, int i2) {
        return this.data[this.offset + this.stride2 * i2 + this.stride1 * i1];
    }

    @Override
    public final void set(int i1, int i2, short value) {
        this.data[this.offset + this.stride2 * i2 + this.stride1 * i1] = value;
    }

    @Override
    public final int getOrder() {
        return this.order;
    }

    @Override
    public void fill(short value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                int j1 = this.stride1 * i1 + this.offset;
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    int j2 = this.stride2 * i2 + j1;
                    this.data[j2] = value;
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                int j2 = this.stride2 * i2 + this.offset;
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    int j1 = this.stride1 * i1 + j2;
                    this.data[j1] = value;
                }
            }
        }
    }

    @Override
    public void fill(ShortGenerator generator) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                int j1 = this.stride1 * i1 + this.offset;
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    int j2 = this.stride2 * i2 + j1;
                    this.data[j2] = generator.nextShort();
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                int j2 = this.stride2 * i2 + this.offset;
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    int j1 = this.stride1 * i1 + j2;
                    this.data[j1] = generator.nextShort();
                }
            }
        }
    }

    @Override
    public void increment(short value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                int j1 = this.stride1 * i1 + this.offset;
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    int j2;
                    int n = j2 = this.stride2 * i2 + j1;
                    this.data[n] = (short)(this.data[n] + value);
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                int j2 = this.stride2 * i2 + this.offset;
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    int j1;
                    int n = j1 = this.stride1 * i1 + j2;
                    this.data[n] = (short)(this.data[n] + value);
                }
            }
        }
    }

    @Override
    public void decrement(short value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                int j1 = this.stride1 * i1 + this.offset;
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    int j2;
                    int n = j2 = this.stride2 * i2 + j1;
                    this.data[n] = (short)(this.data[n] - value);
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                int j2 = this.stride2 * i2 + this.offset;
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    int j1;
                    int n = j1 = this.stride1 * i1 + j2;
                    this.data[n] = (short)(this.data[n] - value);
                }
            }
        }
    }

    @Override
    public void scale(short value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                int j1 = this.stride1 * i1 + this.offset;
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    int j2;
                    int n = j2 = this.stride2 * i2 + j1;
                    this.data[n] = (short)(this.data[n] * value);
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                int j2 = this.stride2 * i2 + this.offset;
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    int j1;
                    int n = j1 = this.stride1 * i1 + j2;
                    this.data[n] = (short)(this.data[n] * value);
                }
            }
        }
    }

    @Override
    public void map(ShortFunction function) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                int j1 = this.stride1 * i1 + this.offset;
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    int j2 = this.stride2 * i2 + j1;
                    this.data[j2] = function.apply(this.data[j2]);
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                int j2 = this.stride2 * i2 + this.offset;
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    int j1 = this.stride1 * i1 + j2;
                    this.data[j1] = function.apply(this.data[j1]);
                }
            }
        }
    }

    @Override
    public void scan(ShortScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                int j1 = this.stride1 * i1 + this.offset;
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    int j2 = this.stride2 * i2 + j1;
                    if (initialized) {
                        scanner.update(this.data[j2]);
                        continue;
                    }
                    scanner.initialize(this.data[j2]);
                    initialized = true;
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                int j2 = this.stride2 * i2 + this.offset;
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    int j1 = this.stride1 * i1 + j2;
                    if (initialized) {
                        scanner.update(this.data[j1]);
                        continue;
                    }
                    scanner.initialize(this.data[j1]);
                    initialized = true;
                }
            }
        }
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public short[] flatten(boolean forceCopy) {
        if (!forceCopy && this.flat) {
            return this.data;
        }
        short[] out = new short[this.number];
        if (this.flat) {
            System.arraycopy(this.data, 0, out, 0, this.number);
        } else {
            int j = -1;
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                int j2 = this.stride2 * i2 + this.offset;
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    int j1 = this.stride1 * i1 + j2;
                    out[++j] = this.data[j1];
                }
            }
        }
        return out;
    }

    @Override
    public short[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public Short1D slice(int idx) {
        return new StriddenShort1D(this.data, this.offset + this.stride2 * idx, this.stride1, this.dim1);
    }

    @Override
    public Short1D slice(int idx, int dim) {
        int sliceDim1;
        int sliceStride1;
        int sliceOffset;
        if (dim < 0) {
            dim += 2;
        }
        if (dim == 0) {
            sliceOffset = this.offset + this.stride1 * idx;
            sliceStride1 = this.stride2;
            sliceDim1 = this.dim2;
        } else if (dim == 1) {
            sliceOffset = this.offset + this.stride2 * idx;
            sliceStride1 = this.stride1;
            sliceDim1 = this.dim1;
        } else {
            throw new IndexOutOfBoundsException("Dimension index out of bounds");
        }
        return new StriddenShort1D(this.data, sliceOffset, sliceStride1, sliceDim1);
    }

    @Override
    public Short2D view(Range rng1, Range rng2) {
        CompiledRange cr1 = new CompiledRange(rng1, this.dim1, this.offset, this.stride1);
        CompiledRange cr2 = new CompiledRange(rng2, this.dim2, 0, this.stride2);
        if (cr1.doesNothing() && cr2.doesNothing()) {
            return this;
        }
        return new StriddenShort2D(this.data, cr1.getOffset() + cr2.getOffset(), cr1.getStride(), cr2.getStride(), cr1.getNumber(), cr2.getNumber());
    }

    @Override
    public Short2D view(int[] sel1, int[] sel2) {
        int[] idx1 = Helper.select(this.offset, this.stride1, this.dim1, sel1);
        int[] idx2 = Helper.select(0, this.stride2, this.dim2, sel2);
        return new SelectedShort2D(this.data, idx1, idx2);
    }

    @Override
    public Short1D as1D() {
        return new FlatShort1D(this.flatten(), this.number);
    }
}

