/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.optim.LineSearch;
import mitiv.optim.LineSearchTask;
import mitiv.optim.OptimStatus;

public class MoreThuenteLineSearch
extends LineSearch {
    private double ftol = 0.0;
    private double gtol = 0.0;
    private double xtol = 0.0;
    private double gtest = 0.0;
    double stx;
    double fx;
    double gx;
    double sty;
    double fy;
    double gy;
    private double stmin = 0.0;
    private double stmax = 0.0;
    private double width = 0.0;
    private double width1 = 0.0;
    private boolean brackt = false;
    private double[] ws = new double[9];
    private int stage = 0;

    public MoreThuenteLineSearch(double ftol, double gtol, double xtol) {
        this.ftol = Math.max(ftol, 0.0);
        this.gtol = Math.max(gtol, 0.0);
        this.xtol = Math.max(xtol, 0.0);
    }

    @Override
    public boolean useDerivative() {
        return true;
    }

    @Override
    protected void startHook() {
        this.gtest = this.ftol * this.ginit;
        this.stmin = this.stpmin;
        this.stmax = this.stpmax;
        this.width = this.stpmax - this.stpmin;
        this.width1 = 2.0 * this.width;
        this.brackt = false;
        this.stx = 0.0;
        this.fx = this.finit;
        this.gx = this.ginit;
        this.sty = 0.0;
        this.fy = this.finit;
        this.gy = this.ginit;
        this.stage = 1;
        this.success(LineSearchTask.SEARCH);
    }

    @Override
    protected void iterateHook(double f, double g) {
        OptimStatus result;
        double ftest = this.finit + this.stp * this.gtest;
        if (f <= ftest && Math.abs(g) <= -this.gtol * this.ginit) {
            this.success(LineSearchTask.CONVERGENCE);
            return;
        }
        if (this.stp == this.stpmin && (f > ftest || g >= this.gtest)) {
            this.failure(OptimStatus.STEP_EQ_STPMIN);
            return;
        }
        if (this.stp == this.stpmax && f <= ftest && g <= this.gtest) {
            this.warning(OptimStatus.STEP_EQ_STPMAX);
            return;
        }
        if (this.brackt && this.stmax - this.stmin <= this.xtol * this.stmax) {
            this.warning(OptimStatus.XTOL_TEST_SATISFIED);
            return;
        }
        if (this.brackt && (this.stp <= this.stmin || this.stp >= this.stmax)) {
            this.warning(OptimStatus.ROUNDING_ERRORS_PREVENT_PROGRESS);
            return;
        }
        if (this.stage == 1 && f <= ftest && g >= 0.0) {
            this.stage = 2;
        }
        if (this.stage == 1 && f <= this.fx && f > ftest) {
            this.ws[0] = this.stx;
            this.ws[1] = this.fx - this.gtest * this.stx;
            this.ws[2] = this.gx - this.gtest;
            this.ws[3] = this.sty;
            this.ws[4] = this.fy - this.gtest * this.sty;
            this.ws[5] = this.gy - this.gtest;
            this.ws[6] = this.stp;
            this.ws[7] = f - this.gtest * this.stp;
            this.ws[8] = g - this.gtest;
            result = this.cstep();
            if (result != OptimStatus.SUCCESS) {
                this.failure(result);
                return;
            }
            this.stx = this.ws[0];
            this.fx = this.ws[1] + this.gtest * this.stx;
            this.gx = this.ws[2] + this.gtest;
            this.sty = this.ws[3];
            this.fy = this.ws[4] + this.gtest * this.sty;
            this.gy = this.ws[5] + this.gtest;
            this.stp = this.ws[6];
        } else {
            this.ws[0] = this.stx;
            this.ws[1] = this.fx;
            this.ws[2] = this.gx;
            this.ws[3] = this.sty;
            this.ws[4] = this.fy;
            this.ws[5] = this.gy;
            this.ws[6] = this.stp;
            this.ws[7] = f;
            this.ws[8] = g;
            result = this.cstep();
            if (result != OptimStatus.SUCCESS) {
                this.failure(result);
                return;
            }
            this.stx = this.ws[0];
            this.fx = this.ws[1];
            this.gx = this.ws[2];
            this.sty = this.ws[3];
            this.fy = this.ws[4];
            this.gy = this.ws[5];
            this.stp = this.ws[6];
        }
        if (this.brackt) {
            double new_width = Math.abs(this.sty - this.stx);
            if (new_width >= 0.66 * this.width1) {
                this.stp = this.stx + 0.5 * (this.sty - this.stx);
            }
            this.width1 = this.width;
            this.width = new_width;
        }
        if (this.brackt) {
            this.stmin = Math.min(this.stx, this.sty);
            this.stmax = Math.max(this.stx, this.sty);
        } else {
            this.stmin = this.stp + (this.stp - this.stx) * 1.1;
            this.stmax = this.stp + (this.stp - this.stx) * 4.0;
        }
        this.stp = Math.max(this.stp, this.stpmin);
        this.stp = Math.min(this.stp, this.stpmax);
        if (this.brackt && (this.stp <= this.stmin || this.stp >= this.stmax || this.stmax - this.stmin <= this.xtol * this.stmax)) {
            this.stp = this.stx;
        }
        this.success(LineSearchTask.SEARCH);
    }

    private static final double max(double val1, double val2, double val3) {
        return Math.max(Math.max(val1, val2), val3);
    }

    private final OptimStatus cstep() {
        double stpf;
        boolean opposite;
        double ZERO = 0.0;
        double TWO = 2.0;
        double THREE = 3.0;
        double stx = this.ws[0];
        double fx = this.ws[1];
        double dx = this.ws[2];
        double sty = this.ws[3];
        double fy = this.ws[4];
        double dy = this.ws[5];
        double stp = this.ws[6];
        double fp = this.ws[7];
        double dp = this.ws[8];
        if (this.brackt && (stx < sty ? stp <= stx || stp >= sty : stp <= sty || stp >= stx)) {
            return OptimStatus.STEP_OUTSIDE_BRACKET;
        }
        if (dx * (stp - stx) >= 0.0) {
            return OptimStatus.NOT_A_DESCENT;
        }
        if (this.stpmin > this.stpmax) {
            return OptimStatus.STPMIN_GT_STPMAX;
        }
        boolean bl = opposite = dp < 0.0 && dx > 0.0 || dp > 0.0 && dx < 0.0;
        if (fp > fx) {
            this.brackt = true;
            double theta = 3.0 * (fx - fp) / (stp - stx) + dx + dp;
            double s = MoreThuenteLineSearch.max(Math.abs(theta), Math.abs(dx), Math.abs(dp));
            double temp = theta / s;
            double gamma = s * Math.sqrt(temp * temp - dx / s * (dp / s));
            if (stp < stx) {
                gamma = -gamma;
            }
            double p = gamma - dx + theta;
            double q = gamma - dx + gamma + dp;
            double r = p / q;
            double stpc = stx + r * (stp - stx);
            double stpq = stx + dx / ((fx - fp) / (stp - stx) + dx) / 2.0 * (stp - stx);
            stpf = Math.abs(stpc - stx) < Math.abs(stpq - stx) ? stpc : stpc + (stpq - stpc) / 2.0;
        } else if (opposite) {
            this.brackt = true;
            double theta = 3.0 * (fx - fp) / (stp - stx) + dx + dp;
            double s = MoreThuenteLineSearch.max(Math.abs(theta), Math.abs(dx), Math.abs(dp));
            double temp = theta / s;
            double gamma = s * Math.sqrt(temp * temp - dx / s * (dp / s));
            if (stp > stx) {
                gamma = -gamma;
            }
            double p = gamma - dp + theta;
            double q = gamma - dp + gamma + dx;
            double r = p / q;
            double stpc = stp + r * (stx - stp);
            double stpq = stp + dp / (dp - dx) * (stx - stp);
            stpf = Math.abs(stpc - stp) > Math.abs(stpq - stp) ? stpc : stpq;
        } else if (Math.abs(dp) < Math.abs(dx)) {
            double q;
            double p;
            double r;
            double gamma;
            double theta = 3.0 * (fx - fp) / (stp - stx) + dx + dp;
            double s = MoreThuenteLineSearch.max(Math.abs(theta), Math.abs(dx), Math.abs(dp));
            double temp = theta / s;
            if ((temp = temp * temp - dx / s * (dp / s)) > 0.0) {
                gamma = s * Math.sqrt(temp);
                if (stp > stx) {
                    gamma = -gamma;
                }
            } else {
                gamma = 0.0;
            }
            double stpc = (r = (p = gamma - dp + theta) / (q = gamma + (dx - dp) + gamma)) < 0.0 && gamma != 0.0 ? stp + r * (stx - stp) : (stp > stx ? this.stpmax : this.stpmin);
            double stpq = stp + dp / (dp - dx) * (stx - stp);
            if (this.brackt) {
                stpf = Math.abs(stpc - stp) < Math.abs(stpq - stp) ? stpc : stpq;
                temp = stp + 0.66 * (sty - stp);
                if (stp > stx ? stpf > temp : stpf < temp) {
                    stpf = temp;
                }
            } else {
                stpf = Math.abs(stpc - stp) > Math.abs(stpq - stp) ? stpc : stpq;
                if (stpf > this.stpmax) {
                    stpf = this.stpmax;
                }
                if (stpf < this.stpmin) {
                    stpf = this.stpmin;
                }
            }
        } else if (this.brackt) {
            double stpc;
            double theta = 3.0 * (fp - fy) / (sty - stp) + dy + dp;
            double s = MoreThuenteLineSearch.max(Math.abs(theta), Math.abs(dy), Math.abs(dp));
            double temp = theta / s;
            double gamma = s * Math.sqrt(temp * temp - dy / s * (dp / s));
            if (stp > sty) {
                gamma = -gamma;
            }
            double p = gamma - dp + theta;
            double q = gamma - dp + gamma + dy;
            double r = p / q;
            stpf = stpc = stp + r * (sty - stp);
        } else {
            stpf = stp > stx ? this.stpmax : this.stpmin;
        }
        if (fp > fx) {
            sty = stp;
            fy = fp;
            dy = dp;
        } else {
            if (opposite) {
                sty = stx;
                fy = fx;
                dy = dx;
            }
            stx = stp;
            fx = fp;
            dx = dp;
        }
        this.ws[0] = stx;
        this.ws[1] = fx;
        this.ws[2] = dx;
        this.ws[3] = sty;
        this.ws[4] = fy;
        this.ws[5] = dy;
        this.ws[6] = stpf;
        return OptimStatus.SUCCESS;
    }
}

