/*
 * Decompiled with CFR 0.152.
 */
package plugins.stef.roi.bloc.property;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.roi.ROI;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import icy.system.IcyExceptionHandler;
import icy.util.StringUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import plugins.adufour.blocks.tools.roi.ROIBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.gui.model.ValueSelectionModel;
import plugins.adufour.vars.gui.model.VarEditorModel;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarMutable;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.lang.VarString;
import plugins.adufour.vars.util.VarException;
import plugins.stef.roi.bloc.RoiBlocks;

public class GetROIDescriptorValue
extends Plugin
implements ROIBlock,
PluginLibrary,
PluginBundled {
    protected final VarROIArray rois = new VarROIArray("ROI", null);
    protected final VarSequence sequence = new VarSequence("Sequence", null);
    protected final VarString descriptors = new VarString("Value of", "");
    protected final VarMutable value = new VarMutable("Value", Double.class);

    public void run() {
        Sequence seq = (Sequence)this.sequence.getValue();
        String descriptorId = (String)this.descriptors.getValue();
        ROIDescriptor roiDescriptor = ROIDescriptor.getDescriptor(ROIDescriptor.getDescriptors().keySet(), (String)descriptorId);
        if (roiDescriptor == null) {
            throw new VarException((Var)this.descriptors, "Cannot found '" + descriptorId + "' ROI descriptor !");
        }
        for (ROI roi : (ROI[])this.rois.getValue()) {
            if (roi == null) continue;
            try {
                Object res = roiDescriptor.compute(roi, seq);
                if (res instanceof Number) {
                    this.value.setType(Double.class);
                    this.value.setValue((Object)((Number)res).doubleValue());
                    break;
                }
                if (res instanceof Color) {
                    Color color = (Color)res;
                    String resString = StringUtil.toHexaString((int)color.getAlpha(), (int)2) + StringUtil.toHexaString((int)color.getRed(), (int)2) + StringUtil.toHexaString((int)color.getGreen(), (int)2) + StringUtil.toHexaString((int)color.getBlue(), (int)2);
                    this.value.setType(String.class);
                    this.value.setValue((Object)resString.toUpperCase());
                    break;
                }
                if (res instanceof String) {
                    this.value.setType(String.class);
                    this.value.setValue(res);
                    break;
                }
                if (res != null) {
                    this.value.setType(String.class);
                    this.value.setValue((Object)res.toString());
                    break;
                }
                this.value.setType(String.class);
                this.value.setValue((Object)"");
            }
            catch (Exception e) {
                IcyExceptionHandler.showErrorMessage((Throwable)e, (boolean)false, (boolean)true);
                this.value.setType(String.class);
                this.value.setValue((Object)"");
            }
            break;
        }
    }

    public void declareInput(VarList inputMap) {
        ArrayList roiDescriptors = new ArrayList(ROIDescriptor.getDescriptors().keySet());
        ArrayList<String> descriptorsId = new ArrayList<String>();
        String sizeDescriptorId = null;
        for (ROIDescriptor descriptor : roiDescriptors) {
            String id = descriptor.getId();
            if (StringUtil.equals((String)"Interior", (String)id)) {
                sizeDescriptorId = id;
            }
            descriptorsId.add(id);
        }
        Collections.sort(descriptorsId);
        this.descriptors.setDefaultEditorModel((VarEditorModel)new ValueSelectionModel((Object[])descriptorsId.toArray(new String[descriptorsId.size()]), (Object)sizeDescriptorId, false));
        inputMap.add("rois", (Var)this.rois);
        inputMap.add("sequence", (Var)this.sequence);
        inputMap.add("descriptors", (Var)this.descriptors);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("value", (Var)this.value);
    }

    public String getMainPluginClassName() {
        return RoiBlocks.class.getName();
    }
}

