/*
 * Decompiled with CFR 0.152.
 */
package icy.math;

import icy.math.Scaler;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class Interpolator {
    private static double[][] pointsToXY(List<Point> points) {
        int len = points.size();
        double[][] xy = new double[2][len];
        double[] x = xy[0];
        double[] y = xy[1];
        for (int i = 0; i < len; ++i) {
            Point p = points.get(i);
            x[i] = p.x;
            y[i] = p.y;
        }
        return xy;
    }

    private static double[] prepareYInterpolation(double[] x, double[] y, double xinc) {
        if (x.length == 0 || y.length == 0) {
            throw new IllegalArgumentException("x[] and y[] should not be empty.");
        }
        if (x.length != y.length) {
            throw new IllegalArgumentException("x[] and y[] should have the same length.");
        }
        if (xinc == 0.0) {
            throw new IllegalArgumentException("step must be > 0");
        }
        return new double[(int)((x[x.length - 1] - x[0]) / xinc) + 1];
    }

    public static double[] doYLinearInterpolation(List<Point> points, double xinc) {
        double[][] xy = Interpolator.pointsToXY(points);
        return Interpolator.doYLinearInterpolation(xy[0], xy[1], xinc);
    }

    public static double[] doYLinearInterpolation(double[] x, double[] y, double xinc) {
        double[] result = Interpolator.prepareYInterpolation(x, y, xinc);
        int len = result.length;
        if (len == 1) {
            result[0] = x[0];
        } else {
            int xlen = x.length - 1;
            int index = 0;
            int offset = 0;
            double xvalue = x[0];
            double yvalue = y[0];
            double yinc = 0.0;
            while (offset < len) {
                while (index < xlen && xvalue >= x[index]) {
                    double dx;
                    if ((dx = x[++index] - xvalue) != 0.0) {
                        yinc = (y[index] - yvalue) / dx;
                        continue;
                    }
                    yinc = 0.0;
                }
                result[offset++] = yvalue;
                yvalue += yinc;
                xvalue += xinc;
            }
        }
        return result;
    }

    public static double[] doYSplineInterpolation(ArrayList<Point> points, double xstep) {
        double[][] xy = Interpolator.pointsToXY(points);
        return Interpolator.doYSplineInterpolation(xy[0], xy[1], xstep);
    }

    public static double[] doYSplineInterpolation(double[] x, double[] y, double xstep) {
        double[] result = Interpolator.prepareYInterpolation(x, y, xstep);
        int len = result.length;
        if (len > 1) {
            // empty if block
        }
        return result;
    }

    public static double[] doLinearInterpolation(double start, double end, double step) {
        int size = step == 0.0 ? 1 : (int)((end - start) / step) + 1;
        if (size < 1) {
            size = 1;
        }
        double[] result = new double[size];
        double value = start;
        for (int i = 0; i < size; ++i) {
            result[i] = value;
            value += step;
        }
        return result;
    }

    public static double[] doLinearInterpolation(double start, double end, int size) {
        if (size < 1) {
            return null;
        }
        if (size == 1) {
            double[] result = new double[size];
            result[0] = end;
            return result;
        }
        return Interpolator.doLinearInterpolation(start, end, (end - start) / (double)(size - 1));
    }

    public static double[] doLogInterpolation(double start, double end, int size) {
        double[] result = Interpolator.doLinearInterpolation(start, end, size);
        Scaler scalerIn = new Scaler(start, end, 2.0, 20.0, true, true);
        Scaler scalerOut = new Scaler(Math.log(2.0), Math.log(20.0), start, end, true, true);
        int len = result.length;
        for (int i = 0; i < len; ++i) {
            result[i] = scalerOut.scale(Math.log(scalerIn.scale(result[i])));
        }
        return result;
    }

    public static double[] doExpInterpolation(double start, double end, int size) {
        double[] result = Interpolator.doLinearInterpolation(start, end, size);
        Scaler scalerIn = new Scaler(start, end, 0.0, 2.0, false, true);
        Scaler scalerOut = new Scaler(Math.exp(0.0), Math.exp(2.0), start, end, false, true);
        int len = result.length;
        for (int i = 0; i < len; ++i) {
            result[i] = scalerOut.scale(Math.exp(scalerIn.scale(result[i])));
        }
        return result;
    }
}

