/*
 * Decompiled with CFR 0.152.
 */
package icy.image;

import icy.image.ChannelPosition;
import icy.image.ImagePosition;

public class PixelPosition
extends ChannelPosition {
    public static final char X_ID = 'X';
    public static final char Y_ID = 'Y';
    private int x;
    private int y;

    public PixelPosition(int t, int z, int c, int x, int y) {
        super(t, z, c);
        this.x = x;
        this.y = y;
    }

    public PixelPosition() {
        this(-1, -1, -1, -1, -1);
    }

    public void copyFrom(PixelPosition pp) {
        this.t = pp.t;
        this.z = pp.z;
        this.c = pp.c;
        this.y = pp.y;
        this.x = pp.x;
    }

    @Override
    public void switchLeft() {
        this.t = this.z;
        this.z = this.c;
        this.c = this.y;
        this.y = this.x;
        this.x = 0;
    }

    @Override
    public void switchRight() {
        this.x = this.y;
        this.y = this.c;
        this.c = this.z;
        this.z = this.t;
        this.t = 0;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void set(int t, int z, int c, int x, int y) {
        super.set(t, z, c);
        this.x = x;
        this.y = y;
    }

    @Override
    public int get(char ident) {
        char id = Character.toUpperCase(ident);
        switch (id) {
            case 'X': {
                return this.x;
            }
            case 'Y': {
                return this.y;
            }
        }
        return super.get(ident);
    }

    public static boolean isValidIdentStatic(char ident) {
        char id = Character.toUpperCase(ident);
        return ChannelPosition.isValidIdentStatic(ident) || id == 'X' || id == 'Y';
    }

    @Override
    public boolean isValidIdent(char ident) {
        return ChannelPosition.isValidIdentStatic(ident);
    }

    public boolean isXUndefined() {
        return this.x == -1;
    }

    public boolean isYUndefined() {
        return this.y == -1;
    }

    @Override
    public boolean isUndefined() {
        return this.isXUndefined() || this.isYUndefined() || super.isUndefined();
    }

    @Override
    public char getFirstEmptyPos() {
        char result = super.getFirstEmptyPos();
        if (result == ' ') {
            if (this.isYUndefined()) {
                return 'Y';
            }
            if (this.isXUndefined()) {
                return 'X';
            }
        }
        return result;
    }

    @Override
    public char getLastEmptyPos() {
        if (this.isXUndefined()) {
            return 'X';
        }
        if (this.isYUndefined()) {
            return 'Y';
        }
        return super.getFirstEmptyPos();
    }

    public boolean isSamePos(PixelPosition pp, char posIdent) {
        char id = Character.toUpperCase(posIdent);
        switch (id) {
            case 'X': {
                if (this.t == -1 || this.z == -1 || this.c == -1 || this.x == -1) {
                    return false;
                }
                return pp.t == this.t && pp.z == this.z && pp.c == this.c && pp.x == this.x;
            }
            case 'Y': {
                if (this.t == -1 || this.z == -1 || this.c == -1 || this.x == -1 || this.y == -1) {
                    return false;
                }
                return pp.t == this.t && pp.z == this.z && pp.c == this.c && pp.x == this.x && pp.y == this.y;
            }
        }
        return super.isSamePos(pp, posIdent);
    }

    @Override
    public int compareTo(ImagePosition o) {
        int result = super.compareTo(o);
        if (result == 0 && o instanceof PixelPosition) {
            PixelPosition pp = (PixelPosition)o;
            int ox = pp.x;
            int oy = pp.y;
            if (this.x > ox) {
                return 1;
            }
            if (this.x < ox) {
                return -1;
            }
            if (this.y > oy) {
                return 1;
            }
            if (this.y < oy) {
                return -1;
            }
        }
        return result;
    }
}

