/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.impl;

import com.adobe.xmp.XMPConst;
import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.impl.XMPMetaImpl;

class ParameterAsserts
implements XMPConst {
    private ParameterAsserts() {
    }

    public static void assertArrayName(String string) throws XMPException {
        if (string == null || string.length() == 0) {
            throw new XMPException("Empty array name", 4);
        }
    }

    public static void assertPropName(String string) throws XMPException {
        if (string == null || string.length() == 0) {
            throw new XMPException("Empty property name", 4);
        }
    }

    public static void assertSchemaNS(String string) throws XMPException {
        if (string == null || string.length() == 0) {
            throw new XMPException("Empty schema namespace URI", 4);
        }
    }

    public static void assertPrefix(String string) throws XMPException {
        if (string == null || string.length() == 0) {
            throw new XMPException("Empty prefix", 4);
        }
    }

    public static void assertSpecificLang(String string) throws XMPException {
        if (string == null || string.length() == 0) {
            throw new XMPException("Empty specific language", 4);
        }
    }

    public static void assertStructName(String string) throws XMPException {
        if (string == null || string.length() == 0) {
            throw new XMPException("Empty array name", 4);
        }
    }

    public static void assertNotNull(Object object) throws XMPException {
        if (object == null) {
            throw new XMPException("Parameter must not be null", 4);
        }
        if (object instanceof String && ((String)object).length() == 0) {
            throw new XMPException("Parameter must not be null or empty", 4);
        }
    }

    public static void assertImplementation(XMPMeta xMPMeta) throws XMPException {
        if (xMPMeta == null) {
            throw new XMPException("Parameter must not be null", 4);
        }
        if (!(xMPMeta instanceof XMPMetaImpl)) {
            throw new XMPException("The XMPMeta-object is not compatible with this implementation", 4);
        }
    }
}

