/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.impl;

import com.adobe.xmp.XMPDateTime;
import com.adobe.xmp.XMPException;
import com.adobe.xmp.impl.ISO8601Converter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class XMPDateTimeImpl
implements XMPDateTime {
    private int year = 0;
    private int month = 0;
    private int day = 0;
    private int hour = 0;
    private int minute = 0;
    private int second = 0;
    private TimeZone timeZone = null;
    private int nanoSeconds;
    private boolean hasDate = false;
    private boolean hasTime = false;
    private boolean hasTimeZone = false;

    public XMPDateTimeImpl() {
    }

    public XMPDateTimeImpl(Calendar calendar) {
        Date date = calendar.getTime();
        TimeZone timeZone = calendar.getTimeZone();
        GregorianCalendar gregorianCalendar = (GregorianCalendar)Calendar.getInstance(Locale.US);
        gregorianCalendar.setGregorianChange(new Date(Long.MIN_VALUE));
        gregorianCalendar.setTimeZone(timeZone);
        gregorianCalendar.setTime(date);
        this.year = gregorianCalendar.get(1);
        this.month = gregorianCalendar.get(2) + 1;
        this.day = gregorianCalendar.get(5);
        this.hour = gregorianCalendar.get(11);
        this.minute = gregorianCalendar.get(12);
        this.second = gregorianCalendar.get(13);
        this.nanoSeconds = gregorianCalendar.get(14) * 1000000;
        this.timeZone = gregorianCalendar.getTimeZone();
        this.hasTimeZone = true;
        this.hasTime = true;
        this.hasDate = true;
    }

    public XMPDateTimeImpl(Date date, TimeZone timeZone) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.setTime(date);
        this.year = gregorianCalendar.get(1);
        this.month = gregorianCalendar.get(2) + 1;
        this.day = gregorianCalendar.get(5);
        this.hour = gregorianCalendar.get(11);
        this.minute = gregorianCalendar.get(12);
        this.second = gregorianCalendar.get(13);
        this.nanoSeconds = gregorianCalendar.get(14) * 1000000;
        this.timeZone = timeZone;
        this.hasTimeZone = true;
        this.hasTime = true;
        this.hasDate = true;
    }

    public XMPDateTimeImpl(String string) throws XMPException {
        ISO8601Converter.parse(string, this);
    }

    @Override
    public int getYear() {
        return this.year;
    }

    @Override
    public void setYear(int n) {
        this.year = Math.min(Math.abs(n), 9999);
        this.hasDate = true;
    }

    @Override
    public int getMonth() {
        return this.month;
    }

    @Override
    public void setMonth(int n) {
        this.month = n < 1 ? 1 : (n > 12 ? 12 : n);
        this.hasDate = true;
    }

    @Override
    public int getDay() {
        return this.day;
    }

    @Override
    public void setDay(int n) {
        this.day = n < 1 ? 1 : (n > 31 ? 31 : n);
        this.hasDate = true;
    }

    @Override
    public int getHour() {
        return this.hour;
    }

    @Override
    public void setHour(int n) {
        this.hour = Math.min(Math.abs(n), 23);
        this.hasTime = true;
    }

    @Override
    public int getMinute() {
        return this.minute;
    }

    @Override
    public void setMinute(int n) {
        this.minute = Math.min(Math.abs(n), 59);
        this.hasTime = true;
    }

    @Override
    public int getSecond() {
        return this.second;
    }

    @Override
    public void setSecond(int n) {
        this.second = Math.min(Math.abs(n), 59);
        this.hasTime = true;
    }

    @Override
    public int getNanoSecond() {
        return this.nanoSeconds;
    }

    @Override
    public void setNanoSecond(int n) {
        this.nanoSeconds = n;
        this.hasTime = true;
    }

    public int compareTo(Object object) {
        long l = this.getCalendar().getTimeInMillis() - ((XMPDateTime)object).getCalendar().getTimeInMillis();
        if (l != 0L) {
            return (int)Math.signum(l);
        }
        l = this.nanoSeconds - ((XMPDateTime)object).getNanoSecond();
        return (int)Math.signum(l);
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        this.hasTime = true;
        this.hasTimeZone = true;
    }

    @Override
    public boolean hasDate() {
        return this.hasDate;
    }

    @Override
    public boolean hasTime() {
        return this.hasTime;
    }

    @Override
    public boolean hasTimeZone() {
        return this.hasTimeZone;
    }

    @Override
    public Calendar getCalendar() {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)Calendar.getInstance(Locale.US);
        gregorianCalendar.setGregorianChange(new Date(Long.MIN_VALUE));
        if (this.hasTimeZone) {
            gregorianCalendar.setTimeZone(this.timeZone);
        }
        gregorianCalendar.set(1, this.year);
        gregorianCalendar.set(2, this.month - 1);
        gregorianCalendar.set(5, this.day);
        gregorianCalendar.set(11, this.hour);
        gregorianCalendar.set(12, this.minute);
        gregorianCalendar.set(13, this.second);
        gregorianCalendar.set(14, this.nanoSeconds / 1000000);
        return gregorianCalendar;
    }

    @Override
    public String getISO8601String() {
        return ISO8601Converter.render(this);
    }

    public String toString() {
        return this.getISO8601String();
    }
}

