/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.IterativeThresholding;

import ij.ImagePlus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Objects3DPopulation;
import mcib3d.geom.Point3D;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.BlankMask;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageLabeller;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.IterativeThresholding.BestCriteriaMax;
import mcib3d.image3d.IterativeThresholding.BestCriteriaMin;
import mcib3d.image3d.IterativeThresholding.BestCriteriaStable;
import mcib3d.image3d.IterativeThresholding.BestCriterion;
import mcib3d.image3d.IterativeThresholding.Criterion;
import mcib3d.image3d.IterativeThresholding.CriterionCompactness;
import mcib3d.image3d.IterativeThresholding.CriterionEdge;
import mcib3d.image3d.IterativeThresholding.CriterionElongation;
import mcib3d.image3d.IterativeThresholding.CriterionVolume;
import mcib3d.image3d.IterativeThresholding.ObjectTrack;
import mcib3d.image3d.Segment3DSpots;
import mcib3d.utils.ArrayUtil;
import mcib3d.utils.Chrono;
import mcib3d.utils.Logger.AbstractLog;
import mcib3d.utils.Logger.IJLog;

public class TrackThreshold {
    public static final byte THRESHOLD_METHOD_STEP = 1;
    public static final byte THRESHOLD_METHOD_KMEANS = 2;
    public static final byte THRESHOLD_METHOD_VOLUME = 3;
    public static final byte CRITERIA_METHOD_MIN_ELONGATION = 1;
    public static final byte CRITERIA_METHOD_MAX_VOLUME = 2;
    public static final byte CRITERIA_METHOD_MSER = 3;
    public static final byte CRITERIA_METHOD_MAX_COMPACTNESS = 4;
    public static final byte CRITERIA_METHOD_MAX_EDGES = 5;
    @Deprecated
    public boolean verbose = true;
    @Deprecated
    public boolean status = true;
    AbstractLog log = new IJLog();
    private int volMax = 1000;
    private int volMin = 1;
    private int contrastMin = 100;
    private int threshold_method = 1;
    private int step = 1;
    private int nbClasses = 100;
    private int startThreshold;
    private int stopThreshold = Integer.MAX_VALUE;
    private int criteria_method = 1;
    private int GlobalThreshold;
    private ArrayList<Point3D> markers = null;
    private ImageInt imageMarkers = null;
    private ImageInt imageZones = null;
    private Objects3DPopulation populationZones = null;

    public TrackThreshold(int vmin, int vmax, int st, int nbCla, int sta) {
        if (vmax >= vmin) {
            this.volMax = vmax;
            this.volMin = vmin;
        } else {
            this.volMax = vmin;
            this.volMin = vmax;
        }
        this.step = st;
        this.nbClasses = nbCla;
        this.startThreshold = sta;
    }

    public TrackThreshold(int vmin, int vmax, int contrast, int st, int nbCla, int sta) {
        if (vmax >= vmin) {
            this.volMax = vmax;
            this.volMin = vmin;
        } else {
            this.volMax = vmin;
            this.volMin = vmax;
        }
        this.step = st;
        this.nbClasses = nbCla;
        this.startThreshold = sta;
        this.contrastMin = contrast;
    }

    private static int[] constantVoxelsHistogram(ImageHandler img, int nbClasses, int startThreshold) {
        int val;
        if (img instanceof ImageByte) {
            int[] res = new int[256];
            for (int i = 0; i < 256; ++i) {
                res[i] = i;
            }
            return res;
        }
        short[] pix = (short[])img.getArray1D();
        Arrays.sort(pix);
        int idx = 0;
        if (startThreshold > pix[pix.length - 1]) {
            startThreshold = 0;
        }
        while (idx < pix.length && pix[idx] < startThreshold) {
            ++idx;
        }
        pix = Arrays.copyOfRange(pix, idx, pix.length);
        int nbVox = pix.length / nbClasses;
        int[] res = new int[nbVox];
        Arrays.fill(res, -1);
        int count = 0;
        res[count] = val = pix[0];
        int id1 = nbVox;
        val = pix[id1];
        while (id1 < pix.length) {
            while (id1 < pix.length && pix[id1] == val) {
                ++id1;
            }
            if (id1 >= pix.length) continue;
            res[++count] = pix[id1];
            if ((id1 += nbVox) >= pix.length) continue;
            val = pix[id1];
        }
        int[] res2 = new int[count + 1];
        System.arraycopy(res, 0, res2, 0, count + 1);
        return res2;
    }

    public void setImageMarkers(ImageInt imageMarkers) {
        this.imageMarkers = imageMarkers;
    }

    public void setImageZones(ImageInt imageZones) {
        this.imageZones = imageZones;
    }

    public void setStopThreshold(int stopThreshold) {
        this.stopThreshold = stopThreshold;
    }

    public void setMethodThreshold(int meth) {
        this.threshold_method = meth;
    }

    public void setCriteriaMethod(int criteria_method) {
        this.criteria_method = criteria_method;
    }

    public void setMarkers(ArrayList<Point3D> point3Ds) {
        this.markers = point3Ds;
    }

    private int[] initHistogram(ImageHandler img) {
        int[] histogramThreshold = new int[]{};
        if (this.threshold_method == 1) {
            int i;
            int max = Math.min(this.stopThreshold, (int)img.getMax());
            ImageInt mask = null;
            int[] histogramImage = img.getHistogram(mask, 65536, 0.0, 65535.0);
            ArrayList<Integer> histogramTmp = new ArrayList<Integer>();
            for (i = this.startThreshold; i < max; i += this.step) {
                while (histogramImage[i] == 0 && i < max) {
                    ++i;
                }
                histogramTmp.add(i);
            }
            histogramThreshold = new int[histogramTmp.size()];
            for (i = 0; i < histogramTmp.size(); ++i) {
                histogramThreshold[i] = (Integer)histogramTmp.get(i);
            }
        } else if (this.threshold_method == 2) {
            BlankMask mas = new BlankMask(img);
            int[] h = img.getHistogram(mas, 65536, 0.0, 65535.0);
            if (this.log != null) {
                this.log.log("Computing k-means");
            }
            histogramThreshold = ArrayUtil.kMeans_Histogram1D(h, this.nbClasses, this.startThreshold);
            Arrays.sort(histogramThreshold);
        } else if (this.threshold_method == 3) {
            histogramThreshold = TrackThreshold.constantVoxelsHistogram(img, this.nbClasses, this.startThreshold);
        }
        return histogramThreshold;
    }

    private ArrayList<ObjectTrack> computeAssociation(ArrayList<ObjectTrack> frame1, ArrayList<ObjectTrack> frame2, ArrayList<ObjectTrack> allFrames, ImageHandler labels2) {
        HashMap<Integer, ObjectTrack> hashObjectsT2 = new HashMap<Integer, ObjectTrack>();
        for (ObjectTrack objectTrack : frame2) {
            hashObjectsT2.put(objectTrack.getObject().getValue(), objectTrack);
        }
        ArrayList<ObjectTrack> newListTrack = new ArrayList<ObjectTrack>();
        for (ObjectTrack obt : frame1) {
            ArrayUtil list = obt.getObject().listValues(labels2, 0.0f);
            if ((list = list.distinctValues()).getSize() == 1) {
                ObjectTrack child = (ObjectTrack)hashObjectsT2.get((int)list.getValue(0));
                if (child != null && obt.volume > child.volume) {
                    obt.addChild(child);
                    child.setParent(obt);
                    allFrames.add(child);
                    newListTrack.add(child);
                    frame2.remove(child);
                    obt.setObject(null);
                }
                if (child == null || obt.volume != child.volume) continue;
                newListTrack.add(obt);
                frame2.remove(child);
                continue;
            }
            if (list.getSize() <= 1) continue;
            for (int i = 0; i < list.getSize(); ++i) {
                ObjectTrack child = (ObjectTrack)hashObjectsT2.get((int)list.getValue(i));
                if (child == null) continue;
                obt.addChild(child);
                child.setParent(obt);
                newListTrack.add(child);
                allFrames.add(child);
                frame2.remove(child);
                obt.setObject(null);
            }
        }
        newListTrack.addAll(frame2);
        return newListTrack;
    }

    private ArrayList<ObjectTrack> computeFrame(ImageHandler img, ArrayList<Object3DVoxels> objects, ArrayList<Point3D> markers, int threshold, Criterion criterion) {
        ArrayList<ObjectTrack> frame1 = new ArrayList<ObjectTrack>();
        for (Object3DVoxels ob : objects) {
            if (!this.checkMarkersTest(ob)) continue;
            ObjectTrack obt = new ObjectTrack();
            obt.setObject(ob);
            obt.setFrame(threshold);
            obt.computeCriterion(criterion);
            obt.volume = ob.getVolumePixels();
            obt.seed = ob.getFirstVoxel();
            obt.threshold = threshold;
            obt.rawImage = img;
            frame1.add(obt);
        }
        return frame1;
    }

    private ArrayList<ImageHandler> process(ImageHandler img) {
        int T2;
        int T0;
        BestCriterion bestCriterion;
        Criterion criterion;
        switch (this.criteria_method) {
            case 1: {
                criterion = new CriterionElongation();
                bestCriterion = new BestCriteriaMin();
                break;
            }
            case 4: {
                criterion = new CriterionCompactness();
                bestCriterion = new BestCriteriaMax();
                break;
            }
            case 2: {
                criterion = new CriterionVolume();
                bestCriterion = new BestCriteriaMax();
                break;
            }
            case 3: {
                criterion = new CriterionVolume();
                bestCriterion = new BestCriteriaStable();
                break;
            }
            case 5: {
                criterion = new CriterionEdge(img, 0.5);
                bestCriterion = new BestCriteriaMax();
                break;
            }
            default: {
                criterion = new CriterionVolume();
                bestCriterion = new BestCriteriaStable();
            }
        }
        ImageLabeller labeler = new ImageLabeller(this.volMin, this.volMax);
        int TMaximum = (int)img.getMax();
        if (this.log != null) {
            this.log.log("Analysing histogram ...");
        }
        int[] histogramThreshold = this.initHistogram(img);
        int T1 = T0 = histogramThreshold[0];
        if (this.log != null) {
            this.log.log("Computing frame for first threshold " + T1);
        }
        ArrayList<ObjectTrack> frame1 = this.computeFrame(img, labeler.getObjects(img.thresholdAboveInclusive(T1)), this.markers, T1, criterion);
        if (this.log != null) {
            this.log.log("Starting iterative thresholding ... ");
        }
        ArrayList<ObjectTrack> allFrames = new ArrayList<ObjectTrack>();
        allFrames.addAll(frame1);
        this.GlobalThreshold = 1;
        Chrono chrono = new Chrono(TMaximum);
        chrono.start();
        String S = null;
        if (this.log instanceof IJLog) {
            ((IJLog)this.log).setUpdate(true);
        }
        while (T1 <= TMaximum && (T2 = this.computeNextThreshold(T1, TMaximum, histogramThreshold)) >= 0) {
            if (this.log != null && (S = chrono.getFullInfo(T2 - T1)) != null) {
                this.log.log(S);
            }
            ImageByte bin2 = img.thresholdAboveInclusive(T2);
            ImageInt labels2 = labeler.getLabels(bin2);
            ArrayList<ObjectTrack> frame2 = this.computeFrame(img, labeler.getObjects(bin2), this.markers, T2, criterion);
            System.gc();
            T1 = T2;
            frame1 = this.computeAssociation(frame1, frame2, allFrames, labels2);
        }
        if (this.log instanceof IJLog) {
            ((IJLog)this.log).setUpdate(false);
        }
        if (this.log != null) {
            this.log.log("Iterative Thresholding finished");
        }
        return this.computeResults(allFrames, img, bestCriterion);
    }

    private ArrayList<ImageHandler> computeResults(ArrayList<ObjectTrack> allFrames, ImageHandler img, BestCriterion bestCriterion) {
        int level = 1;
        int maxLevel = 10;
        ArrayList<ImageHandler> drawsReconstruct = new ArrayList<ImageHandler>();
        while (this.deleteLowContrastTracks(allFrames, this.contrastMin)) {
        }
        while (!allFrames.isEmpty() && level < maxLevel) {
            if (this.log != null) {
                this.log.log("Nb total objects level " + level + " : " + allFrames.size());
            }
            ImageHandler drawIdx = allFrames.size() < 65535 ? new ImageShort("Objects", img.sizeX, img.sizeY, img.sizeZ) : new ImageFloat("Objects", img.sizeX, img.sizeY, img.sizeZ);
            drawsReconstruct.add(drawIdx);
            int idx = 1;
            ArrayList<ObjectTrack> toBeRemoved = new ArrayList<ObjectTrack>();
            for (ObjectTrack obt : allFrames) {
                if (obt.getState() != ObjectTrack.STATE_DIE) continue;
                ObjectTrack anc = obt.getAncestor();
                if (anc == null) {
                    anc = obt;
                }
                ArrayList<ObjectTrack> list = obt.getLineageTo(anc);
                int contrast = 0;
                if (anc != null) {
                    contrast = obt.getFrame() - anc.getFrame();
                }
                ObjectTrack bestObject = this.computeBestObject(list, bestCriterion);
                Voxel3D seed = anc.seed;
                int threshold = anc.threshold;
                ObjectTrack objectSegment = anc;
                if (bestObject != null) {
                    objectSegment = bestObject;
                    seed = objectSegment.seed;
                    threshold = objectSegment.threshold;
                }
                Segment3DSpots SegmentSpot = new Segment3DSpots(objectSegment.rawImage, null);
                Object3DVoxels object3D = new Object3DVoxels(SegmentSpot.segmentSpotClassical(seed.getRoundX(), seed.getRoundY(), seed.getRoundZ(), threshold, idx));
                ((Object3D)object3D).draw(drawIdx, idx);
                toBeRemoved.addAll(list);
                ++idx;
            }
            ++level;
            if (toBeRemoved.isEmpty()) break;
            for (ObjectTrack obt : toBeRemoved) {
                ObjectTrack par = obt.getParent();
                if (par == null) continue;
                par.removeChild(obt);
            }
            allFrames.removeAll(toBeRemoved);
        }
        allFrames = null;
        System.gc();
        return drawsReconstruct;
    }

    private ObjectTrack computeBestObject(ArrayList<ObjectTrack> list, BestCriterion bestCriterion) {
        ArrayUtil valueCriterion = new ArrayUtil(list.size());
        for (int i = 0; i < valueCriterion.getSize(); ++i) {
            valueCriterion.putValue(i, list.get((int)i).valueCriteria);
        }
        return list.get(bestCriterion.computeBestCriterion(valueCriterion));
    }

    private int computeNextThreshold(int T1, int Tmax, int[] histogram) {
        int T2 = T1;
        if (T2 < Tmax) {
            T2 = histogram[this.GlobalThreshold];
            ++this.GlobalThreshold;
            while (T2 == 0 && T2 <= Tmax + 1 && this.GlobalThreshold < histogram.length) {
                T2 = histogram[this.GlobalThreshold];
                ++this.GlobalThreshold;
            }
            if (T2 > Tmax + 1 || this.GlobalThreshold >= histogram.length) {
                T2 = -1;
            }
        } else if (T2 == Tmax) {
            T2 = Tmax + 1;
        }
        return T2;
    }

    private boolean deleteLowContrastTracks(ArrayList<ObjectTrack> allFrames, int contrastMin) {
        boolean change = false;
        if (contrastMin <= 0) {
            return change;
        }
        ArrayList<ObjectTrack> toBeRemoved = new ArrayList<ObjectTrack>();
        for (ObjectTrack objectTrack : allFrames) {
            if (objectTrack.getState() != ObjectTrack.STATE_DIE) continue;
            ObjectTrack anc = objectTrack.getAncestor();
            if (anc == null) {
                anc = objectTrack;
            }
            int contrast = 0;
            if (anc != null) {
                contrast = objectTrack.getFrame() - anc.getFrame();
            }
            if (contrast >= contrastMin) continue;
            toBeRemoved.addAll(objectTrack.getLineageTo(anc));
            change = true;
        }
        allFrames.removeAll(toBeRemoved);
        return change;
    }

    public ImageHandler segment(ImageHandler input, boolean verbose) {
        this.setVerbose(verbose);
        ArrayList<ImageHandler> res = this.process(input);
        if (!res.isEmpty()) {
            return res.get(0);
        }
        return null;
    }

    public ArrayList<ImageHandler> segmentAll(ImageHandler input, boolean verbose) {
        this.setVerbose(verbose);
        return this.process(input);
    }

    public ImagePlus segment(ImagePlus input, boolean show) {
        this.setVerbose(show);
        ArrayList<ImageHandler> drawsReconstruct = this.process(ImageHandler.wrap(input));
        if (drawsReconstruct.size() == 0) {
            return null;
        }
        ImageHandler[] drawsTab = new ImageHandler[drawsReconstruct.size()];
        for (int i = 0; i < drawsTab.length; ++i) {
            drawsTab[i] = drawsReconstruct.get(i);
        }
        return ImageHandler.getHyperStack("draw", drawsTab);
    }

    @Deprecated
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setLog(AbstractLog abstractLog) {
        this.log = abstractLog;
    }

    private boolean checkMarkers(Object3D object3D) {
        return this.markers == null || object3D.insideOne(this.markers);
    }

    private boolean checkMarkersTest(Object3D object3D) {
        boolean mark = this.imageMarkers == null || object3D.includesMarkersOneOnly(this.imageMarkers);
        boolean zone = this.imageZones == null || object3D.includedInZonesOneOnly(this.imageZones);
        return mark && zone;
    }

    private double checkZoneColoc(Object3D object3D) {
        if (this.populationZones == null) {
            this.populationZones = new Objects3DPopulation(this.imageZones);
        }
        ArrayUtil arrayUtil = object3D.listValues(this.imageZones);
        arrayUtil = arrayUtil.distinctValues();
        double maxColoc = 0.0;
        for (double z : arrayUtil.getArrayList()) {
            Object3D zone;
            double coloc;
            if (z == 0.0 || !((coloc = object3D.pcColoc(zone = this.populationZones.getObjectByValue((int)z))) > maxColoc)) continue;
            maxColoc = coloc;
        }
        return maxColoc;
    }
}

