/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.canvas;

import icy.canvas.Canvas3D;
import icy.canvas.CanvasLayerEvent;
import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvasEvent;
import icy.canvas.Layer;
import icy.common.exception.TooLargeArrayException;
import icy.gui.component.button.IcyToggleButton;
import icy.gui.util.ComponentUtil;
import icy.gui.util.GuiUtil;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.image.lut.LUT;
import icy.painter.Overlay;
import icy.painter.VtkPainter;
import icy.preferences.CanvasPreferences;
import icy.preferences.XMLPreferences;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.roi.ROI;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.system.IcyExceptionHandler;
import icy.system.thread.ThreadUtil;
import icy.type.collection.array.Array1DUtil;
import icy.type.point.Point3D;
import icy.util.ColorUtil;
import icy.util.EventUtil;
import icy.util.StringUtil;
import icy.vtk.IcyVtkPanel;
import icy.vtk.VtkImageVolume;
import icy.vtk.VtkUtil;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.JToolBar;
import plugins.kernel.canvas.VtkSettingPanel;
import vtk.vtkActor;
import vtk.vtkActor2D;
import vtk.vtkAxesActor;
import vtk.vtkCamera;
import vtk.vtkColorTransferFunction;
import vtk.vtkCubeAxesActor;
import vtk.vtkImageData;
import vtk.vtkInformation;
import vtk.vtkInformationIntegerKey;
import vtk.vtkLight;
import vtk.vtkPicker;
import vtk.vtkPiecewiseFunction;
import vtk.vtkProp;
import vtk.vtkRenderWindow;
import vtk.vtkRenderer;
import vtk.vtkTextActor;
import vtk.vtkTextProperty;

public class VtkCanvas
extends Canvas3D
implements ActionListener,
VtkSettingPanel.SettingChangeListener {
    private static final long serialVersionUID = -1274251057822161271L;
    public static final Image ICON_AXES3D = ResourceUtil.getAlphaIconAsImage("axes3d.png");
    public static final Image ICON_BOUNDINGBOX = ResourceUtil.getAlphaIconAsImage("bbox.png");
    public static final Image ICON_GRID = ResourceUtil.getAlphaIconAsImage("3x3_grid.png");
    public static final Image ICON_RULER = ResourceUtil.getAlphaIconAsImage("ruler.png");
    public static final Image ICON_RULERLABEL = ResourceUtil.getAlphaIconAsImage("ruler_label.png");
    public static final Image ICON_TARGET = ResourceUtil.getAlphaIconAsImage("target.png");
    public static final String PROPERTY_AXES = "axis";
    public static final String PROPERTY_BOUNDINGBOX = "boundingBox";
    public static final String PROPERTY_BOUNDINGBOX_GRID = "boundingBoxGrid";
    public static final String PROPERTY_BOUNDINGBOX_RULES = "boundingBoxRules";
    public static final String PROPERTY_BOUNDINGBOX_LABELS = "boundingBoxLabels";
    public static final String PROPERTY_LUT = "lut";
    public static final String PROPERTY_DATA = "data";
    public static final String PROPERTY_SCALE = "scale";
    public static final String PROPERTY_BOUNDS = "bounds";
    public static final vtkInformationIntegerKey visibilityKey = new vtkInformationIntegerKey().MakeKey("Visibility", "Property");
    protected static final String PREF_ID = "vtkCanvas";
    protected static final String ID_BOUNDINGBOX = "boundingBox";
    protected static final String ID_BOUNDINGBOX_GRID = "boundingBoxGrid";
    protected static final String ID_BOUNDINGBOX_RULES = "boundingBoxRules";
    protected static final String ID_BOUNDINGBOX_LABELS = "boundingBoxLabels";
    protected static final String ID_AXES = "axis";
    protected static final String ID_SHADING = "shading";
    protected static final String ID_BGCOLOR = "renderBGColor";
    protected static final String ID_MAPPER = "volumeMapper";
    protected static final String ID_SAMPLE = "volumeSample";
    protected static final String ID_BLENDING = "volumeBlending";
    protected static final String ID_INTERPOLATION = "volumeInterpolation";
    protected static final String ID_AMBIENT = "volumeAmbient";
    protected static final String ID_DIFFUSE = "volumeDiffuse";
    protected static final String ID_SPECULAR = "volumeSpecular";
    protected vtkRenderer renderer;
    protected vtkRenderWindow renderWindow;
    protected vtkCamera camera;
    protected vtkCubeAxesActor boundingBox;
    protected vtkCubeAxesActor rulerBox;
    protected vtkTextActor textInfo;
    protected vtkTextProperty textProperty;
    protected vtkProp pickedObject;
    protected VtkImageVolume imageVolume;
    protected VtkSettingPanel settingPanel;
    protected CustomVtkPanel panel3D;
    protected IcyToggleButton axesButton;
    protected IcyToggleButton boundingBoxButton;
    protected IcyToggleButton gridButton;
    protected IcyToggleButton rulerButton;
    protected IcyToggleButton rulerLabelButton;
    protected PropertiesUpdater propertiesUpdater;
    protected VtkOverlayUpdater overlayUpdater;
    protected XMLPreferences preferences;
    protected final EDTTask<Object> edtTask;
    protected boolean initialized = false;

    public VtkCanvas(Viewer viewer) {
        super(viewer);
        if (this.getImageSizeC() > 4) {
            throw new UnsupportedOperationException("VTK does not support image with more than 4 channels !\nYou should remove some channels in your image.");
        }
        this.posC = -1;
        this.lut.setAlphaToLinear3D();
        this.pickedObject = null;
        this.propertiesUpdater = new PropertiesUpdater();
        this.overlayUpdater = new VtkOverlayUpdater();
        this.preferences = CanvasPreferences.getPreferences().node(PREF_ID);
        this.settingPanel = new VtkSettingPanel();
        this.panel = this.settingPanel;
        this.panel3D = new CustomVtkPanel();
        this.panel3D.addKeyListener((KeyListener)((Object)this));
        this.add((Component)((Object)this.panel3D), "Center");
        this.mouseInfPanel.setVisible(false);
        this.updateZNav();
        this.updateTNav();
        this.axesButton = new IcyToggleButton(new IcyIcon(ICON_AXES3D));
        this.axesButton.setFocusable(false);
        this.axesButton.setToolTipText("Display 3D axis");
        this.boundingBoxButton = new IcyToggleButton(new IcyIcon(ICON_BOUNDINGBOX));
        this.boundingBoxButton.setFocusable(false);
        this.boundingBoxButton.setToolTipText("Display bounding box");
        this.gridButton = new IcyToggleButton(new IcyIcon(ICON_GRID));
        this.gridButton.setFocusable(false);
        this.gridButton.setToolTipText("Display grid");
        this.rulerButton = new IcyToggleButton(new IcyIcon(ICON_RULER));
        this.rulerButton.setFocusable(false);
        this.rulerButton.setToolTipText("Display rules");
        this.rulerLabelButton = new IcyToggleButton(new IcyIcon(ICON_RULERLABEL));
        this.rulerLabelButton.setFocusable(false);
        this.rulerLabelButton.setToolTipText("Display rules label");
        this.panel3D.setCoarseRendering(1000L);
        this.renderer = this.panel3D.getRenderer();
        this.renderWindow = this.panel3D.getRenderWindow();
        this.camera = this.renderer.GetActiveCamera();
        this.textInfo = new vtkTextActor();
        this.textInfo.SetInput("Not enough memory to display this 3D image !");
        this.textInfo.SetPosition(10.0, 10.0);
        this.textInfo.SetVisibility(0);
        this.textProperty = this.textInfo.GetTextProperty();
        this.textProperty.SetFontFamilyToArial();
        this.updateImageData(this.getImageData());
        Sequence seq = this.getSequence();
        if (seq != null) {
            this.imageVolume.setScale(seq.getPixelSizeX(), seq.getPixelSizeY(), seq.getPixelSizeZ());
        }
        this.imageVolume.setLUT(this.getLut());
        this.boundingBox = new vtkCubeAxesActor();
        this.boundingBox.SetBounds(this.imageVolume.getVolume().GetBounds());
        this.boundingBox.SetCamera(this.camera);
        this.boundingBox.SetFlyModeToStaticEdges();
        this.boundingBox.SetUseBounds(true);
        this.boundingBox.XAxisLabelVisibilityOff();
        this.boundingBox.XAxisMinorTickVisibilityOff();
        this.boundingBox.XAxisTickVisibilityOff();
        this.boundingBox.YAxisLabelVisibilityOff();
        this.boundingBox.YAxisMinorTickVisibilityOff();
        this.boundingBox.YAxisTickVisibilityOff();
        this.boundingBox.ZAxisLabelVisibilityOff();
        this.boundingBox.ZAxisMinorTickVisibilityOff();
        this.boundingBox.ZAxisTickVisibilityOff();
        this.rulerBox = new vtkCubeAxesActor();
        this.rulerBox.SetBounds(this.imageVolume.getVolume().GetBounds());
        this.rulerBox.SetCamera(this.camera);
        this.rulerBox.SetXUnits("micro meter");
        this.rulerBox.GetTitleTextProperty(0).SetColor(1.0, 0.0, 0.0);
        this.rulerBox.GetLabelTextProperty(0).SetColor(1.0, 0.0, 0.0);
        this.rulerBox.GetXAxesLinesProperty().SetColor(1.0, 0.0, 0.0);
        this.rulerBox.GetXAxesGridlinesProperty().SetColor(1.0, 0.0, 0.0);
        this.rulerBox.GetXAxesGridpolysProperty().SetColor(1.0, 0.0, 0.0);
        this.rulerBox.GetXAxesInnerGridlinesProperty().SetColor(1.0, 0.0, 0.0);
        this.rulerBox.SetYUnits("micro meter");
        this.rulerBox.GetTitleTextProperty(1).SetColor(0.0, 1.0, 0.0);
        this.rulerBox.GetLabelTextProperty(1).SetColor(0.0, 1.0, 0.0);
        this.rulerBox.GetYAxesLinesProperty().SetColor(0.0, 1.0, 0.0);
        this.rulerBox.GetYAxesGridlinesProperty().SetColor(0.0, 1.0, 0.0);
        this.rulerBox.GetYAxesGridpolysProperty().SetColor(0.0, 1.0, 0.0);
        this.rulerBox.GetYAxesInnerGridlinesProperty().SetColor(0.0, 1.0, 0.0);
        this.rulerBox.SetZUnits("micro meter");
        this.rulerBox.GetTitleTextProperty(2).SetColor(0.0, 0.0, 1.0);
        this.rulerBox.GetLabelTextProperty(2).SetColor(0.0, 0.0, 1.0);
        this.rulerBox.GetZAxesLinesProperty().SetColor(0.0, 0.0, 1.0);
        this.rulerBox.GetZAxesGridlinesProperty().SetColor(0.0, 0.0, 1.0);
        this.rulerBox.GetZAxesGridpolysProperty().SetColor(0.0, 0.0, 1.0);
        this.rulerBox.GetZAxesInnerGridlinesProperty().SetColor(0.0, 0.0, 1.0);
        this.rulerBox.SetGridLineLocation(2);
        this.rulerBox.SetFlyModeToOuterEdges();
        this.rulerBox.SetUseBounds(true);
        this.settingPanel.setBackgroundColor(new Color(this.preferences.getInt(ID_BGCOLOR, 0)));
        this.settingPanel.setVolumeBlendingMode(VtkImageVolume.VtkVolumeBlendType.values()[this.preferences.getInt(ID_BLENDING, VtkImageVolume.VtkVolumeBlendType.COMPOSITE.ordinal())]);
        this.settingPanel.setGPURendering(this.preferences.getInt(ID_MAPPER, 0) != 0);
        this.settingPanel.setVolumeInterpolation(this.preferences.getInt(ID_INTERPOLATION, 1));
        this.settingPanel.setVolumeSample(this.preferences.getInt(ID_SAMPLE, 0));
        this.settingPanel.setVolumeAmbient(this.preferences.getDouble(ID_AMBIENT, 0.2));
        this.settingPanel.setVolumeDiffuse(this.preferences.getDouble(ID_DIFFUSE, 0.4));
        this.settingPanel.setVolumeSpecular(this.preferences.getDouble(ID_SPECULAR, 0.4));
        this.settingPanel.setVolumeShading(this.preferences.getBoolean(ID_SHADING, false));
        this.axesButton.setSelected(this.preferences.getBoolean("axis", true));
        this.boundingBoxButton.setSelected(this.preferences.getBoolean("boundingBox", true));
        this.gridButton.setSelected(this.preferences.getBoolean("boundingBoxGrid", true));
        this.rulerButton.setSelected(this.preferences.getBoolean("boundingBoxRules", false));
        this.rulerLabelButton.setSelected(this.preferences.getBoolean("boundingBoxLabels", false));
        this.setBackgroundColorInternal(this.settingPanel.getBackgroundColor());
        this.imageVolume.setBlendingMode(this.settingPanel.getVolumeBlendingMode());
        this.imageVolume.setGPURendering(this.settingPanel.getGPURendering());
        this.settingPanel.setVolumeBlendingMode(this.imageVolume.getBlendingMode());
        this.imageVolume.setInterpolationMode(this.settingPanel.getVolumeInterpolation());
        this.imageVolume.setSampleResolution(this.settingPanel.getVolumeSample());
        this.imageVolume.setAmbient(this.settingPanel.getVolumeAmbient());
        this.imageVolume.setDiffuse(this.settingPanel.getVolumeDiffuse());
        this.imageVolume.setSpecular(this.settingPanel.getVolumeSpecular());
        this.imageVolume.setShade(this.settingPanel.getVolumeShading());
        this.boundingBox.SetVisibility(this.boundingBoxButton.isSelected() ? 1 : 0);
        this.rulerBox.SetDrawXGridlines(this.gridButton.isSelected() ? 1 : 0);
        this.rulerBox.SetDrawYGridlines(this.gridButton.isSelected() ? 1 : 0);
        this.rulerBox.SetDrawZGridlines(this.gridButton.isSelected() ? 1 : 0);
        this.rulerBox.SetXAxisVisibility(this.rulerButton.isSelected() ? 1 : 0);
        this.rulerBox.SetXAxisTickVisibility(this.rulerButton.isSelected() ? 1 : 0);
        this.rulerBox.SetXAxisMinorTickVisibility(this.rulerButton.isSelected() ? 1 : 0);
        this.rulerBox.SetYAxisVisibility(this.rulerButton.isSelected() ? 1 : 0);
        this.rulerBox.SetYAxisTickVisibility(this.rulerButton.isSelected() ? 1 : 0);
        this.rulerBox.SetYAxisMinorTickVisibility(this.rulerButton.isSelected() ? 1 : 0);
        this.rulerBox.SetZAxisVisibility(this.rulerButton.isSelected() ? 1 : 0);
        this.rulerBox.SetZAxisTickVisibility(this.rulerButton.isSelected() ? 1 : 0);
        this.rulerBox.SetZAxisMinorTickVisibility(this.rulerButton.isSelected() ? 1 : 0);
        this.rulerBox.SetXAxisLabelVisibility(this.rulerLabelButton.isSelected() ? 1 : 0);
        this.rulerBox.SetYAxisLabelVisibility(this.rulerLabelButton.isSelected() ? 1 : 0);
        this.rulerBox.SetZAxisLabelVisibility(this.rulerLabelButton.isSelected() ? 1 : 0);
        this.renderer.AddVolume((vtkProp)this.imageVolume.getVolume());
        this.renderer.AddViewProp((vtkProp)this.boundingBox);
        this.renderer.AddViewProp((vtkProp)this.rulerBox);
        this.renderer.AddViewProp((vtkProp)this.textInfo);
        this.resetCamera();
        this.updateLut();
        this.settingPanel.addSettingChangeListener((VtkSettingPanel.SettingChangeListener)this);
        this.axesButton.addActionListener((ActionListener)this);
        this.boundingBoxButton.addActionListener((ActionListener)this);
        this.gridButton.addActionListener((ActionListener)this);
        this.rulerButton.addActionListener((ActionListener)this);
        this.rulerLabelButton.addActionListener((ActionListener)this);
        this.edtTask = new EDTTask();
        this.propertiesUpdater.start();
        this.overlayUpdater.start();
        this.initialized = true;
        this.overlayUpdater.addProps(VtkUtil.getLayersProps((List)this.getLayers(false)));
    }

    public void shutDown() {
        long st = System.currentTimeMillis();
        while (System.currentTimeMillis() - st < 5000L && !this.initialized) {
            ThreadUtil.sleep(1);
        }
        this.propertiesUpdater.interrupt();
        try {
            this.propertiesUpdater.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.overlayUpdater.interrupt();
        try {
            this.overlayUpdater.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.initialized = false;
        this.propertiesUpdater = null;
        this.overlayUpdater = null;
        this.invokeOnEDTSilent(new Runnable(){

            @Override
            public void run() {
                VtkCanvas.this.renderer.RemoveAllViewProps();
                VtkCanvas.this.imageVolume.release();
                VtkCanvas.this.boundingBox.Delete();
                VtkCanvas.this.panel3D.disposeInternal();
            }
        });
        this.removeAll();
        this.panel.removeAll();
        this.renderer = null;
        this.renderWindow = null;
        this.imageVolume = null;
        this.boundingBox = null;
        this.camera = null;
        this.panel3D.removeKeyListener((KeyListener)((Object)this));
        this.panel3D = null;
        this.panel = null;
        super.shutDown();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void customizeToolbar(JToolBar toolBar) {
        toolBar.addSeparator();
        toolBar.add((Component)this.axesButton);
        toolBar.addSeparator();
        toolBar.add((Component)this.boundingBoxButton);
        toolBar.add((Component)this.gridButton);
        toolBar.add((Component)this.rulerButton);
        toolBar.add((Component)this.rulerLabelButton);
    }

    protected Overlay createImageOverlay() {
        return new VtkCanvasImageOverlay();
    }

    @Deprecated
    public void lock() {
        if (this.panel3D != null) {
            this.panel3D.lock();
        }
    }

    @Deprecated
    public void unlock() {
        if (this.panel3D != null) {
            this.panel3D.unlock();
        }
    }

    @Deprecated
    public vtkCamera getActiveCam() {
        return this.getCamera();
    }

    public vtkCamera getCamera() {
        return this.camera;
    }

    public vtkLight getLight() {
        return this.renderer.GetLights().GetNextItem();
    }

    public vtkAxesActor getAxes() {
        return this.panel3D.getAxesActor();
    }

    public vtkCubeAxesActor getBoundingBox() {
        return this.boundingBox;
    }

    public vtkCubeAxesActor getRulerBox() {
        return this.rulerBox;
    }

    public VtkImageVolume getImageVolume() {
        return this.imageVolume;
    }

    public Color getBackgroundColor() {
        return this.settingPanel.getBackgroundColor();
    }

    public void setBackgroundColor(Color value) {
        this.settingPanel.setBackgroundColor(value);
    }

    public boolean isBoundingBoxVisible() {
        return this.boundingBoxButton.isSelected();
    }

    public void setBoundingBoxVisible(boolean value) {
        if (this.boundingBoxButton.isSelected() != value) {
            this.boundingBoxButton.doClick();
        }
    }

    public boolean isBoundingBoxGridVisible() {
        return this.gridButton.isSelected();
    }

    public void setBoundingBoxGridVisible(boolean value) {
        if (this.gridButton.isSelected() != value) {
            this.gridButton.doClick();
        }
    }

    public boolean isBoundingBoxRulerVisible() {
        return this.rulerButton.isSelected();
    }

    public void setBoundingBoxRulerVisible(boolean value) {
        if (this.rulerButton.isSelected() != value) {
            this.rulerButton.doClick();
        }
    }

    public boolean isBoundingBoxRulerLabelsVisible() {
        return this.rulerLabelButton.isSelected();
    }

    public void setBoundingBoxRulerLabelsVisible(boolean value) {
        if (this.rulerLabelButton.isSelected() != value) {
            this.rulerLabelButton.doClick();
        }
    }

    @Deprecated
    public void setBoundingBoxColor(Color color) {
        this.setBackgroundColorInternal(color);
    }

    public void setBackgroundColorInternal(Color color) {
        this.renderer.SetBackground(Array1DUtil.floatArrayToDoubleArray((float[])color.getColorComponents(null)));
        Color oppositeColor = ColorUtil.getLuminance((Color)color) > 128 ? Color.black : Color.white;
        float[] comp = oppositeColor.getRGBColorComponents(null);
        float r = comp[0];
        float g = comp[0];
        float b = comp[0];
        this.boundingBox.GetXAxesLinesProperty().SetColor((double)r, (double)g, (double)b);
        this.boundingBox.GetYAxesLinesProperty().SetColor((double)r, (double)g, (double)b);
        this.boundingBox.GetZAxesLinesProperty().SetColor((double)r, (double)g, (double)b);
        this.rulerBox.GetXAxesGridlinesProperty().SetColor((double)r, (double)g, (double)b);
        this.rulerBox.GetXAxesGridpolysProperty().SetColor((double)r, (double)g, (double)b);
        this.rulerBox.GetYAxesGridlinesProperty().SetColor((double)r, (double)g, (double)b);
        this.rulerBox.GetYAxesGridpolysProperty().SetColor((double)r, (double)g, (double)b);
        this.rulerBox.GetZAxesGridlinesProperty().SetColor((double)r, (double)g, (double)b);
        this.rulerBox.GetZAxesGridpolysProperty().SetColor((double)r, (double)g, (double)b);
        this.textProperty.SetColor((double)r, (double)g, (double)b);
    }

    public boolean isAxisVisible() {
        return this.axesButton.isSelected();
    }

    public void setAxisVisible(boolean value) {
        if (this.axesButton.isSelected() != value) {
            this.axesButton.doClick();
        }
    }

    public VtkImageVolume.VtkVolumeBlendType getVolumeBlendingMode() {
        return this.settingPanel.getVolumeBlendingMode();
    }

    public void setVolumeBlendingMode(VtkImageVolume.VtkVolumeBlendType value) {
        this.settingPanel.setVolumeBlendingMode(value);
    }

    public int getVolumeSample() {
        return this.settingPanel.getVolumeSample();
    }

    public void setVolumeSample(int value) {
        this.settingPanel.setVolumeSample(value);
    }

    public boolean isVolumeShadingEnable() {
        return this.settingPanel.getVolumeShading();
    }

    public void setVolumeShadingEnable(boolean value) {
        this.settingPanel.setVolumeShading(value);
    }

    public double getVolumeAmbient() {
        return this.settingPanel.getVolumeAmbient();
    }

    public void setVolumeAmbient(double value) {
        this.settingPanel.setVolumeAmbient(value);
    }

    public double getVolumeDiffuse() {
        return this.settingPanel.getVolumeDiffuse();
    }

    public void setVolumeDiffuse(double value) {
        this.settingPanel.setVolumeDiffuse(value);
    }

    public double getVolumeSpecular() {
        return this.settingPanel.getVolumeSpecular();
    }

    public void setVolumeSpecular(double value) {
        this.settingPanel.setVolumeSpecular(value);
    }

    public int getVolumeInterpolation() {
        return this.settingPanel.getVolumeInterpolation();
    }

    public void setVolumeInterpolation(int value) {
        this.settingPanel.setVolumeInterpolation(value);
    }

    public boolean getGPURendering() {
        return this.settingPanel.getGPURendering();
    }

    public void setGPURendering(boolean value) {
        this.settingPanel.setGPURendering(value);
    }

    public boolean isVolumeVisible() {
        return this.imageVolume.isVisible();
    }

    public void setVolumeVisible(boolean value) {
        this.imageVolume.setVisible(value);
    }

    public void refresh() {
        if (!this.initialized) {
            return;
        }
        if (this.panel3D != null) {
            this.panel3D.repaint();
        }
    }

    protected void resetCamera() {
        this.camera.SetViewUp(0.0, -1.0, 0.0);
        this.camera.Elevation(200.0);
        this.renderer.ResetCamera();
        this.renderer.ResetCameraClippingRange();
    }

    @Deprecated
    public void setVolumeDistanceSample(int value) {
        this.setVolumeSample(value);
    }

    @Deprecated
    public boolean getPickOnMouseMove() {
        return true;
    }

    @Deprecated
    public void setPickOnMouseMove(boolean value) {
    }

    public vtkProp getPickedObject() {
        return this.pickedObject;
    }

    @Deprecated
    public vtkActor pick(int x, int y) {
        return (vtkActor)this.panel3D.pick(x, y);
    }

    public vtkProp pickProp(int x, int y) {
        return this.panel3D.pick(x, y);
    }

    public double getWorldZ(int x, int y) {
        vtkRenderer r = this.getRenderer();
        vtkRenderWindow rw = this.getRenderWindow();
        if (r == null || rw == null) {
            return 0.0;
        }
        return r.GetZ(x, rw.GetSize()[1] - y);
    }

    public double getWorldZ(Point pt) {
        return this.getWorldZ(pt.x, pt.y);
    }

    public Point3D worldToDisplay(Point3D pt) {
        if (pt == null) {
            return new Point3D.Double();
        }
        return this.worldToDisplay(pt.getX(), pt.getY(), pt.getZ());
    }

    public Point3D worldToDisplay(double x, double y, double z) {
        vtkRenderer r = this.getRenderer();
        vtkRenderWindow rw = this.getRenderWindow();
        if (r == null || rw == null) {
            return new Point3D.Double();
        }
        r.SetWorldPoint(x, y, z, 1.0);
        r.WorldToDisplay();
        Point3D.Double result = new Point3D.Double(r.GetDisplayPoint());
        result.setY((double)rw.GetSize()[1] - result.getY());
        return result;
    }

    public Point3D displayToWorld(Point pt) {
        if (pt == null) {
            return new Point3D.Double();
        }
        return this.displayToWorld(pt.x, pt.y);
    }

    public Point3D displayToWorld(int x, int y) {
        double[] fp = this.camera.GetFocalPoint();
        Point3D displayFP = this.worldToDisplay(fp[0], fp[1], fp[2]);
        return this.displayToWorld(x, y, displayFP.getZ());
    }

    public Point3D displayToWorld(Point pt, double z) {
        if (pt == null) {
            return new Point3D.Double();
        }
        return this.displayToWorld(pt.getX(), pt.getY(), z);
    }

    public Point3D displayToWorld(double x, double y, double z) {
        vtkRenderer r = this.getRenderer();
        vtkRenderWindow rw = this.getRenderWindow();
        if (r == null || rw == null) {
            return new Point3D.Double();
        }
        r.SetDisplayPoint(x, (double)rw.GetSize()[1] - y, z);
        r.DisplayToWorld();
        double[] result = r.GetWorldPoint();
        if (result[3] != 0.0) {
            result[0] = result[0] / result[3];
            result[1] = result[1] / result[3];
            result[2] = result[2] / result[3];
        } else {
            result[0] = 0.0;
            result[1] = 0.0;
            result[2] = 0.0;
        }
        return new Point3D.Double(result[0], result[1], result[2]);
    }

    public Point imageToCanvas(double x, double y, double z) {
        double[] scaling = this.getVolumeScale();
        Point3D result = this.worldToDisplay(x * scaling[0], y * scaling[1], z * scaling[2]);
        return new Point((int)result.getX(), (int)result.getY());
    }

    public Point3D.Double canvasToImage(int x, int y) {
        double[] scaling;
        for (double d : scaling = this.getVolumeScale()) {
            if (d != 0.0) continue;
            return new Point3D.Double();
        }
        Point3D result = this.displayToWorld(x, y);
        double[] directionOfProjection = this.getCamera().GetDirectionOfProjection();
        double dirX = Math.abs(directionOfProjection[0]);
        double dirY = Math.abs(directionOfProjection[1]);
        double dirZ = Math.abs(directionOfProjection[2]);
        if (dirX > dirY) {
            if (dirX > dirZ) {
                result.setX(Double.NaN);
            } else {
                result.setZ(Double.NaN);
            }
        } else if (dirY > dirZ) {
            result.setY(Double.NaN);
        } else {
            result.setZ(Double.NaN);
        }
        result = new Point3D.Double(result.getX() / scaling[0], result.getY() / scaling[1], result.getZ() / scaling[2]);
        return (Point3D.Double)result;
    }

    @Deprecated
    protected vtkProp[] getLayerActors(Layer layer) {
        return VtkUtil.getLayerProps((Layer)layer);
    }

    protected void addLayerActors(Layer layer) {
        if (this.overlayUpdater == null) {
            return;
        }
        this.overlayUpdater.addProps(VtkUtil.getLayerProps((Layer)layer));
    }

    protected void removeLayerActors(Layer layer) {
        if (this.overlayUpdater == null) {
            return;
        }
        this.overlayUpdater.removeProps(VtkUtil.getLayerProps((Layer)layer));
    }

    protected void addLayersActors(List<Layer> layers) {
        if (this.overlayUpdater == null) {
            return;
        }
        this.overlayUpdater.addProps(VtkUtil.getLayersProps(layers));
    }

    protected void updateBoundingBoxSize() {
        double[] bounds = this.imageVolume.getVolume().GetBounds();
        this.boundingBox.SetBounds(bounds);
        this.rulerBox.SetBounds(bounds);
    }

    protected vtkImageData getImageData() {
        try {
            return VtkUtil.getImageData((Sequence)this.getSequence(), (int)this.getPositionT(), (int)this.getPositionC());
        }
        catch (TooLargeArrayException e) {
            return null;
        }
        catch (OutOfMemoryError e) {
            return null;
        }
    }

    protected void updateImageData(vtkImageData data) {
        if (data != null) {
            this.imageVolume.setVolumeData(data);
            this.imageVolume.getVolume().SetVisibility(this.getImageLayer().isVisible() ? 1 : 0);
            if (this.textInfo != null) {
                this.textInfo.SetVisibility(0);
            }
        } else {
            Sequence seq;
            this.imageVolume.getVolume().SetVisibility(0);
            if (this.textInfo != null && (seq = this.getSequence()) != null && !seq.isEmpty()) {
                this.textInfo.SetVisibility(1);
            }
        }
    }

    protected void updateLut() {
        LUT lut = this.getLut();
        for (int c = 0; c < lut.getNumChannel(); ++c) {
            this.updateLut(lut.getLutChannel(c), c);
        }
    }

    protected void updateLut(LUT.LUTChannel lutChannel, int channel) {
        Sequence sequence = this.getSequence();
        if (sequence == null || sequence.isEmpty()) {
            return;
        }
        int ch = channel;
        vtkColorTransferFunction colorMap = VtkUtil.getColorMap((LUT.LUTChannel)lutChannel);
        vtkPiecewiseFunction opacityMap = VtkUtil.getOpacityMap((LUT.LUTChannel)lutChannel);
        this.imageVolume.setColorMap(colorMap, ch);
        this.imageVolume.setOpacityMap(opacityMap, ch);
    }

    public Component getViewComponent() {
        return this.getVtkPanel();
    }

    public IcyVtkPanel getVtkPanel() {
        return this.panel3D;
    }

    @Deprecated
    public IcyVtkPanel getPanel3D() {
        return this.getVtkPanel();
    }

    public vtkRenderer getRenderer() {
        return this.renderer;
    }

    public vtkRenderWindow getRenderWindow() {
        return this.renderWindow;
    }

    public vtkPicker getPicker() {
        return this.panel3D.getPicker();
    }

    public double[] getVolumeScale() {
        return this.imageVolume.getScale();
    }

    public void setVolumeScale(double x, double y, double z) {
        this.propertyChange(PROPERTY_SCALE, new double[]{x, y, z});
    }

    public void keyPressed(KeyEvent e) {
        super.keyPressed(e);
        this.panel3D.keyPressed(e);
        if (!e.isConsumed()) {
            switch (e.getKeyCode()) {
                case 37: {
                    if (EventUtil.isMenuControlDown((InputEvent)e, (boolean)true)) {
                        this.setPositionT(Math.max(this.getPositionT() - 5, 0));
                    } else {
                        this.setPositionT(Math.max(this.getPositionT() - 1, 0));
                    }
                    e.consume();
                    break;
                }
                case 39: {
                    if (EventUtil.isMenuControlDown((InputEvent)e, (boolean)true)) {
                        this.setPositionT(this.getPositionT() + 5);
                    } else {
                        this.setPositionT(this.getPositionT() + 1);
                    }
                    e.consume();
                    break;
                }
                case 98: {
                    if (EventUtil.isMenuControlDown((InputEvent)e, (boolean)true)) {
                        this.panel3D.translateView(0.0, -50.0);
                    } else {
                        this.panel3D.translateView(0.0, -10.0);
                    }
                    this.refresh();
                    e.consume();
                    break;
                }
                case 100: {
                    if (EventUtil.isMenuControlDown((InputEvent)e, (boolean)true)) {
                        this.panel3D.translateView(-50.0, 0.0);
                    } else {
                        this.panel3D.translateView(-10.0, 0.0);
                    }
                    this.refresh();
                    e.consume();
                    break;
                }
                case 102: {
                    if (EventUtil.isMenuControlDown((InputEvent)e, (boolean)true)) {
                        this.panel3D.translateView(50.0, 0.0);
                    } else {
                        this.panel3D.translateView(10.0, 0.0);
                    }
                    this.refresh();
                    e.consume();
                    break;
                }
                case 104: {
                    if (EventUtil.isMenuControlDown((InputEvent)e, (boolean)true)) {
                        this.panel3D.translateView(0.0, 50.0);
                    } else {
                        this.panel3D.translateView(0.0, 10.0);
                    }
                    this.refresh();
                    e.consume();
                }
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        super.keyReleased(e);
        this.panel3D.keyReleased(e);
    }

    protected void setPositionZInternal(int z) {
    }

    protected void setPositionCInternal(int c) {
        if (c != -1) {
            return;
        }
        super.setPositionCInternal(c);
    }

    public double getScaleX() {
        double dist = this.getCamera().GetDistance();
        if (dist <= 0.0) {
            return 1.0;
        }
        double imageSizeX = this.getImageSizeX();
        double result = 2.0 * imageSizeX * this.getVolumeScale()[0] / dist;
        double canvasImageRatio = (double)this.getCanvasSizeX() / (imageSizeX == 0.0 ? 1.0 : imageSizeX);
        return result * canvasImageRatio;
    }

    public double getScaleY() {
        double dist = this.getCamera().GetDistance();
        if (dist <= 0.0) {
            return 1.0;
        }
        double imageSizeY = this.getImageSizeY();
        double result = 2.0 * imageSizeY * this.getVolumeScale()[1] / dist;
        double canvasImageRatio = (double)this.getCanvasSizeY() / (imageSizeY == 0.0 ? 1.0 : imageSizeY);
        return result * canvasImageRatio;
    }

    public void setMouseImagePosX(double value) {
        if (!Double.isNaN(value)) {
            super.setMouseImagePosX(value);
        }
    }

    public void setMouseImagePosY(double value) {
        if (!Double.isNaN(value)) {
            super.setMouseImagePosY(value);
        }
    }

    public void setMouseImagePosZ(double value) {
        if (!Double.isNaN(value)) {
            super.setMouseImagePosZ(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getRenderedImage(int t, int c) {
        final CustomVtkPanel vp = this.panel3D;
        if (vp == null) {
            return null;
        }
        int prevT = this.getPositionT();
        int prevC = this.getPositionC();
        this.setPositionT(t);
        this.setPositionC(c);
        try {
            final vtkImageData imageData = this.getImageData();
            this.invokeOnEDTSilent(new Runnable(){

                @Override
                public void run() {
                    VtkCanvas.this.updateImageData(imageData);
                    vp.setForceFineRendering(true);
                    try {
                        vp.paint(vp.getGraphics());
                    }
                    finally {
                        vp.setForceFineRendering(false);
                    }
                }
            });
            try {
                Robot robot = new Robot();
                Rectangle bounds = vp.getBounds();
                bounds.setLocation(ComponentUtil.convertPointToScreen((Point)bounds.getLocation(), (Component)((Object)vp)));
                BufferedImage bufferedImage = robot.createScreenCapture(bounds);
                return bufferedImage;
            }
            catch (AWTException e) {
                IcyExceptionHandler.showErrorMessage(e, true);
                BufferedImage bufferedImage = null;
                this.setPositionT(prevT);
                this.setPositionC(prevC);
                return bufferedImage;
            }
        }
        finally {
            this.setPositionT(prevT);
            this.setPositionC(prevC);
        }
    }

    public BufferedImage getRenderedImage(int t, int z, int c, boolean canvasView) {
        if (z != -1) {
            throw new UnsupportedOperationException("Error: getRenderedImage(..) with z != -1 not supported on Canvas3D.");
        }
        if (!canvasView) {
            System.out.println("Warning: getRenderedImage(..) with canvasView = false not supported on Canvas3D.");
        }
        return this.getRenderedImage(t, c);
    }

    protected void invokeOnEDT(Runnable task) throws InterruptedException {
        if (this.edtTask == null) {
            task.run();
            return;
        }
        this.edtTask.setTask(task);
        try {
            ThreadUtil.invokeNow(this.edtTask);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception t) {
            System.out.println("[VTKCanvas] Warning:" + t);
        }
    }

    protected void invokeOnEDTSilent(Runnable task) {
        try {
            this.invokeOnEDT(task);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void changed(IcyCanvasEvent event) {
        super.changed(event);
        if (!this.initialized) {
            return;
        }
        if (event.getType() == IcyCanvasEvent.IcyCanvasEventType.POSITION_CHANGED) {
            switch (event.getDim()) {
                case C: {
                    this.propertyChange(PROPERTY_DATA, null);
                    this.refresh();
                    break;
                }
                case T: {
                    this.propertyChange(PROPERTY_DATA, null);
                    this.refresh();
                    break;
                }
            }
        }
    }

    protected void lutChanged(int channel) {
        super.lutChanged(channel);
        if (!this.initialized) {
            return;
        }
        this.propertyChange(PROPERTY_LUT, channel);
    }

    protected void sequenceOverlayChanged(Overlay overlay, SequenceEvent.SequenceEventType type) {
        super.sequenceOverlayChanged(overlay, type);
        if (!this.initialized) {
            return;
        }
        this.refresh();
    }

    protected void sequenceDataChanged(IcyBufferedImage image, SequenceEvent.SequenceEventType type) {
        super.sequenceDataChanged(image, type);
        this.propertyChange(PROPERTY_DATA, null);
        this.propertyChange(PROPERTY_BOUNDS, null);
    }

    protected void sequenceMetaChanged(String metadataName) {
        super.sequenceMetaChanged(metadataName);
        Sequence sequence = this.getSequence();
        if (sequence == null || sequence.isEmpty()) {
            return;
        }
        if (StringUtil.isEmpty(metadataName) || StringUtil.equals(metadataName, "pixelSizeX") || StringUtil.equals(metadataName, "pixelSizeY") || StringUtil.equals(metadataName, "pixelSizeZ")) {
            this.setVolumeScale(sequence.getPixelSizeX(), sequence.getPixelSizeY(), sequence.getPixelSizeZ());
        }
    }

    protected void layerChanged(CanvasLayerEvent event) {
        String propertyName;
        super.layerChanged(event);
        if (!this.initialized) {
            return;
        }
        if (event.getType() == CanvasLayerEvent.LayersEventType.CHANGED && ((propertyName = event.getProperty()).equals("opacity") || propertyName.equals("visible"))) {
            this.propertyChange("layersVisible", event.getSource());
        }
    }

    protected void layerAdded(Layer layer) {
        super.layerAdded(layer);
        this.addLayerActors(layer);
    }

    protected void layerRemoved(Layer layer) {
        super.layerRemoved(layer);
        this.removeLayerActors(layer);
    }

    protected void layersVisibleChanged() {
        this.propertyChange("layersVisible", null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.axesButton) {
            this.propertyChange("axis", this.axesButton.isSelected());
        } else if (source == this.boundingBoxButton) {
            this.propertyChange("boundingBox", this.boundingBoxButton.isSelected());
        } else if (source == this.gridButton) {
            this.propertyChange("boundingBoxGrid", this.gridButton.isSelected());
        } else if (source == this.rulerButton) {
            this.propertyChange("boundingBoxRules", this.rulerButton.isSelected());
        } else if (source == this.rulerLabelButton) {
            this.propertyChange("boundingBoxLabels", this.rulerLabelButton.isSelected());
        }
    }

    protected void propertyChange(String name, Object value) {
        if (this.propertiesUpdater == null) {
            return;
        }
        Property prop = new Property(name, value);
        this.propertiesUpdater.submit(prop);
    }

    public void settingChange(PropertyChangeEvent evt) {
        this.propertyChange(evt.getPropertyName(), evt.getNewValue());
    }

    public boolean isSynchronizationSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void synchronizeCanvas(List<IcyCanvas> canvasList, IcyCanvasEvent event, boolean processAll) {
        block14: {
            IcyCanvasEvent.IcyCanvasEventType type = event.getType();
            DimensionId dim = event.getDim();
            if (this.isSynchOnSlice() && (processAll || type == IcyCanvasEvent.IcyCanvasEventType.POSITION_CHANGED)) {
                if (processAll || dim == DimensionId.NULL) {
                    int t = this.getPositionT();
                    for (IcyCanvas cnv : canvasList) {
                        if (t == -1) continue;
                        cnv.setPositionT(t);
                    }
                } else {
                    for (IcyCanvas cnv : canvasList) {
                        int pos = this.getPosition(dim);
                        if (pos == -1) continue;
                        cnv.setPosition(dim, pos);
                    }
                }
            }
            if (this.isSynchOnView()) {
                vtkRenderer ren = this.getRenderer();
                double[] worldPoint = ren.GetWorldPoint();
                double[] displayPoint = ren.GetDisplayPoint();
                vtkCamera cam = this.getCamera();
                double[] pos = cam.GetPosition();
                double[] dir = cam.GetFocalPoint();
                double[] viewUp = cam.GetViewUp();
                int parallelProjection = cam.GetParallelProjection();
                double viewAngle = cam.GetViewAngle();
                for (IcyCanvas canvas : canvasList) {
                    VtkCanvas canvasVtk = (VtkCanvas)canvas;
                    canvasVtk.beginUpdate();
                    canvasVtk.getVtkPanel().lock();
                    try {
                        vtkRenderer canvasRen = canvasVtk.getRenderer();
                        vtkCamera canvasCam = canvasVtk.getCamera();
                        canvasRen.SetWorldPoint(worldPoint);
                        canvasRen.SetDisplayPoint(displayPoint);
                        canvasCam.SetFocalPoint(dir);
                        canvasCam.SetPosition(pos);
                        canvasCam.SetViewUp(viewUp);
                        canvasCam.SetParallelProjection(parallelProjection);
                        canvasCam.SetViewAngle(viewAngle);
                        canvasRen.ResetCameraClippingRange();
                        if (!canvasVtk.panel3D.getLightFollowCamera()) continue;
                        IcyVtkPanel.setLightToCameraPosition(canvasVtk.panel3D.getLight(), canvasCam);
                    }
                    finally {
                        canvasVtk.panel3D.updateAxisView();
                        canvasVtk.getVtkPanel().unlock();
                        canvasVtk.endUpdate();
                        canvasVtk.getVtkPanel().repaint();
                    }
                }
            }
            if (!this.isSynchOnCursor() || !processAll && type != IcyCanvasEvent.IcyCanvasEventType.MOUSE_IMAGE_POSITION_CHANGED) break block14;
            if (processAll || dim == DimensionId.NULL) {
                double mouseImagePosX = this.getMouseImagePosX();
                double mouseImagePosY = this.getMouseImagePosY();
                double mouseImagePosZ = this.getMouseImagePosZ();
                for (IcyCanvas cnv : canvasList) {
                    ((VtkCanvas)cnv).setMouseImagePos(mouseImagePosX, mouseImagePosY, mouseImagePosZ);
                }
            } else {
                for (IcyCanvas cnv : canvasList) {
                    cnv.setMouseImagePos(dim, this.getMouseImagePos(dim));
                }
            }
        }
    }

    protected class VtkOverlayUpdater
    extends Thread {
        final LinkedList<vtkProp> propToAdd;
        final LinkedList<vtkProp> propToRemove;

        public VtkOverlayUpdater() {
            super("VTK canvas overlay updater");
            this.propToAdd = new LinkedList();
            this.propToRemove = new LinkedList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addProp(vtkProp prop) {
            LinkedList<vtkProp> linkedList = this.propToAdd;
            synchronized (linkedList) {
                this.propToAdd.add(prop);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeProp(vtkProp prop) {
            LinkedList<vtkProp> linkedList = this.propToRemove;
            synchronized (linkedList) {
                this.propToRemove.add(prop);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addProps(List<vtkProp> props) {
            LinkedList<vtkProp> linkedList = this.propToAdd;
            synchronized (linkedList) {
                this.propToAdd.addAll(props);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeProps(List<vtkProp> props) {
            LinkedList<vtkProp> linkedList = this.propToRemove;
            synchronized (linkedList) {
                this.propToRemove.addAll(props);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addProps(vtkProp[] props) {
            LinkedList<vtkProp> linkedList = this.propToAdd;
            synchronized (linkedList) {
                for (vtkProp prop : props) {
                    this.propToAdd.add(prop);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeProps(vtkProp[] props) {
            LinkedList<vtkProp> linkedList = this.propToAdd;
            synchronized (linkedList) {
                for (vtkProp prop : props) {
                    this.propToRemove.add(prop);
                }
            }
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                while (!this.isInterrupted() && !this.propToAdd.isEmpty()) {
                    VtkCanvas.this.invokeOnEDTSilent(new Runnable(){

                        @Override
                        public void run() {
                            vtkRenderer r = VtkCanvas.this.getRenderer();
                            vtkCamera cam = VtkCanvas.this.getCamera();
                            int done = 0;
                            if (r != null && cam != null) {
                                while (!VtkOverlayUpdater.this.propToAdd.isEmpty() && done++ < 1000) {
                                    vtkProp prop = VtkOverlayUpdater.this.propToAdd.removeFirst();
                                    if (r.HasViewProp(prop) != 0) continue;
                                    if (prop instanceof vtkCubeAxesActor) {
                                        ((vtkCubeAxesActor)prop).SetCamera(cam);
                                    }
                                    r.AddViewProp(prop);
                                }
                            }
                        }
                    });
                    ThreadUtil.sleep(10);
                    VtkCanvas.this.refresh();
                }
                while (!this.isInterrupted() && !this.propToRemove.isEmpty()) {
                    VtkCanvas.this.invokeOnEDTSilent(new Runnable(){

                        @Override
                        public void run() {
                            vtkRenderer r = VtkCanvas.this.getRenderer();
                            vtkCamera cam = VtkCanvas.this.getCamera();
                            int done = 0;
                            if (r != null && cam != null) {
                                while (!VtkOverlayUpdater.this.propToRemove.isEmpty() && done++ < 1000) {
                                    r.RemoveViewProp(VtkOverlayUpdater.this.propToRemove.removeFirst());
                                }
                            }
                        }
                    });
                    ThreadUtil.sleep(10);
                    VtkCanvas.this.refresh();
                }
                ThreadUtil.sleep(1);
            }
            this.propToAdd.clear();
            this.propToRemove.clear();
        }
    }

    protected class PropertiesUpdater
    extends Thread {
        final LinkedBlockingQueue<Property> toUpdate;

        public PropertiesUpdater() {
            super("VTK canvas properties updater");
            this.toUpdate = new LinkedBlockingQueue(256);
        }

        public synchronized void submit(Property prop) {
            if (this.toUpdate.remove(prop) && prop.name.equals("layersVisible")) {
                prop.value = null;
            }
            this.toUpdate.add(prop);
        }

        protected void updateProperty(Property prop) throws InterruptedException {
            String name = prop.name;
            Object value = prop.value;
            if (StringUtil.equals(name, VtkCanvas.ID_AMBIENT)) {
                final double d = (Double)value;
                VtkCanvas.this.invokeOnEDT(new Runnable(){

                    @Override
                    public void run() {
                        VtkCanvas.this.imageVolume.setAmbient(d);
                    }
                });
                VtkCanvas.this.preferences.putDouble(VtkCanvas.ID_AMBIENT, d);
            } else if (StringUtil.equals(name, VtkCanvas.ID_DIFFUSE)) {
                final double d = (Double)value;
                VtkCanvas.this.invokeOnEDT(new Runnable(){

                    @Override
                    public void run() {
                        VtkCanvas.this.imageVolume.setDiffuse(d);
                    }
                });
                VtkCanvas.this.preferences.putDouble(VtkCanvas.ID_DIFFUSE, d);
            } else if (StringUtil.equals(name, VtkCanvas.ID_SPECULAR)) {
                final double d = (Double)value;
                VtkCanvas.this.invokeOnEDT(new Runnable(){

                    @Override
                    public void run() {
                        VtkCanvas.this.imageVolume.setSpecular(d);
                    }
                });
                VtkCanvas.this.preferences.putDouble(VtkCanvas.ID_SPECULAR, d);
            } else if (StringUtil.equals(name, VtkCanvas.ID_BGCOLOR)) {
                final Color color = (Color)value;
                VtkCanvas.this.invokeOnEDT(new Runnable(){

                    @Override
                    public void run() {
                        VtkCanvas.this.setBackgroundColorInternal(color);
                    }
                });
                VtkCanvas.this.preferences.putInt(VtkCanvas.ID_BGCOLOR, color.getRGB());
            } else if (StringUtil.equals(name, VtkCanvas.ID_INTERPOLATION)) {
                final int i = (Integer)value;
                VtkCanvas.this.invokeOnEDT(new Runnable(){

                    @Override
                    public void run() {
                        VtkCanvas.this.imageVolume.setInterpolationMode(i);
                    }
                });
                VtkCanvas.this.preferences.putInt(VtkCanvas.ID_INTERPOLATION, i);
            } else if (StringUtil.equals(name, VtkCanvas.ID_MAPPER)) {
                final boolean gpuRendering = (Boolean)value;
                VtkCanvas.this.invokeOnEDT(new Runnable(){

                    @Override
                    public void run() {
                        VtkCanvas.this.imageVolume.setGPURendering(gpuRendering);
                    }
                });
                VtkCanvas.this.preferences.putInt(VtkCanvas.ID_MAPPER, gpuRendering ? 1 : 0);
            } else if (StringUtil.equals(name, VtkCanvas.ID_BLENDING)) {
                final VtkImageVolume.VtkVolumeBlendType type = (VtkImageVolume.VtkVolumeBlendType)((Object)value);
                VtkCanvas.this.invokeOnEDT(new Runnable(){

                    @Override
                    public void run() {
                        VtkCanvas.this.imageVolume.setBlendingMode(type);
                    }
                });
                VtkCanvas.this.preferences.putInt(VtkCanvas.ID_BLENDING, VtkCanvas.this.getVolumeBlendingMode().ordinal());
            } else if (StringUtil.equals(name, VtkCanvas.ID_SAMPLE)) {
                final int i = (Integer)value;
                VtkCanvas.this.invokeOnEDT(new Runnable(){

                    @Override
                    public void run() {
                        VtkCanvas.this.imageVolume.setSampleResolution(i);
                    }
                });
                VtkCanvas.this.preferences.putDouble(VtkCanvas.ID_SAMPLE, i);
            } else if (StringUtil.equals(name, "axis")) {
                final boolean b = (Boolean)value;
                VtkCanvas.this.invokeOnEDT(new Runnable(){

                    @Override
                    public void run() {
                        VtkCanvas.this.panel3D.setAxisOrientationDisplayEnable(b);
                    }
                });
                VtkCanvas.this.preferences.putBoolean("axis", b);
            } else if (StringUtil.equals(name, "boundingBox")) {
                final boolean b = (Boolean)value;
                VtkCanvas.this.invokeOnEDT(new Runnable(){

                    @Override
                    public void run() {
                        VtkCanvas.this.boundingBox.SetVisibility(b ? 1 : 0);
                    }
                });
                VtkCanvas.this.preferences.putBoolean("boundingBox", b);
            } else if (StringUtil.equals(name, "boundingBoxGrid")) {
                final boolean b = (Boolean)value;
                VtkCanvas.this.invokeOnEDT(new Runnable(){

                    @Override
                    public void run() {
                        VtkCanvas.this.rulerBox.SetDrawXGridlines(b ? 1 : 0);
                        VtkCanvas.this.rulerBox.SetDrawYGridlines(b ? 1 : 0);
                        VtkCanvas.this.rulerBox.SetDrawZGridlines(b ? 1 : 0);
                    }
                });
                VtkCanvas.this.preferences.putBoolean("boundingBoxGrid", b);
            } else if (StringUtil.equals(name, "boundingBoxRules")) {
                final boolean b = (Boolean)value;
                VtkCanvas.this.invokeOnEDT(new Runnable(){

                    @Override
                    public void run() {
                        VtkCanvas.this.rulerBox.SetXAxisVisibility(b ? 1 : 0);
                        VtkCanvas.this.rulerBox.SetXAxisTickVisibility(b ? 1 : 0);
                        VtkCanvas.this.rulerBox.SetXAxisMinorTickVisibility(b ? 1 : 0);
                        VtkCanvas.this.rulerBox.SetYAxisVisibility(b ? 1 : 0);
                        VtkCanvas.this.rulerBox.SetYAxisTickVisibility(b ? 1 : 0);
                        VtkCanvas.this.rulerBox.SetYAxisMinorTickVisibility(b ? 1 : 0);
                        VtkCanvas.this.rulerBox.SetZAxisVisibility(b ? 1 : 0);
                        VtkCanvas.this.rulerBox.SetZAxisTickVisibility(b ? 1 : 0);
                        VtkCanvas.this.rulerBox.SetZAxisMinorTickVisibility(b ? 1 : 0);
                    }
                });
                VtkCanvas.this.preferences.putBoolean("boundingBoxRules", b);
            } else if (StringUtil.equals(name, "boundingBoxLabels")) {
                final boolean b = (Boolean)value;
                VtkCanvas.this.invokeOnEDT(new Runnable(){

                    @Override
                    public void run() {
                        VtkCanvas.this.rulerBox.SetXAxisLabelVisibility(b ? 1 : 0);
                        VtkCanvas.this.rulerBox.SetYAxisLabelVisibility(b ? 1 : 0);
                        VtkCanvas.this.rulerBox.SetZAxisLabelVisibility(b ? 1 : 0);
                    }
                });
                VtkCanvas.this.preferences.putBoolean("boundingBoxLabels", b);
            } else if (StringUtil.equals(name, VtkCanvas.ID_SHADING)) {
                final boolean b = (Boolean)value;
                VtkCanvas.this.invokeOnEDT(new Runnable(){

                    @Override
                    public void run() {
                        VtkCanvas.this.imageVolume.setShade(b);
                    }
                });
                VtkCanvas.this.preferences.putBoolean(VtkCanvas.ID_SHADING, b);
            } else if (StringUtil.equals(name, VtkCanvas.PROPERTY_LUT)) {
                VtkCanvas.this.updateLut();
            } else if (StringUtil.equals(name, VtkCanvas.PROPERTY_SCALE)) {
                double[] newScale;
                double[] oldScale = VtkCanvas.this.getVolumeScale();
                if (!Arrays.equals(oldScale, newScale = (double[])value)) {
                    VtkCanvas.this.invokeOnEDT(new Runnable(){

                        @Override
                        public void run() {
                            VtkCanvas.this.imageVolume.setScale(newScale);
                            VtkCanvas.this.updateBoundingBoxSize();
                        }
                    });
                }
            } else if (StringUtil.equals(name, VtkCanvas.PROPERTY_DATA)) {
                final vtkImageData data = VtkCanvas.this.getImageData();
                VtkCanvas.this.invokeOnEDT(new Runnable(){

                    @Override
                    public void run() {
                        VtkCanvas.this.updateImageData(data);
                    }
                });
            } else if (StringUtil.equals(name, VtkCanvas.PROPERTY_BOUNDS)) {
                VtkCanvas.this.invokeOnEDT(new Runnable(){

                    @Override
                    public void run() {
                        VtkCanvas.this.updateBoundingBoxSize();
                    }
                });
            } else if (StringUtil.equals(name, "layersVisible")) {
                VtkCanvas.this.refresh();
            }
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    this.updateProperty(this.toUpdate.take());
                }
                catch (InterruptedException e) {
                    break;
                }
                if (!this.toUpdate.isEmpty()) continue;
                VtkCanvas.this.refresh();
            }
            this.toUpdate.clear();
        }
    }

    protected static class Property {
        String name;
        Object value;

        public Property(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Property) {
                return this.name.equals(((Property)obj).name);
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    protected class VtkCanvasImageOverlay
    extends IcyCanvas.IcyCanvasImageOverlay
    implements VtkPainter {
        public VtkCanvasImageOverlay() {
            super((IcyCanvas)VtkCanvas.this);
            VtkCanvas.this.imageVolume = new VtkImageVolume();
        }

        public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
        }

        public vtkProp[] getProps() {
            return new vtkProp[]{VtkCanvas.this.imageVolume.getVolume()};
        }
    }

    protected class CustomVtkPanel
    extends IcyVtkPanel {
        private static final long serialVersionUID = -7399887230624608711L;
        long lastRefreshTime = 0L;
        boolean forceFineRendering = false;

        public CustomVtkPanel() {
            this.removeKeyListener(this);
        }

        public boolean getForceFineRendering() {
            return this.forceFineRendering;
        }

        public void setForceFineRendering(boolean value) {
            this.forceFineRendering = value;
        }

        protected void updateCursor(boolean consumedByCanvas) {
            if (this.getCursor().getType() == -1) {
                return;
            }
            if (consumedByCanvas) {
                GuiUtil.setCursor((Component)((Object)this), (int)12);
                return;
            }
            Sequence seq = VtkCanvas.this.getSequence();
            if (seq != null) {
                Layer layer;
                ROI overlappedRoi = seq.getFocusedROI();
                if (overlappedRoi != null && (layer = VtkCanvas.this.getLayer(overlappedRoi)) != null && layer.isVisible()) {
                    GuiUtil.setCursor((Component)((Object)this), (int)12);
                    return;
                }
                ArrayList selectedRois = seq.getSelectedROIs();
                for (ROI selectedRoi : selectedRois) {
                    Layer layer2 = VtkCanvas.this.getLayer(selectedRoi);
                    if (layer2 == null || !layer2.isVisible() || !selectedRoi.hasSelectedPoint()) continue;
                    GuiUtil.setCursor((Component)((Object)this), (int)12);
                    return;
                }
            }
            GuiUtil.setCursor((Component)((Object)this), (int)0);
        }

        @Override
        public void paint(Graphics g) {
            if (this.forceFineRendering) {
                this.setFineRendering();
            } else if (this.lastRefreshTime != 0L && System.currentTimeMillis() - this.lastRefreshTime < 250L) {
                this.setCoarseRendering(1000L);
            }
            this.paintLayers(VtkCanvas.this.getLayers(true), VtkCanvas.this.getImageLayer(), VtkCanvas.this.getSequence());
            super.paint(g);
            this.lastRefreshTime = System.currentTimeMillis();
        }

        protected void paintLayers(List<Layer> sortedLayers, Layer imageLayer, Sequence seq) {
            boolean lv = VtkCanvas.this.isLayersVisible();
            for (int i = sortedLayers.size() - 1; i >= 0; --i) {
                Layer layer = sortedLayers.get(i);
                if (layer == null) continue;
                for (vtkProp prop : VtkUtil.getLayerProps((Layer)layer)) {
                    if (layer == imageLayer) {
                        if (layer.isVisible() && seq != null && !seq.isEmpty()) {
                            prop.SetVisibility(1);
                        } else {
                            prop.SetVisibility(0);
                        }
                    } else {
                        boolean visible = lv && layer.isVisible();
                        vtkInformation vtkInfo = prop.GetPropertyKeys();
                        if (vtkInfo != null && vtkInfo.Has(visibilityKey) != 0 && vtkInfo.Get(visibilityKey) == 0) {
                            visible = false;
                        }
                        prop.SetVisibility(visible ? 1 : 0);
                    }
                    if (prop instanceof vtkActor) {
                        ((vtkActor)prop).GetProperty().SetOpacity((double)layer.getOpacity());
                        continue;
                    }
                    if (!(prop instanceof vtkActor2D)) continue;
                    ((vtkActor2D)prop).GetProperty().SetOpacity((double)layer.getOpacity());
                }
                if (!lv || !layer.isVisible()) continue;
                layer.getOverlay().paint(null, seq, (IcyCanvas)VtkCanvas.this);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            VtkCanvas.this.mouseEntered(e, VtkCanvas.this.getMouseImagePos5D());
            super.mouseEntered(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            VtkCanvas.this.mouseExited(e, VtkCanvas.this.getMouseImagePos5D());
            super.mouseExited(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            VtkCanvas.this.mouseClick(e, VtkCanvas.this.getMouseImagePos5D());
            super.mouseClicked(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            VtkCanvas.this.setMousePos(e.getPoint());
            VtkCanvas.this.pickedObject = this.pick(e.getX(), e.getY());
            VtkCanvas.this.mouseMove(e, VtkCanvas.this.getMouseImagePos5D());
            boolean consumed = e.isConsumed();
            super.mouseMoved(e);
            VtkCanvas.this.mouseImagePositionChanged(DimensionId.NULL);
            this.updateCursor(!consumed && e.isConsumed());
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            VtkCanvas.this.setMousePos(e.getPoint());
            VtkCanvas.this.pickedObject = this.pick(e.getX(), e.getY());
            VtkCanvas.this.mouseDrag(e, VtkCanvas.this.getMouseImagePos5D());
            boolean consumed = e.isConsumed();
            super.mouseDragged(e);
            this.updateCursor(!consumed && e.isConsumed());
        }

        @Override
        public void mousePressed(MouseEvent e) {
            VtkCanvas.this.mousePressed(e, VtkCanvas.this.getMouseImagePos5D());
            super.mousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            VtkCanvas.this.mouseReleased(e, VtkCanvas.this.getMouseImagePos5D());
            super.mouseReleased(e);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            VtkCanvas.this.mouseWheelMoved(e, VtkCanvas.this.getMouseImagePos5D());
            super.mouseWheelMoved(e);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (!e.isConsumed()) {
                switch (e.getKeyCode()) {
                    case 82: {
                        this.resetCamera();
                        if (EventUtil.isShiftDown((InputEvent)e, (boolean)true)) {
                            Sequence sequence = VtkCanvas.this.getSequence();
                            Viewer viewer = VtkCanvas.this.getViewer();
                            if (viewer != null && sequence != null) {
                                LUT lut = sequence.createCompatibleLUT();
                                lut.setAlphaToLinear3D();
                                viewer.setLut(lut);
                            }
                        } else {
                            this.repaint();
                        }
                        e.consume();
                    }
                }
            }
            super.keyPressed(e);
        }

        @Override
        public void zoomView(vtkCamera c, vtkRenderer r, double factor) {
            super.zoomView(c, r, factor);
            VtkCanvas.this.scaleChanged(DimensionId.NULL);
        }

        @Override
        public void rotateView(vtkCamera c, vtkRenderer r, int dx, int dy) {
            super.rotateView(c, r, dx, dy);
            VtkCanvas.this.rotationChanged(DimensionId.NULL);
        }

        @Override
        public void translateView(vtkCamera c, vtkRenderer r, double dx, double dy) {
            super.translateView(c, r, dx, dy);
            VtkCanvas.this.positionChanged(DimensionId.NULL);
        }
    }

    protected class EDTTask<T>
    implements Callable<T> {
        protected Runnable task;

        protected EDTTask() {
        }

        public void setTask(Runnable task) {
            this.task = task;
        }

        @Override
        public T call() throws Exception {
            this.task.run();
            return null;
        }
    }
}

