/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th&#233;venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C&#233;dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     Cl&#233;ment Marti (clement.marti@epfl.ch)
 *     Julien Jacquemot (julien.jacquemot@epfl.ch)
 ******************************************************************************/
package plugins.big.bigsnake.gui;

import icy.gui.frame.IcyFrame;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

import plugins.big.bigsnake.BIGSnake;
import plugins.big.bigsnake.core.Settings;
import plugins.big.bigsnakeutils.system.OpenBrowser;

/**
 * Frame that contains the plug-in user interface.
 * 
 * @version May 3, 2014
 * 
 * @author Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 */
public class PlugInFrame extends IcyFrame implements ActionListener {

	/** Menu bar of the frame. */
	private final JMenuBar menuBar_ = new JMenuBar();

	/** File menu in the menu bar. */
	private final JMenu fileMenu_ = new JMenu("File");
	/** Save item in the file menu. */
	private final JMenuItem saveMenuItem_ = new JMenuItem("Save");
	/** Load item in the file menu. */
	private final JMenuItem loadMenuItem_ = new JMenuItem("Load");

	/** Analyze menu in the menu bar. */
	private final JMenu analyzeMenu_ = new JMenu("Analyze");
	/** Measure item in the analyze menu. */
	private final JMenuItem measureMenuItem_ = new JMenuItem("Measure");

	/** Help menu in the menu bar. */
	private final JMenu helpMenu_ = new JMenu("Help");
	/** Documentation item in the help menu. */
	private final JMenuItem documentationMenuItem_ = new JMenuItem(
			"Documentation (online)");
	/** About item in the help menu. */
	private final JMenuItem aboutMenuItem_ = new JMenuItem("About");

	/** Plug-in. */
	private BIGSnake bigSnakePlugin_ = null;

	// ============================================================================
	// PUBLIC METHODS

	/** Constructor. */
	public PlugInFrame(BIGSnake bigSnakePlugin) {
		super("", false, true);
		Settings settings = Settings.getInstance();
		setTitle(settings.getAppName() + " " + settings.getAppVersion());
		settings.setWindowIcon(this);

		bigSnakePlugin_ = bigSnakePlugin;

		setJMenuBar(menuBar_);
		menuBar_.add(fileMenu_);
		fileMenu_.add(loadMenuItem_);
		fileMenu_.add(saveMenuItem_);

		menuBar_.add(analyzeMenu_);
		analyzeMenu_.add(measureMenuItem_);

		menuBar_.add(helpMenu_);
		helpMenu_.add(documentationMenuItem_);
		helpMenu_.add(aboutMenuItem_);

		loadMenuItem_.addActionListener(this);
		saveMenuItem_.addActionListener(this);
		measureMenuItem_.addActionListener(this);
		documentationMenuItem_.addActionListener(this);
		aboutMenuItem_.addActionListener(this);
	}

	// ----------------------------------------------------------------------------

	/** Closes frame and terminates plug-in. */
	@Override
	public void onClosed() {
		bigSnakePlugin_.terminatePlugin();
		super.onClosed();
	}

	// ----------------------------------------------------------------------------

	/** Handles the actions created by the menu bar. */
	@Override
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == loadMenuItem_) {
			bigSnakePlugin_.loadSnakesFromXML();
		} else if (e.getSource() == saveMenuItem_) {
			bigSnakePlugin_.saveSnakesToXML();
		} else if (e.getSource() == measureMenuItem_) {
			bigSnakePlugin_.measureSnakes();
		} else if (e.getSource() == documentationMenuItem_) {
			OpenBrowser
					.openURL("http://icy.bioimageanalysis.org/plugin/Active_Cells");
		} else if (e.getSource() == aboutMenuItem_) {
			CreditsPane about = new CreditsPane();
			about.run();
		}
	}
}
