/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.roi3d;

import icy.canvas.IcyCanvas;
import icy.common.CollapsibleEvent;
import icy.gui.inspector.RoisPanel;
import icy.main.Icy;
import icy.roi.BooleanMask2D;
import icy.roi.BooleanMask3D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI3D;
import icy.roi.ROIEvent;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.type.point.Point3D;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle3D;
import icy.util.StringUtil;
import icy.vtk.IcyVtkPanel;
import icy.vtk.VtkUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import plugins.kernel.canvas.VtkCanvas;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi3d.ROI3DStack;
import vtk.vtkActor;
import vtk.vtkImageData;
import vtk.vtkInformation;
import vtk.vtkMapper;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;

public class ROI3DArea
extends ROI3DStack<ROI2DArea> {
    public ROI3DArea() {
        super(ROI2DArea.class);
    }

    public ROI3DArea(Point3D pt) {
        this();
        this.addBrush(pt.toPoint2D(), (int)pt.getZ());
    }

    public ROI3DArea(Point5D pt) {
        this(pt.toPoint3D());
    }

    public ROI3DArea(BooleanMask3D mask) {
        this();
        this.setAsBooleanMask(mask);
    }

    public ROI3DArea(ROI3DArea area) {
        this();
        for (Map.Entry entry : area.slices.entrySet()) {
            this.slices.put(entry.getKey(), new ROI2DArea((ROI2DArea)entry.getValue()));
        }
        this.roiChanged(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROI3DArea(BooleanMask2D mask2d, int zMin, int zMax) {
        this();
        if (zMax < zMin) {
            throw new IllegalArgumentException("ROI3DArea: cannot create the ROI (zMax < zMin).");
        }
        this.beginUpdate();
        try {
            for (int z = zMin; z <= zMax; ++z) {
                this.setSlice(z, new ROI2DArea(mask2d));
            }
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public String getDefaultName() {
        return "Area3D";
    }

    @Override
    protected ROI.ROIPainter createPainter() {
        return new ROI3DAreaPainter();
    }

    public void addPoint(int x, int y, int z) {
        this.setPoint(x, y, z, true);
    }

    public void removePoint(int x, int y, int z) {
        this.setPoint(x, y, z, false);
    }

    public void setPoint(int x, int y, int z, boolean value) {
        ROI2DArea slice = (ROI2DArea)this.getSlice(z, value);
        if (slice != null) {
            slice.setPoint(x, y, value);
        }
    }

    public void addBrush(Point2D pos, int z) {
        ((ROI2DArea)this.getSlice(z, true)).addBrush(pos);
    }

    public void removeBrush(Point2D pos, int z) {
        ROI2DArea slice = (ROI2DArea)this.getSlice(z, false);
        if (slice != null) {
            slice.removeBrush(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(BooleanMask3D mask) {
        this.beginUpdate();
        try {
            for (Map.Entry<Integer, BooleanMask2D> entry : mask.mask.entrySet()) {
                this.add((int)entry.getKey(), entry.getValue());
            }
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public void add(int z, BooleanMask2D maskSlice) {
        if (maskSlice == null) {
            return;
        }
        ROI2DArea currentSlice = (ROI2DArea)this.getSlice(z);
        if (currentSlice != null) {
            currentSlice.add(maskSlice);
        } else {
            this.setSlice(z, new ROI2DArea(maskSlice));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exclusiveAdd(BooleanMask3D mask) {
        this.beginUpdate();
        try {
            for (Map.Entry<Integer, BooleanMask2D> entry : mask.mask.entrySet()) {
                this.exclusiveAdd((int)entry.getKey(), entry.getValue());
            }
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public void exclusiveAdd(int z, BooleanMask2D maskSlice) {
        if (maskSlice == null) {
            return;
        }
        ROI2DArea currentSlice = (ROI2DArea)this.getSlice(z);
        if (currentSlice != null) {
            currentSlice.exclusiveAdd(maskSlice);
            if (currentSlice.isEmpty()) {
                this.removeSlice(z);
            }
        } else {
            this.setSlice(z, new ROI2DArea(maskSlice));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intersect(BooleanMask3D mask) {
        this.beginUpdate();
        try {
            Set<Integer> keys = mask.mask.keySet();
            HashSet<Integer> toRemove = new HashSet<Integer>();
            for (Integer n : this.slices.keySet()) {
                if (keys.contains(n)) continue;
                toRemove.add(n);
            }
            for (Integer n : toRemove) {
                this.removeSlice(n);
            }
            for (Map.Entry entry : mask.mask.entrySet()) {
                this.intersect((int)((Integer)entry.getKey()), (BooleanMask2D)entry.getValue());
            }
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public void intersect(int z, BooleanMask2D maskSlice) {
        if (maskSlice == null) {
            throw new IllegalArgumentException("Cannot intersect an empty slice in a 3D ROI");
        }
        ROI2DArea currentSlice = (ROI2DArea)this.getSlice(z);
        if (currentSlice != null) {
            ROI2DArea roi = new ROI2DArea(maskSlice);
            roi.setT(currentSlice.getT());
            roi.setZ(currentSlice.getZ());
            roi.setC(currentSlice.getC());
            currentSlice.intersect(roi, false);
            if (currentSlice.isEmpty()) {
                this.removeSlice(z);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subtract(BooleanMask3D mask) {
        this.beginUpdate();
        try {
            for (Map.Entry<Integer, BooleanMask2D> entry : mask.mask.entrySet()) {
                this.subtract((int)entry.getKey(), entry.getValue());
            }
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public void subtract(int z, BooleanMask2D maskSlice) {
        if (maskSlice == null) {
            return;
        }
        ROI2DArea currentSlice = (ROI2DArea)this.getSlice(z);
        if (currentSlice != null) {
            currentSlice.subtract(maskSlice);
            if (currentSlice.isEmpty()) {
                this.removeSlice(z);
            }
        }
    }

    @Override
    public ROI add(ROI roi, boolean allowCreate) throws UnsupportedOperationException {
        if (roi instanceof ROI3D) {
            ROI3D roi3d = (ROI3D)roi;
            if (this.getT() == roi3d.getT() && this.getC() == roi3d.getC()) {
                if (roi3d instanceof ROI3DArea) {
                    this.add((ROI3DArea)roi3d);
                } else {
                    this.add(roi3d.getBooleanMask(true));
                }
                return this;
            }
        }
        return super.add(roi, allowCreate);
    }

    @Override
    public ROI exclusiveAdd(ROI roi, boolean allowCreate) throws UnsupportedOperationException {
        if (roi instanceof ROI3D) {
            ROI3D roi3d = (ROI3D)roi;
            if (this.getT() == roi3d.getT() && this.getC() == roi3d.getC()) {
                if (roi3d instanceof ROI3DArea) {
                    this.exclusiveAdd((ROI3DArea)roi3d);
                } else {
                    this.exclusiveAdd(roi3d.getBooleanMask(true));
                }
                return this;
            }
        }
        return super.exclusiveAdd(roi, allowCreate);
    }

    @Override
    public ROI intersect(ROI roi, boolean allowCreate) throws UnsupportedOperationException {
        if (roi instanceof ROI3D) {
            ROI3D roi3d = (ROI3D)roi;
            if (this.getT() == roi3d.getT() && this.getC() == roi3d.getC()) {
                if (roi3d instanceof ROI3DArea) {
                    this.intersect((ROI3DArea)roi3d);
                } else {
                    this.intersect(roi3d.getBooleanMask(true));
                }
                return this;
            }
        }
        return super.intersect(roi, allowCreate);
    }

    @Override
    public ROI subtract(ROI roi, boolean allowCreate) throws UnsupportedOperationException {
        if (roi instanceof ROI3D) {
            ROI3D roi3d = (ROI3D)roi;
            if (this.getT() == roi3d.getT() && this.getC() == roi3d.getC()) {
                if (roi3d instanceof ROI3DArea) {
                    this.subtract((ROI3DArea)roi3d);
                } else {
                    this.subtract(roi3d.getBooleanMask(true));
                }
                return this;
            }
        }
        return super.subtract(roi, allowCreate);
    }

    @Override
    public void setSlice(int z, BooleanMask2D maskSlice) {
        if (maskSlice == null) {
            this.removeSlice(z);
            return;
        }
        this.setSlice(z, new ROI2DArea(maskSlice));
    }

    @Deprecated
    public void setSlice(int z, ROI2D roiSlice, boolean merge) {
        ROI newSlice;
        if (roiSlice == null) {
            throw new IllegalArgumentException("Cannot add an empty slice in a 3D ROI");
        }
        ROI2DArea currentSlice = (ROI2DArea)this.getSlice(z);
        if (currentSlice != null && merge) {
            roiSlice.setZ(z);
            roiSlice.setT(this.getT());
            roiSlice.setC(this.getC());
            newSlice = currentSlice.getUnion(roiSlice);
        } else {
            newSlice = roiSlice;
        }
        if (newSlice instanceof ROI2DArea) {
            this.setSlice(z, (ROI2DArea)newSlice);
        } else if (newSlice instanceof ROI2D) {
            this.setSlice(z, new ROI2DArea(((ROI2D)newSlice).getBooleanMask(true)));
        } else {
            throw new IllegalArgumentException("Can't add the result of the merge operation on 2D slice " + z + ": " + newSlice.getClassName());
        }
    }

    @Override
    public boolean isEmpty() {
        for (ROI2DArea area : this.slices.values()) {
            if (area.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public Point3D[] getEdgePoints() {
        return this.getBooleanMask(true).getContourPoints();
    }

    @Deprecated
    public Point3D[] getPoints() {
        return this.getBooleanMask(true).getPoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void translate(double dx, double dy) {
        this.beginUpdate();
        try {
            for (ROI2DArea slice : this.slices.values()) {
                slice.translate(dx, dy);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public boolean isOverEdge(IcyCanvas canvas, double x, double y, double z) {
        ROI2DArea slice = (ROI2DArea)this.getSlice((int)z);
        if (slice != null) {
            return slice.isOverEdge(canvas, x, y);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPosition2D(Point2D newPosition) {
        this.beginUpdate();
        try {
            for (ROI2DArea slice : this.slices.values()) {
                slice.setPosition2D(newPosition);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void setAsBooleanMask(BooleanMask3D mask) {
        if (mask == null || mask.isEmpty()) {
            this.clear();
        } else {
            Rectangle3D.Integer bounds3d = mask.bounds;
            int startZ = bounds3d.z;
            int sizeZ = bounds3d.sizeZ;
            BooleanMask2D[] masks2d = new BooleanMask2D[sizeZ];
            for (int z = 0; z < sizeZ; ++z) {
                masks2d[z] = mask.getMask2D(startZ + z);
            }
            this.setAsBooleanMask(bounds3d, masks2d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsBooleanMask(Rectangle3D.Integer rect, BooleanMask2D[] mask) {
        if (rect.isInfiniteZ()) {
            throw new IllegalArgumentException("Cannot set infinite Z dimension on the 3D Area ROI.");
        }
        this.beginUpdate();
        try {
            this.clear();
            for (int z = 0; z < rect.sizeZ; ++z) {
                this.setSlice(z + rect.z, new ROI2DArea(mask[z]));
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void upscale() {
        this.setAsBooleanMask(this.getBooleanMask(true).upscale());
    }

    public void downscale(int nbPointForTrue) {
        this.setAsBooleanMask(this.getBooleanMask(true).downscale(nbPointForTrue));
    }

    public void downscale() {
        this.setAsBooleanMask(this.getBooleanMask(true).downscale());
    }

    public void upscale2D() {
        this.setAsBooleanMask(this.getBooleanMask(true).upscale2D());
    }

    public void downscale2D(int nbPointForTrue) {
        this.setAsBooleanMask(this.getBooleanMask(true).downscale2D(nbPointForTrue));
    }

    public void downscale2D() {
        this.setAsBooleanMask(this.getBooleanMask(true).downscale2D());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimizeBounds() {
        Rectangle3D.Integer bounds = this.getBounds();
        this.beginUpdate();
        try {
            for (int z = bounds.z; z < bounds.z + bounds.sizeZ; ++z) {
                ROI2DArea roi = (ROI2DArea)this.getSlice(z);
                if (roi == null) continue;
                if (roi.isEmpty()) {
                    this.removeSlice(z);
                    continue;
                }
                if (!roi.optimizeBounds()) continue;
                roi.roiChanged(true);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public void onChanged(CollapsibleEvent object) {
        ROIEvent event = (ROIEvent)object;
        switch (event.getType()) {
            case ROI_CHANGED: {
                ((ROI3DAreaPainter)this.painter).needRebuild = true;
                break;
            }
            case FOCUS_CHANGED: 
            case SELECTION_CHANGED: {
                ((ROI3DAreaPainter)this.getOverlay()).updateVtkDisplayProperties();
                break;
            }
            case PROPERTY_CHANGED: {
                String property = event.getPropertyName();
                if (!StringUtil.equals(property, "stroke") && !StringUtil.equals(property, "color") && !StringUtil.equals(property, "opacity")) break;
                ((ROI3DAreaPainter)this.getOverlay()).updateVtkDisplayProperties();
                break;
            }
        }
        super.onChanged(object);
    }

    public class ROI3DAreaPainter
    extends ROI3DStack.ROI3DStackPainter
    implements Runnable {
        protected vtkPolyData outline;
        protected vtkPolyDataMapper outlineMapper;
        protected vtkActor outlineActor;
        protected vtkInformation vtkInfo;
        protected vtkPolyData polyData;
        protected vtkPolyDataMapper polyMapper;
        protected vtkActor surfaceActor;
        protected boolean needRebuild;
        protected double[] scaling;
        protected WeakReference<VtkCanvas> canvas3d;

        public ROI3DAreaPainter() {
            super(ROI3DArea.this);
            this.outline = null;
            this.outlineMapper = null;
            this.outlineActor = null;
            this.vtkInfo = null;
            this.polyData = null;
            this.polyMapper = null;
            this.surfaceActor = null;
            this.scaling = new double[3];
            Arrays.fill(this.scaling, 1.0);
            this.needRebuild = true;
            this.canvas3d = new WeakReference<Object>(null);
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (this.surfaceActor != null) {
                this.surfaceActor.Delete();
            }
            if (this.polyMapper != null) {
                this.polyMapper.Delete();
            }
            if (this.polyData != null) {
                this.polyData.GetPointData().GetScalars().Delete();
                this.polyData.GetPointData().Delete();
                this.polyData.Delete();
            }
            if (this.outlineActor != null) {
                this.outlineActor.SetPropertyKeys(null);
                this.outlineActor.Delete();
            }
            if (this.vtkInfo != null) {
                this.vtkInfo.Remove(VtkCanvas.visibilityKey);
                this.vtkInfo.Delete();
            }
            if (this.outlineMapper != null) {
                this.outlineMapper.Delete();
            }
            if (this.outline != null) {
                this.outline.GetPointData().GetScalars().Delete();
                this.outline.GetPointData().Delete();
                this.outline.Delete();
            }
        }

        protected void initVtkObjects() {
            this.outline = VtkUtil.getOutline(0.0, 1.0, 0.0, 1.0, 0.0, 1.0);
            this.outlineMapper = new vtkPolyDataMapper();
            this.outlineMapper.SetInputData(this.outline);
            this.outlineActor = new vtkActor();
            this.outlineActor.SetMapper((vtkMapper)this.outlineMapper);
            this.outlineActor.SetPickable(0);
            this.outlineActor.GetProperty().SetRepresentationToWireframe();
            this.vtkInfo = new vtkInformation();
            this.vtkInfo.Set(VtkCanvas.visibilityKey, 0);
            this.outlineActor.SetPropertyKeys(this.vtkInfo);
            this.polyMapper = new vtkPolyDataMapper();
            this.surfaceActor = new vtkActor();
            this.surfaceActor.SetMapper((vtkMapper)this.polyMapper);
            Color col = this.getColor();
            double r = (double)col.getRed() / 255.0;
            double g = (double)col.getGreen() / 255.0;
            double b = (double)col.getBlue() / 255.0;
            this.outlineActor.GetProperty().SetColor(r, g, b);
            this.surfaceActor.GetProperty().SetColor(r, g, b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void rebuildVtkObjects() {
            VtkCanvas canvas = (VtkCanvas)this.canvas3d.get();
            if (canvas == null) {
                return;
            }
            IcyVtkPanel vtkPanel2 = canvas.getVtkPanel();
            if (vtkPanel2 == null) {
                return;
            }
            Sequence seq = canvas.getSequence();
            if (seq == null) {
                return;
            }
            vtkPolyData previousPolyData = this.polyData;
            vtkImageData imageData = VtkUtil.getBinaryImageData(ROI3DArea.this, seq.getSizeZ(), canvas.getPositionT());
            imageData.SetSpacing(this.scaling[0], this.scaling[1], this.scaling[2]);
            this.polyData = VtkUtil.getSurfaceFromImage(imageData, 0.5);
            Rectangle3D bounds = ROI3DArea.this.getBounds3D();
            bounds.setX(bounds.getX() * this.scaling[0]);
            bounds.setSizeX(bounds.getSizeX() * this.scaling[0]);
            bounds.setY(bounds.getY() * this.scaling[1]);
            bounds.setSizeY(bounds.getSizeY() * this.scaling[1]);
            if (bounds.isInfiniteZ()) {
                bounds.setZ(0.0);
                bounds.setSizeZ((double)seq.getSizeZ() * this.scaling[2]);
            } else {
                bounds.setZ(bounds.getZ() * this.scaling[2]);
                bounds.setSizeZ(bounds.getSizeZ() * this.scaling[2]);
            }
            vtkPanel2.lock();
            try {
                VtkUtil.setOutlineBounds(this.outline, bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY(), bounds.getMinZ(), bounds.getMaxZ(), canvas);
                this.outlineMapper.Update();
                this.polyMapper.SetInputData(this.polyData);
                this.polyMapper.Update();
                this.surfaceActor.SetPosition(bounds.getX(), bounds.getY(), bounds.getZ());
                imageData.GetPointData().GetScalars().Delete();
                imageData.GetPointData().Delete();
                imageData.Delete();
                if (previousPolyData != null) {
                    previousPolyData.GetPointData().GetScalars().Delete();
                    previousPolyData.GetPointData().Delete();
                    previousPolyData.Delete();
                }
            }
            finally {
                vtkPanel2.unlock();
            }
            this.updateVtkDisplayProperties();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateVtkDisplayProperties() {
            IcyVtkPanel vtkPanel2;
            if (this.surfaceActor == null) {
                return;
            }
            VtkCanvas cnv = (VtkCanvas)this.canvas3d.get();
            Color col = this.getDisplayColor();
            double r = (double)col.getRed() / 255.0;
            double g = (double)col.getGreen() / 255.0;
            double b = (double)col.getBlue() / 255.0;
            IcyVtkPanel icyVtkPanel = vtkPanel2 = cnv != null ? cnv.getVtkPanel() : null;
            if (vtkPanel2 != null) {
                vtkPanel2.lock();
            }
            try {
                this.outlineActor.GetProperty().SetColor(r, g, b);
                if (ROI3DArea.this.isSelected()) {
                    this.outlineActor.GetProperty().SetRepresentationToWireframe();
                    this.outlineActor.SetVisibility(1);
                    this.vtkInfo.Set(VtkCanvas.visibilityKey, 1);
                } else {
                    this.outlineActor.GetProperty().SetRepresentationToPoints();
                    this.outlineActor.SetVisibility(0);
                    this.vtkInfo.Set(VtkCanvas.visibilityKey, 0);
                }
                this.surfaceActor.GetProperty().SetColor(r, g, b);
                this.setVtkObjectsColor(col);
            }
            finally {
                if (vtkPanel2 != null) {
                    vtkPanel2.unlock();
                }
            }
            this.painterChanged();
        }

        protected void setVtkObjectsColor(Color color) {
            if (this.outline != null) {
                VtkUtil.setPolyDataColor(this.outline, color, (VtkCanvas)this.canvas3d.get());
            }
            if (this.polyData != null) {
                VtkUtil.setPolyDataColor(this.polyData, color, (VtkCanvas)this.canvas3d.get());
            }
        }

        @Override
        public void mouseClick(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            RoisPanel roiPanel;
            int clickCount;
            if (imagePoint != null) {
                this.mouseClick(e, imagePoint.toPoint2D(), canvas);
            } else {
                this.mouseClick(e, (Point2D)null, canvas);
            }
            if (!e.isConsumed() && ROI3DArea.this.isActiveFor(canvas) && (clickCount = e.getClickCount()) == 2 && ROI3DArea.this.isFocused() && (roiPanel = Icy.getMainInterface().getRoisPanel()) != null) {
                roiPanel.scrollTo(ROI3DArea.this);
                e.consume();
            }
        }

        @Override
        public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            super.paint(g, sequence, canvas);
            if (ROI3DArea.this.isActiveFor(canvas) && canvas instanceof VtkCanvas) {
                double[] s;
                VtkCanvas cnv = (VtkCanvas)canvas;
                if (this.canvas3d.get() != cnv) {
                    this.canvas3d = new WeakReference<VtkCanvas>(cnv);
                }
                if (!Arrays.equals(this.scaling, s = cnv.getVolumeScale())) {
                    this.scaling = s;
                    this.needRebuild = true;
                }
                if (this.needRebuild) {
                    if (this.surfaceActor == null) {
                        this.initVtkObjects();
                    }
                    ThreadUtil.runSingle(this);
                    this.needRebuild = false;
                }
            }
        }

        @Override
        protected boolean updateFocus(InputEvent e, Point5D imagePoint, IcyCanvas canvas) {
            if (canvas instanceof VtkCanvas) {
                boolean focused = this.surfaceActor != null && this.surfaceActor == ((VtkCanvas)canvas).getPickedObject();
                ROI3DArea.this.setFocused(focused);
                return focused;
            }
            return super.updateFocus(e, imagePoint, canvas);
        }

        @Override
        public vtkProp[] getProps() {
            if (this.surfaceActor == null) {
                this.initVtkObjects();
            }
            return new vtkActor[]{this.surfaceActor, this.outlineActor};
        }

        @Override
        public void run() {
            this.rebuildVtkObjects();
        }
    }
}

