/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.MHTracker.LinearProgramming;

import java.util.LinkedList;
import plugins.nchenouard.particletracking.MHTracker.LinearProgramming.SimplexProblem;

public class IncompleteLProblem {
    public double scoreCorrection = 0.0;
    public double previousBestScore = 0.0;
    public int[] fixedValues;
    public SimplexProblem sp;

    public IncompleteLProblem(int[] fixedValues) {
        this.fixedValues = fixedValues;
    }

    public double[] getInitialSizeSolution(double[] x) {
        double[] solution = new double[this.fixedValues.length];
        int cnt = 0;
        for (int i = 0; i < this.fixedValues.length; ++i) {
            if (this.fixedValues[i] == -1) {
                solution[i] = x[cnt];
                ++cnt;
                continue;
            }
            solution[i] = this.fixedValues[i];
        }
        return solution;
    }

    public double getCompleteScore(double[] x) {
        double v = this.scoreCorrection;
        for (int i = 0; i < this.sp.numVariables; ++i) {
            v += this.sp.c[i] * x[i];
        }
        return v;
    }

    public void fixVariable(int idx, int val, SimplexProblem extendSP) {
        int i;
        SimplexProblem problem;
        int cnt = 0;
        for (int i2 = 0; i2 < this.fixedValues.length; ++i2) {
            if (this.fixedValues[i2] != -1) continue;
            if (cnt == idx) {
                this.fixedValues[i2] = val;
                break;
            }
            ++cnt;
        }
        this.sp = problem = new SimplexProblem();
        if (val == 0) {
            // empty if block
        }
        problem.numVariables = extendSP.numVariables - 1;
        problem.c = new double[problem.numVariables];
        for (i = 0; i < idx; ++i) {
            problem.c[i] = extendSP.c[i];
        }
        for (i = idx + 1; i < extendSP.numVariables; ++i) {
            problem.c[i - 1] = extendSP.c[i];
        }
        this.scoreCorrection += (double)val * extendSP.c[idx];
        problem.totalNumConstraints = extendSP.totalNumConstraints;
        LinkedList<Integer> nonEmptyConstraints = new LinkedList<Integer>();
        double[][] modifiedConstraints = new double[problem.totalNumConstraints][];
        double[] modifiedConstraintValue = new double[problem.totalNumConstraints];
        block3: for (int j = 0; j < extendSP.totalNumConstraints; ++j) {
            int i3;
            double[] modifiedC = new double[problem.numVariables];
            for (i3 = 0; i3 < idx; ++i3) {
                modifiedC[i3] = extendSP.A[j][i3];
            }
            for (i3 = idx + 1; i3 < problem.numVariables; ++i3) {
                modifiedC[i3 - 1] = extendSP.A[j][i3];
            }
            modifiedConstraints[j] = modifiedC;
            modifiedConstraintValue[j] = extendSP.b[j] - (double)val * extendSP.A[j][idx];
            for (i3 = 0; i3 < modifiedC.length; ++i3) {
                if (!(modifiedC[i3] > 0.0) && !(modifiedC[i3] < 0.0)) continue;
                nonEmptyConstraints.add(new Integer(j));
                continue block3;
            }
        }
        if (nonEmptyConstraints.size() < problem.totalNumConstraints) {
            problem.A = new double[nonEmptyConstraints.size()][];
            problem.b = new double[nonEmptyConstraints.size()];
            int i4 = 0;
            for (Integer idxN : nonEmptyConstraints) {
                problem.A[i4] = modifiedConstraints[idxN];
                problem.b[i4] = modifiedConstraintValue[idxN];
                ++i4;
            }
            problem.totalNumConstraints = problem.A.length;
        } else {
            problem.A = modifiedConstraints;
            problem.b = modifiedConstraintValue;
        }
    }
}

