/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg;

import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.Vector;

public abstract class VectorSpace {
    protected final int number;

    protected VectorSpace(int number) {
        if (number < 1) {
            throw new IllegalArgumentException("Bad vector space size.");
        }
        this.number = number;
    }

    public final int getNumber() {
        return this.number;
    }

    public abstract Vector create();

    public Vector create(double alpha) {
        Vector vec = this.create();
        this._fill(vec, alpha);
        return vec;
    }

    public Vector one() {
        return this.create(1.0);
    }

    public Vector zero() {
        return this.create(0.0);
    }

    public final boolean owns(Vector vec) {
        return vec != null && vec.belongsTo(this);
    }

    public final void check(Vector vec) throws IncorrectSpaceException {
        if (!this.owns(vec)) {
            throw new IncorrectSpaceException();
        }
    }

    protected abstract double _dot(Vector var1, Vector var2);

    protected abstract double _dot(Vector var1, Vector var2, Vector var3);

    protected double _norm2(Vector x) {
        return Math.sqrt(this._dot(x, x));
    }

    protected abstract double _norm1(Vector var1);

    protected abstract double _normInf(Vector var1);

    protected abstract void _scale(Vector var1, double var2, Vector var4);

    protected void _scale(Vector vec, double alpha) {
        this._scale(vec, alpha, vec);
    }

    protected abstract void _combine(Vector var1, double var2, Vector var4, double var5, Vector var7);

    protected abstract void _combine(Vector var1, double var2, Vector var4, double var5, Vector var7, double var8, Vector var10);

    protected void _add(Vector dst, double alpha, Vector x) {
        this._combine(dst, 1.0, dst, alpha, x);
    }

    protected abstract void _multiply(Vector var1, Vector var2, Vector var3);

    protected void _copy(Vector dst, Vector src) {
        this._combine(dst, 1.0, src, 0.0, src);
    }

    protected abstract void _swap(Vector var1, Vector var2);

    protected Vector _clone(Vector vec) {
        Vector cpy = this.create();
        this._copy(cpy, vec);
        return cpy;
    }

    protected void _zero(Vector vec) {
        this._fill(vec, 0.0);
    }

    protected abstract void _fill(Vector var1, double var2);
}

