/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.util.Tools;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;

public class StackLabeler
implements ExtendedPlugInFilter,
DialogListener {
    private static final String[] formats = new String[]{"0", "0000", "00:00", "00:00:00", "Text", "Label"};
    private static final int NUMBER = 0;
    private static final int ZERO_PADDED_NUMBER = 1;
    private static final int MIN_SEC = 2;
    private static final int HOUR_MIN_SEC = 3;
    private static final int TEXT = 4;
    private static final int LABEL = 5;
    private static int format = (int)Prefs.get("label.format", 0.0);
    private int flags = 31;
    private ImagePlus imp;
    private static int x = 5;
    private static int y = 20;
    private static int fontSize = 18;
    private int maxWidth;
    private Font font;
    private static double start = 0.0;
    private static double interval = 1.0;
    private static String text = "";
    private static int decimalPlaces = 0;
    private static boolean useOverlay;
    private static boolean useTextToolFont;
    private int fieldWidth;
    private Color color;
    private int firstFrame;
    private int lastFrame;
    private int defaultLastFrame;
    private Overlay overlay;
    private Overlay baseOverlay;
    private boolean previewing;
    private boolean virtualStack;
    private int yoffset;

    @Override
    public int setup(String arg, ImagePlus imp) {
        if (imp != null) {
            this.virtualStack = imp.getStack().isVirtual();
            if (this.virtualStack) {
                useOverlay = true;
            }
            this.baseOverlay = imp.getOverlay();
            this.flags += this.virtualStack ? 0 : 32;
            this.firstFrame = 1;
            this.lastFrame = this.defaultLastFrame = imp.getStackSize();
        }
        this.imp = imp;
        return this.flags;
    }

    @Override
    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        ImageProcessor ip = imp.getProcessor();
        Rectangle roi = ip.getRoi();
        if (roi.width < ip.getWidth() || roi.height < ip.getHeight()) {
            x = roi.x;
            y = roi.y + roi.height;
            fontSize = (int)(((double)roi.height - 1.10526) / 0.934211);
            if (fontSize < 7) {
                fontSize = 7;
            }
            if (fontSize > 80) {
                fontSize = 80;
            }
        }
        if (IJ.macroRunning()) {
            format = 0;
            decimalPlaces = 0;
            interval = 1.0;
            text = "";
            start = 0.0;
            useOverlay = false;
            useTextToolFont = false;
            String options = Macro.getOptions();
            if (options != null) {
                if (options.indexOf("interval=0") != -1 && options.indexOf("format=") == -1) {
                    format = 4;
                }
                if (options.indexOf(" slice=") != -1) {
                    options = options.replaceAll(" slice=", " range=");
                    Macro.setOptions(options);
                }
            }
        }
        if (format < 0 || format > 5) {
            format = 0;
        }
        int defaultLastFrame = imp.getStackSize();
        if (imp.isHyperStack()) {
            if (imp.getNFrames() > 1) {
                defaultLastFrame = imp.getNFrames();
            } else if (imp.getNSlices() > 1) {
                defaultLastFrame = imp.getNSlices();
            }
        }
        GenericDialog gd = new GenericDialog("Label Stacks");
        gd.setInsets(2, 5, 0);
        gd.addChoice("Format:", formats, formats[format]);
        gd.addStringField("Starting value:", IJ.d2s(start, decimalPlaces));
        gd.addStringField("Interval:", "" + IJ.d2s(interval, decimalPlaces));
        gd.addNumericField("X location:", x, 0);
        gd.addNumericField("Y location:", y, 0);
        gd.addNumericField("Font size:", fontSize, 0);
        gd.addStringField("Text:", text, 10);
        this.addRange(gd, "Range:", 1, defaultLastFrame);
        gd.setInsets(10, 20, 0);
        gd.addCheckbox(" Use overlay", useOverlay);
        gd.addCheckbox(" Use_text tool font", useTextToolFont);
        gd.addPreviewCheckbox(pfr);
        gd.addHelp("http://imagej.nih.gov/ij/docs/menus/image.html#label");
        gd.addDialogListener(this);
        this.previewing = true;
        gd.showDialog();
        this.previewing = false;
        if (gd.wasCanceled()) {
            return 4096;
        }
        return this.flags;
    }

    void addRange(GenericDialog gd, String label, int start, int end) {
        gd.addStringField(label, start + "-" + end);
    }

    double[] getRange(GenericDialog gd, int start, int end) {
        String[] range = Tools.split(gd.getNextString(), " -");
        double d1 = Tools.parseDouble(range[0]);
        double d2 = range.length == 2 ? Tools.parseDouble(range[1]) : Double.NaN;
        double[] result = new double[2];
        result[0] = Double.isNaN(d1) ? 1.0 : (double)((int)d1);
        double d = result[1] = Double.isNaN(d2) ? (double)end : (double)((int)d2);
        if (result[0] < (double)start) {
            result[0] = start;
        }
        if (result[1] > (double)end) {
            result[1] = end;
        }
        if (result[0] > result[1]) {
            result[0] = start;
            result[1] = end;
        }
        return result;
    }

    @Override
    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        format = gd.getNextChoiceIndex();
        start = Tools.parseDouble(gd.getNextString());
        String str = gd.getNextString();
        interval = Tools.parseDouble(str);
        x = (int)gd.getNextNumber();
        y = (int)gd.getNextNumber();
        fontSize = (int)gd.getNextNumber();
        text = gd.getNextString();
        double[] range = this.getRange(gd, 1, this.defaultLastFrame);
        useOverlay = gd.getNextBoolean();
        useTextToolFont = gd.getNextBoolean();
        if (this.virtualStack) {
            useOverlay = true;
        }
        this.firstFrame = (int)range[0];
        this.lastFrame = (int)range[1];
        int index = str.indexOf(".");
        decimalPlaces = index != -1 ? str.length() - index - 1 : 0;
        if (gd.invalidNumber()) {
            return false;
        }
        this.font = useTextToolFont ? new Font(TextRoi.getDefaultFontName(), TextRoi.getDefaultFontStyle(), fontSize) : new Font("SansSerif", 0, fontSize);
        if (y < fontSize) {
            y = fontSize + 5;
        }
        ImageProcessor ip = this.imp.getProcessor();
        ip.setFont(this.font);
        int size = this.defaultLastFrame;
        this.maxWidth = ip.getStringWidth(this.getString(size, interval, format));
        this.fieldWidth = 1;
        if (size >= 10) {
            this.fieldWidth = 2;
        }
        if (size >= 100) {
            this.fieldWidth = 3;
        }
        if (size >= 1000) {
            this.fieldWidth = 4;
        }
        if (size >= 10000) {
            this.fieldWidth = 5;
        }
        Prefs.set("label.format", format);
        return true;
    }

    @Override
    public void run(ImageProcessor ip) {
        int image = ip.getSliceNumber();
        int n = image - 1;
        if (this.imp.isHyperStack()) {
            n = this.updateIndex(n);
        }
        if (this.virtualStack) {
            int nSlices = this.imp.getStackSize();
            if (this.previewing) {
                nSlices = 1;
            }
            for (int i = 1; i <= nSlices; ++i) {
                image = i;
                n = i - 1;
                if (this.imp.isHyperStack()) {
                    n = this.updateIndex(n);
                }
                this.drawLabel(ip, image, n);
            }
        } else {
            if (this.previewing && this.overlay != null) {
                this.imp.setOverlay(this.baseOverlay);
                this.overlay = null;
            }
            this.drawLabel(ip, image, n);
        }
    }

    int updateIndex(int n) {
        if (this.imp.getNFrames() > 1) {
            return (int)((double)n * ((double)this.imp.getNFrames() / (double)this.imp.getStackSize()));
        }
        if (this.imp.getNSlices() > 1) {
            return (int)((double)n * ((double)this.imp.getNSlices() / (double)this.imp.getStackSize()));
        }
        return n;
    }

    void drawLabel(ImageProcessor ip, int image, int n) {
        String s = this.getString(n, interval, format);
        ip.setFont(this.font);
        int textWidth = ip.getStringWidth(s);
        if (this.color == null) {
            this.color = Toolbar.getForegroundColor();
            if ((this.color.getRGB() & 0xFFFFFF) == 0) {
                ip.setRoi(x, y - fontSize, this.maxWidth + textWidth, fontSize);
                double mean = ImageStatistics.getStatistics((ImageProcessor)ip, (int)2, null).mean;
                if (mean < 50.0 && !ip.isInvertedLut()) {
                    this.color = Color.white;
                }
                ip.resetRoi();
            }
        }
        int frame = image;
        int[] pos = new int[]{0, 0, 0};
        if (this.imp.isHyperStack()) {
            pos = this.imp.convertIndexToPosition(image);
            if (this.imp.getNFrames() > 1) {
                frame = pos[2];
            } else if (this.imp.getNSlices() > 1) {
                frame = pos[1];
            }
        }
        if (useOverlay) {
            if (image == 1) {
                Roi roi;
                this.overlay = new Overlay();
                if (this.baseOverlay != null) {
                    for (int i = 0; i < this.baseOverlay.size(); ++i) {
                        this.overlay.add(this.baseOverlay.get(i));
                    }
                }
                Rectangle r = (roi = this.imp.getRoi()) != null ? roi.getBounds() : null;
                int n2 = this.yoffset = r != null ? r.height : fontSize;
            }
            if (frame >= this.firstFrame && frame <= this.lastFrame) {
                int xloc = format == 5 ? x : x + this.maxWidth - textWidth;
                TextRoi roi = new TextRoi(xloc, y - this.yoffset, s, this.font);
                roi.setStrokeColor(this.color);
                roi.setNonScalable(true);
                if (this.imp.isHyperStack()) {
                    roi.setPosition(pos[0], pos[1], pos[2]);
                } else {
                    roi.setPosition(image);
                }
                this.overlay.add(roi);
            }
            if (image == this.imp.getStackSize() || this.previewing) {
                this.imp.setOverlay(this.overlay);
            }
        } else if (frame >= this.firstFrame && frame <= this.lastFrame) {
            ip.setColor(this.color);
            ip.setAntialiasedText(fontSize >= 18);
            int xloc = format == 5 ? x : x + this.maxWidth - textWidth;
            ip.moveTo(xloc, y);
            ip.drawString(s);
        }
    }

    String getString(int index, double interval, int format) {
        double time = start + (double)(index + 1 - this.firstFrame) * interval;
        int itime = (int)Math.floor(time);
        int sign = 1;
        if (itime < 0) {
            sign = -1;
        }
        itime *= sign;
        String str = "";
        switch (format) {
            case 0: {
                str = IJ.d2s(time, decimalPlaces) + " " + text;
                break;
            }
            case 1: {
                str = decimalPlaces == 0 ? this.zeroFill((int)time) : IJ.d2s(time, decimalPlaces);
                str = text + " " + str;
                break;
            }
            case 2: {
                str = this.pad((int)Math.floor(itime / 60 % 60)) + ":" + this.pad(itime % 60) + " " + text;
                if (sign != -1) break;
                str = "-" + str;
                break;
            }
            case 3: {
                str = this.pad((int)Math.floor(itime / 3600)) + ":" + this.pad((int)Math.floor(itime / 60 % 60)) + ":" + this.pad(itime % 60) + " " + text;
                if (sign != -1) break;
                str = "-" + str;
                break;
            }
            case 4: {
                str = text;
                break;
            }
            case 5: {
                str = 0 <= index && index < this.imp.getStackSize() ? ((str = this.imp.getStack().getShortSliceLabel(index + 1)) == null ? "null slice label (" + (index + 1) + ")" : str) : "void";
            }
        }
        return str;
    }

    String pad(int n) {
        String str = "" + n;
        if (str.length() == 1) {
            str = "0" + str;
        }
        return str;
    }

    String zeroFill(int n) {
        String str = "" + n;
        while (str.length() < this.fieldWidth) {
            str = "0" + str;
        }
        return str;
    }

    @Override
    public void setNPasses(int nPasses) {
    }
}

