/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th&#233;venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C&#233;dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     Cl&#233;ment Marti (clement.marti@epfl.ch)
 *     Julien Jacquemot (julien.jacquemot@epfl.ch)
 ******************************************************************************/
package plugins.big.bigsnakeutils.shape.priorshapes.shapes;

import plugins.big.bigsnakeutils.icy.snake2D.Snake2DNode;

/**
 * Shape prior with taking the shape of a fly.
 * 
 * @version November 13, 2013
 * 
 * @author Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 */
public class Fly extends PriorShape {

	public Fly() {
		name_ = new String("Fly");
		minNumberNodes_ = 18;
		coef_ = new Snake2DNode[minNumberNodes_];
		
		/*
		coef_[0] = new Snake2DNode(1284.1445945520504, 642.6);
		coef_[1] = new Snake2DNode(1347.1696338319878, 553.1455345879897);
		coef_[2] = new Snake2DNode(1340.566988449438, 469.09143696819643);
		coef_[3] = new Snake2DNode(1311.8639850851803, 438.9501000999956);
		coef_[4] = new Snake2DNode(1341.788224703827, 413.05593949522375);
		coef_[5] = new Snake2DNode(1336.909565684167, 350.46188692048685);
		coef_[6] = new Snake2DNode(1296.6599272800113, 327.85535044180676);
		coef_[7] = new Snake2DNode(1341.363341001558, 338.28855465316434);
		coef_[8] = new Snake2DNode(1327.6778963985805, 283.88266305379756);
		coef_[9] = new Snake2DNode(1284.1445945520504, 275.1646335884569);
		coef_[10] = new Snake2DNode(1240.6112927055199, 283.88266305379835);
		coef_[11] = new Snake2DNode(1226.9258481025413, 338.2885546531648);
		coef_[12] = new Snake2DNode(1271.6292618240875, 327.8553504418056);
		coef_[13] = new Snake2DNode(1231.3796234199317, 350.4618869204875);
		coef_[14] = new Snake2DNode(1226.500964400272, 413.05593949522347);
		coef_[15] = new Snake2DNode(1256.4252040189192, 438.95010009999555);
		coef_[16] = new Snake2DNode(1227.7222006546613, 469.09143696819615);
		coef_[17] = new Snake2DNode(1221.119555272111, 553.1455345879901);
		*/
		
		// slightly modified fly shape for "noise figure" in prior-shape paper
		// --> improves jaccard / dice indices
		
		coef_[0] = new Snake2DNode(496.88016899528293, 299.44394605546734);		
		coef_[1] = new Snake2DNode(452.7325965873529, 267.1230436723216);		
		coef_[2] = new Snake2DNode(410.9256689018195, 269.74653860144394);		
		coef_[3] = new Snake2DNode(395.4927919758898, 285.00405546827375);		
		coef_[4] = new Snake2DNode(382.3634738482256, 269.05016020929156);		
		coef_[5] = new Snake2DNode(350.9232737387128, 272.6392513588015);			
		coef_[6] = new Snake2DNode(345.4555420706551, 284.26108236157916);		
		coef_[7] = new Snake2DNode(343.51391393646196, 269.9951098012727);		
		coef_[8] = new Snake2DNode(318.02756143275195, 277.2225291347703);		
		coef_[9] = new Snake2DNode(313.2083070255873, 299.39426026465355);		
		coef_[10] = new Snake2DNode(316.4978208081359, 321.05282367006316);		
		coef_[11] = new Snake2DNode(344.03952904379594, 330.228073584129);		
		coef_[12] = new Snake2DNode(346.7191548353801, 315.94209949226166);		
		coef_[13] = new Snake2DNode(352.5220249513068, 327.3409453784996);		
		coef_[14] = new Snake2DNode(382.0865017496032, 330.50102549393847);		
		coef_[15] = new Snake2DNode(395.3599205956439, 314.58610846212684);		
		coef_[16] = new Snake2DNode(410.65970669622465, 329.89045684392175);		
		coef_[17] = new Snake2DNode(453.48832316913297, 333.4606219094644);
		
	}
}
