/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector.roi;

import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.util.ComponentUtil;
import icy.gui.util.GuiUtil;
import icy.image.IcyBufferedImage;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI3D;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.vecmath.Point3i;
import jxl.write.WritableSheet;
import plugins.adufour.connectedcomponents.ConnectedComponent;
import plugins.adufour.connectedcomponents.ConnectedComponents;
import plugins.fab.spotDetector.DetectionSpot;
import plugins.fab.spotDetector.GlobalDetectionToken;
import plugins.fab.spotDetector.roi.ROIDetectionAbstract;
import plugins.fab.spotDetector.roi.ROI_XLS_Common_Saver;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi2d.ROI2DRectangle;

public class ROICreateFromChannel
extends ROIDetectionAbstract
implements ActionListener,
CaretListener {
    JComboBox channelSelectionComboBox;
    int selectedChannel = 0;
    JButton testSettingsButton = new JButton("Test those settings on current sequence (current ROI will be replaced)");
    JTextField thresholdTextField = new JTextField("50");
    JLabel thresholdErrorTextField = new JLabel("Invalid value");
    JCheckBox enableMultipleROI = new JCheckBox("Enable multiple ROIs", true);
    JTextField dilateROITextField = new JTextField("0");
    JTextField minimumSizeOfROITextField = new JTextField("100");

    public ROICreateFromChannel() {
        this.channelSelectionComboBox = new JComboBox();
        this.thresholdErrorTextField.setForeground(Color.red);
        this.channelSelectionComboBox.addItem("Channel 0");
        this.channelSelectionComboBox.addItem("Channel 1");
        this.channelSelectionComboBox.addItem("Channel 2");
        this.channelSelectionComboBox.addItem("Channel 3");
        this.channelSelectionComboBox.addItem("Channel 4");
        this.channelSelectionComboBox.addItem("Channel 5");
        this.channelSelectionComboBox.addItem("Channel 6");
        this.getPanel().setLayout(new BoxLayout(this.getPanel(), 3));
        this.getPanel().setBorder(new TitledBorder("Create an ROI from a specific channel in a 2D image."));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalGlue()}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{new JLabel("Current sequence input:")}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalStrut(10)}));
        ComponentUtil.setFixedHeight((Component)this.channelSelectionComboBox, (int)20);
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createHorizontalStrut(50), this.channelSelectionComboBox, Box.createHorizontalStrut(50)}));
        ComponentUtil.setFixedHeight((Component)this.dilateROITextField, (int)20);
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createHorizontalStrut(50), new JLabel("Dilate ROIs:"), this.dilateROITextField, Box.createHorizontalStrut(50)}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.testSettingsButton}));
        this.testSettingsButton.addActionListener(this);
        this.thresholdErrorTextField.setVisible(false);
        ComponentUtil.setFixedHeight((Component)this.thresholdTextField, (int)20);
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{new JLabel("Threshold: "), this.thresholdTextField, this.thresholdErrorTextField}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.enableMultipleROI}));
        ComponentUtil.setFixedHeight((Component)this.minimumSizeOfROITextField, (int)20);
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{new JLabel("Minimum size of ROI(for multiple ROIs): "), this.minimumSizeOfROITextField}));
        this.thresholdTextField.addCaretListener(this);
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalStrut(30)}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{new JLabel("Tip: Remove detection areas with black rois")}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalGlue()}));
    }

    @Override
    public void process(GlobalDetectionToken gdt) {
        this.createChannel(gdt.inputSequence);
        ArrayList roiArrayList = gdt.inputSequence.getROIs();
        ArrayList<DetectionSpot> cloneDetectionList = new ArrayList<DetectionSpot>(gdt.detectionResult);
        for (ROI roi : roiArrayList) {
            if (roi.getColor().getRed() != 0 || roi.getColor().getGreen() != 0 || roi.getColor().getBlue() != 0) continue;
            if (roi instanceof ROI2D) {
                ROI2D roi2d = (ROI2D)roi;
                for (DetectionSpot detectionSpot : cloneDetectionList) {
                    if (!roi2d.contains(detectionSpot.getMassCenter().x, detectionSpot.getMassCenter().y)) continue;
                    gdt.detectionResult.remove(detectionSpot);
                }
                continue;
            }
            if (!(roi instanceof ROI3D)) continue;
            ROI3D roi3d = (ROI3D)roi;
            for (DetectionSpot detectionSpot : cloneDetectionList) {
                if (!roi3d.contains(detectionSpot.getMassCenter().x, detectionSpot.getMassCenter().y, detectionSpot.getMassCenter().z)) continue;
                gdt.detectionResult.remove(detectionSpot);
            }
        }
        HashMap ROI2Detection = new HashMap();
        if (roiArrayList.size() == 0) {
            ROI2Detection.put(new ROI2DRectangle((Rectangle2D)gdt.inputSequence.getBounds2D()), new ArrayList<DetectionSpot>(gdt.detectionResult));
        } else {
            for (ROI roi : roiArrayList) {
                ROI2Detection.put(roi, new ArrayList());
            }
            for (ROI roi : roiArrayList) {
                if (roi instanceof ROI2D) {
                    ROI2D roi2d = (ROI2D)roi;
                    for (DetectionSpot spot : gdt.detectionResult) {
                        if (!roi2d.contains(spot.getMassCenter().x, spot.getMassCenter().y)) continue;
                        ((ArrayList)ROI2Detection.get(roi)).add(spot);
                    }
                    continue;
                }
                if (!(roi instanceof ROI3D)) continue;
                ROI3D roi3d = (ROI3D)roi;
                for (DetectionSpot spot : gdt.detectionResult) {
                    if (!roi3d.contains(spot.getMassCenter().x, spot.getMassCenter().y, spot.getMassCenter().z)) continue;
                    ((ArrayList)ROI2Detection.get(roi)).add(spot);
                }
            }
        }
        gdt.detectionResult.clear();
        for (ROI roi : ROI2Detection.keySet()) {
            for (DetectionSpot detectionSpot : (ArrayList)ROI2Detection.get(roi)) {
                gdt.detectionResult.add(detectionSpot);
            }
        }
        gdt.roi2detection = ROI2Detection;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.testSettingsButton) {
            ThreadUtil.bgRun((Runnable)new Runnable(){

                @Override
                public void run() {
                    ROICreateFromChannel.this.createChannel(ROICreateFromChannel.this.getFocusedSequence());
                }
            });
        }
    }

    private void createChannel(Sequence sequence) {
        if (sequence == null) {
            return;
        }
        try {
            double value = Double.parseDouble(this.thresholdTextField.getText());
            IcyBufferedImage image = sequence.getImage(0, 0);
            double[] data = Array1DUtil.arrayToDoubleArray((Object)image.getDataXY(this.channelSelectionComboBox.getSelectedIndex()), (boolean)image.isSignedDataType());
            boolean[] booleanROI = new boolean[data.length];
            byte[] byteROI = new byte[data.length];
            for (int i = 0; i < data.length; ++i) {
                booleanROI[i] = data[i] >= value;
                byteROI[i] = data[i] > value ? -1 : 0;
            }
            if (this.enableMultipleROI.isSelected()) {
                sequence.removeAllROI();
                IcyBufferedImage binaryImage = new IcyBufferedImage(image.getWidth(), image.getHeight(), 1, DataType.BYTE);
                binaryImage.setDataXYAsByte(0, byteROI);
                Sequence binarySequence = new Sequence(binaryImage);
                Map result = ConnectedComponents.extractConnectedComponents((Sequence)binarySequence, (double)0.0, (ConnectedComponents.ExtractionType)ConnectedComponents.ExtractionType.BACKGROUND, (int)0, (int)Integer.MAX_VALUE, null);
                double minSizeROI = Double.parseDouble(this.minimumSizeOfROITextField.getText());
                List ccList = (List)result.get(0);
                AnnounceFrame af = new AnnounceFrame("Creating ROIs...");
                for (ConnectedComponent cc : ccList) {
                    if ((double)cc.getPoints().length < minSizeROI) continue;
                    boolean[] connectedMask = new boolean[data.length];
                    for (Point3i point : cc.getPoints()) {
                        connectedMask[point.y * image.getWidth() + point.x] = true;
                    }
                    this.dilateMask(connectedMask, sequence);
                    ROI2DArea roi2DArea = new ROI2DArea();
                    roi2DArea.setAsBooleanMask(new Rectangle(0, 0, sequence.getWidth(), sequence.getHeight()), connectedMask);
                    roi2DArea.setName("Area " + ccList.indexOf(cc));
                    sequence.addROI((ROI)roi2DArea);
                }
                af.close();
            }
            if (!this.enableMultipleROI.isSelected()) {
                this.dilateMask(booleanROI, sequence);
                sequence.removeAllROI();
                ROI2DArea roi2DArea = new ROI2DArea();
                roi2DArea.setAsBooleanMask(new Rectangle(0, 0, sequence.getWidth(), sequence.getHeight()), booleanROI);
                sequence.addROI((ROI)roi2DArea);
            }
        }
        catch (NumberFormatException e1) {
            new AnnounceFrame("ROI Create channel : Invalid threshold or dilatation argument");
        }
    }

    private void dilateMask(boolean[] booleanROI, Sequence sequence) {
        int nbDilateIteration = Integer.parseInt(this.dilateROITextField.getText());
        int width = sequence.getWidth();
        int height = sequence.getHeight();
        boolean[] dilated = new boolean[booleanROI.length];
        for (int i = 0; i < nbDilateIteration; ++i) {
            int index = 0;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (booleanROI[index]) {
                        this.put9pix(dilated, x, y, width, height);
                    }
                    ++index;
                }
            }
            int arraySize = booleanROI.length;
            for (int index2 = 0; index2 < arraySize; ++index2) {
                booleanROI[index2] = dilated[index2];
            }
        }
    }

    private void put9pix(boolean[] dilated, int x, int y, int width, int height) {
        for (int yy = y - 1; yy < y + 2; ++yy) {
            for (int xx = x - 1; xx < x + 2; ++xx) {
                if (xx < 0 || yy < 0 || xx >= width || yy >= height) continue;
                dilated[yy * width + xx] = true;
            }
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        try {
            Double.parseDouble(this.thresholdTextField.getText());
            this.thresholdErrorTextField.setVisible(false);
            this.testSettingsButton.setEnabled(true);
        }
        catch (NumberFormatException e1) {
            this.thresholdErrorTextField.setVisible(true);
            this.testSettingsButton.setEnabled(false);
        }
    }

    @Override
    public void saveXLS(WritableSheet page, GlobalDetectionToken gdt) {
        ROI_XLS_Common_Saver.saveXLS(page, gdt, "ROI From channel module");
    }
}

