/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.inspector;

import icy.gui.component.AbstractRoisPanel;
import icy.gui.component.button.IcyButton;
import icy.gui.component.button.IcyToggleButton;
import icy.preferences.XMLPreferences;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.roi.ROIDescriptor;
import icy.roi.ROIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class RoiSettingPanel
extends JPanel
implements ActionListener,
ItemListener {
    private JScrollPane scrollPaneView;
    private JScrollPane scrollPaneExport;
    private JTable tableView;
    private JTable tableExport;
    private JPanel panelExportTop;
    private JCheckBox chkHeaderSelectAllToDisplay;
    private JCheckBox chkHeaderSelectAllToExport;
    private IcyToggleButton btnHeaderColumnsToDisplay;
    private IcyToggleButton btnHeaderColumnsToExport;
    private IcyButton btnUpView;
    private IcyButton btnDownView;
    private IcyButton btnUpExport;
    private IcyButton btnDownExport;
    List<AbstractRoisPanel.BaseColumnInfo> idsView;
    List<AbstractRoisPanel.BaseColumnInfo> idsExport;
    private AbstractTableModel viewModel;
    private AbstractTableModel exportModel;
    private final XMLPreferences prefView;
    private final XMLPreferences prefExport;

    public RoiSettingPanel(XMLPreferences viewPreferences, XMLPreferences exportPreferences) {
        this.prefView = viewPreferences;
        this.prefExport = exportPreferences;
        Set<ROIDescriptor> descriptors = ROIUtil.getROIDescriptors().keySet();
        this.idsView = new ArrayList<AbstractRoisPanel.BaseColumnInfo>();
        this.idsExport = new ArrayList<AbstractRoisPanel.BaseColumnInfo>();
        for (ROIDescriptor descriptor : descriptors) {
            this.idsView.add(new AbstractRoisPanel.BaseColumnInfo(descriptor, this.prefView, false));
            this.idsExport.add(new AbstractRoisPanel.BaseColumnInfo(descriptor, this.prefExport, true));
        }
        this.sortLists();
        this.initialize();
        this.viewModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return String.class;
                    }
                    case 1: {
                        return Boolean.class;
                    }
                }
                return String.class;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return "Column name";
                    }
                    case 1: {
                        return "Visible";
                    }
                }
                return "";
            }

            @Override
            public int getRowCount() {
                return RoiSettingPanel.this.idsView.size();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return RoiSettingPanel.this.idsView.get((int)rowIndex).descriptor.getName();
                    }
                    case 1: {
                        return RoiSettingPanel.this.idsView.get((int)rowIndex).visible;
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 1;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                if (columnIndex == 1) {
                    RoiSettingPanel.this.idsView.get((int)rowIndex).visible = (Boolean)aValue;
                }
            }
        };
        this.exportModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return String.class;
                    }
                    case 1: {
                        return Boolean.class;
                    }
                }
                return String.class;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return "Column name";
                    }
                    case 1: {
                        return "Visible";
                    }
                }
                return "";
            }

            @Override
            public int getRowCount() {
                return RoiSettingPanel.this.idsExport.size();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return RoiSettingPanel.this.idsExport.get((int)rowIndex).descriptor.getName();
                    }
                    case 1: {
                        return RoiSettingPanel.this.idsExport.get((int)rowIndex).visible;
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 1;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                if (columnIndex == 1) {
                    RoiSettingPanel.this.idsExport.get((int)rowIndex).visible = (Boolean)aValue;
                }
            }
        };
        this.tableView.setModel(this.viewModel);
        TableColumnModel columnModel = this.tableView.getColumnModel();
        TableColumn column = columnModel.getColumn(0);
        column.setPreferredWidth(150);
        column.setMinWidth(80);
        column = columnModel.getColumn(1);
        column.setResizable(false);
        column.setPreferredWidth(50);
        column.setMaxWidth(50);
        column.setMinWidth(30);
        this.tableExport.setModel(this.exportModel);
        columnModel = this.tableExport.getColumnModel();
        column = columnModel.getColumn(0);
        column.setPreferredWidth(150);
        column.setMinWidth(80);
        column = columnModel.getColumn(1);
        column.setResizable(false);
        column.setPreferredWidth(50);
        column.setMaxWidth(50);
        column.setMinWidth(30);
        this.chkHeaderSelectAllToDisplay.addItemListener(this);
        this.btnHeaderColumnsToDisplay.addItemListener(this);
        this.btnUpView.addActionListener(this);
        this.btnDownView.addActionListener(this);
        this.chkHeaderSelectAllToExport.addItemListener(this);
        this.btnHeaderColumnsToExport.addItemListener(this);
        this.btnUpExport.addActionListener(this);
        this.btnDownExport.addActionListener(this);
    }

    private void initialize() {
        this.setLayout(new BorderLayout(0, 0));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setResizeWeight(0.5);
        this.add((Component)splitPane, "Center");
        JPanel panelView = new JPanel();
        splitPane.setLeftComponent(panelView);
        panelView.setLayout(new BorderLayout(0, 0));
        this.scrollPaneView = new JScrollPane();
        panelView.add((Component)this.scrollPaneView, "Center");
        this.tableView = new JTable();
        this.tableView.setSelectionMode(1);
        this.tableView.setRowSelectionAllowed(true);
        this.scrollPaneView.setViewportView(this.tableView);
        JPanel panelViewTop = new JPanel();
        panelView.add((Component)panelViewTop, "North");
        GridBagLayout gbl_panelViewTop = new GridBagLayout();
        gbl_panelViewTop.columnWidths = new int[]{0, 0, 0, 0, 0};
        gbl_panelViewTop.rowHeights = new int[]{14, 0};
        gbl_panelViewTop.columnWeights = new double[]{0.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelViewTop.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelViewTop.setLayout(gbl_panelViewTop);
        this.chkHeaderSelectAllToDisplay = new JCheckBox();
        this.chkHeaderSelectAllToDisplay.setToolTipText("Click to select/deselect all descriptors in this list");
        GridBagConstraints gbc_chkHeaderSelectAllToDisplay = new GridBagConstraints();
        gbc_chkHeaderSelectAllToDisplay.insets = new Insets(0, 0, 0, 0);
        gbc_chkHeaderSelectAllToDisplay.gridx = 0;
        gbc_chkHeaderSelectAllToDisplay.gridy = 0;
        panelViewTop.add((Component)this.chkHeaderSelectAllToDisplay, gbc_chkHeaderSelectAllToDisplay);
        this.btnHeaderColumnsToDisplay = new IcyToggleButton("Columns to display", (IcyIcon)null);
        this.btnHeaderColumnsToDisplay.setToolTipText("Click to alphabetically reorder descriptors in this list");
        this.btnHeaderColumnsToDisplay.setFlat(true);
        GridBagConstraints gbc_btnHeaderColumnsToDisplay = new GridBagConstraints();
        gbc_btnHeaderColumnsToDisplay.insets = new Insets(0, 0, 0, 0);
        gbc_btnHeaderColumnsToDisplay.gridx = 1;
        gbc_btnHeaderColumnsToDisplay.gridy = 0;
        panelViewTop.add((Component)this.btnHeaderColumnsToDisplay, gbc_btnHeaderColumnsToDisplay);
        this.btnUpView = new IcyButton(new IcyIcon(ResourceUtil.ICON_ARROW_UP));
        this.btnUpView.setToolTipText("Change order of selected column(s)");
        this.btnUpView.setFlat(true);
        GridBagConstraints gbc_btnUpView = new GridBagConstraints();
        gbc_btnUpView.insets = new Insets(0, 0, 0, 5);
        gbc_btnUpView.gridx = 2;
        gbc_btnUpView.gridy = 0;
        panelViewTop.add((Component)this.btnUpView, gbc_btnUpView);
        this.btnDownView = new IcyButton(new IcyIcon(ResourceUtil.ICON_ARROW_DOWN));
        this.btnDownView.setToolTipText("Change order of selected column(s)");
        this.btnDownView.setFlat(true);
        GridBagConstraints gbc_btnDownView = new GridBagConstraints();
        gbc_btnDownView.gridx = 3;
        gbc_btnDownView.gridy = 0;
        panelViewTop.add((Component)this.btnDownView, gbc_btnDownView);
        JPanel panelExport = new JPanel();
        splitPane.setRightComponent(panelExport);
        panelExport.setLayout(new BorderLayout(0, 0));
        this.scrollPaneExport = new JScrollPane();
        panelExport.add((Component)this.scrollPaneExport, "Center");
        this.tableExport = new JTable();
        this.tableExport.setSelectionMode(1);
        this.tableExport.setRowSelectionAllowed(true);
        this.scrollPaneExport.setViewportView(this.tableExport);
        this.panelExportTop = new JPanel();
        panelExport.add((Component)this.panelExportTop, "North");
        GridBagLayout gbl_panelExportTop = new GridBagLayout();
        gbl_panelExportTop.columnWidths = new int[]{0, 0, 0, 0, 0};
        gbl_panelExportTop.rowHeights = new int[]{14, 0};
        gbl_panelExportTop.columnWeights = new double[]{0.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelExportTop.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panelExportTop.setLayout(gbl_panelExportTop);
        this.chkHeaderSelectAllToExport = new JCheckBox();
        this.chkHeaderSelectAllToExport.setToolTipText("Click to select/deselect all descriptors in this list");
        GridBagConstraints gbc_chkHeaderSelectAllToExport = new GridBagConstraints();
        gbc_chkHeaderSelectAllToExport.insets = new Insets(0, 0, 0, 0);
        gbc_chkHeaderSelectAllToExport.gridx = 0;
        gbc_chkHeaderSelectAllToExport.gridy = 0;
        this.panelExportTop.add((Component)this.chkHeaderSelectAllToExport, gbc_chkHeaderSelectAllToExport);
        this.btnHeaderColumnsToExport = new IcyToggleButton("Columns to export (XLS or CSV)", (IcyIcon)null);
        this.btnHeaderColumnsToExport.setToolTipText("Click to alphabetically reorder descriptors in this list");
        this.btnHeaderColumnsToExport.setFlat(true);
        GridBagConstraints gbc_btnHeaderColumnsToExport = new GridBagConstraints();
        gbc_btnHeaderColumnsToExport.insets = new Insets(0, 0, 0, 0);
        gbc_btnHeaderColumnsToExport.gridx = 1;
        gbc_btnHeaderColumnsToExport.gridy = 0;
        this.panelExportTop.add((Component)this.btnHeaderColumnsToExport, gbc_btnHeaderColumnsToExport);
        this.btnUpExport = new IcyButton(new IcyIcon(ResourceUtil.ICON_ARROW_UP));
        this.btnUpExport.setToolTipText("Change order of selected column(s)");
        this.btnUpExport.setFlat(true);
        GridBagConstraints gbc_btnUpExport = new GridBagConstraints();
        gbc_btnUpExport.insets = new Insets(0, 0, 0, 5);
        gbc_btnUpExport.gridx = 2;
        gbc_btnUpExport.gridy = 0;
        this.panelExportTop.add((Component)this.btnUpExport, gbc_btnUpExport);
        this.btnDownExport = new IcyButton(new IcyIcon(ResourceUtil.ICON_ARROW_DOWN));
        this.btnDownExport.setToolTipText("Change order of selected column(s)");
        this.btnDownExport.setFlat(true);
        GridBagConstraints gbc_btnDownExport = new GridBagConstraints();
        gbc_btnDownExport.gridx = 3;
        gbc_btnDownExport.gridy = 0;
        this.panelExportTop.add((Component)this.btnDownExport, gbc_btnDownExport);
    }

    void fixOrders() {
        int order = 0;
        for (AbstractRoisPanel.BaseColumnInfo columnInfo : this.idsView) {
            columnInfo.order = order++;
        }
        order = 0;
        for (AbstractRoisPanel.BaseColumnInfo columnInfo : this.idsExport) {
            columnInfo.order = order++;
        }
    }

    void sortLists() {
        Collections.sort(this.idsView);
        Collections.sort(this.idsExport);
        this.fixOrders();
    }

    public void save() {
        this.sortLists();
        for (AbstractRoisPanel.BaseColumnInfo columnInfo : this.idsView) {
            columnInfo.save(this.prefView);
        }
        for (AbstractRoisPanel.BaseColumnInfo columnInfo : this.idsExport) {
            columnInfo.save(this.prefExport);
        }
    }

    List<AbstractRoisPanel.BaseColumnInfo> getSelected(JTable table, List<AbstractRoisPanel.BaseColumnInfo> columnInfos) {
        int[] selected;
        ArrayList<AbstractRoisPanel.BaseColumnInfo> result = new ArrayList<AbstractRoisPanel.BaseColumnInfo>();
        for (int index : selected = table.getSelectedRows()) {
            result.add(columnInfos.get(index));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreSelected(JTable table, List<AbstractRoisPanel.BaseColumnInfo> columnInfos, List<AbstractRoisPanel.BaseColumnInfo> selected) {
        ListSelectionModel selectionModel = table.getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        try {
            selectionModel.clearSelection();
            for (AbstractRoisPanel.BaseColumnInfo bci : selected) {
                int index = columnInfos.indexOf(bci);
                if (index < 0) continue;
                selectionModel.addSelectionInterval(index, index);
            }
        }
        finally {
            selectionModel.setValueIsAdjusting(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.btnUpView || source == this.btnDownView || source == this.btnUpExport || source == this.btnDownExport) {
            this.moveTableItem(e);
        }
    }

    private void moveTableItem(ActionEvent e) {
        List<AbstractRoisPanel.BaseColumnInfo> columnInfos;
        JTable table;
        Object source = e.getSource();
        if (source == this.btnUpView || source == this.btnDownView) {
            table = this.tableView;
            columnInfos = this.idsView;
        } else if (source == this.btnUpExport || source == this.btnDownExport) {
            table = this.tableExport;
            columnInfos = this.idsExport;
        } else {
            table = null;
            columnInfos = null;
        }
        int v = source == this.btnUpView || source == this.btnUpExport ? -1 : (source == this.btnDownView || source == this.btnDownExport ? 1 : 0);
        if (table != null && columnInfos != null) {
            List<AbstractRoisPanel.BaseColumnInfo> selected = this.getSelected(table, columnInfos);
            for (AbstractRoisPanel.BaseColumnInfo bci : selected) {
                bci.order += v;
            }
            if (v == -1) {
                int firstSelected = table.getSelectionModel().getMinSelectionIndex();
                if (firstSelected != -1 && firstSelected > 0) {
                    columnInfos.get((int)(firstSelected - 1)).order += table.getSelectedRowCount();
                }
            } else {
                int lastSelected = table.getSelectionModel().getMaxSelectionIndex();
                if (lastSelected != -1 && lastSelected < columnInfos.size() - 1) {
                    columnInfos.get((int)(lastSelected + 1)).order -= table.getSelectedRowCount();
                }
            }
            this.sortLists();
            this.restoreSelected(table, columnInfos, selected);
            if (source == this.btnUpView || source == this.btnDownView) {
                this.viewModel.fireTableRowsUpdated(0, this.idsView.size() - 1);
            } else if (source == this.btnUpExport || source == this.btnDownExport) {
                this.exportModel.fireTableRowsUpdated(0, this.idsExport.size() - 1);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.chkHeaderSelectAllToDisplay || source == this.chkHeaderSelectAllToExport) {
            this.toggleSelectAll(e);
        } else if (source == this.btnHeaderColumnsToDisplay || source == this.btnHeaderColumnsToExport) {
            this.sortTableElements(e);
        }
    }

    private void toggleSelectAll(ItemEvent e) {
        boolean selectionValue;
        List<AbstractRoisPanel.BaseColumnInfo> columnInfos;
        JTable table;
        Object source = e.getSource();
        if (source == this.chkHeaderSelectAllToDisplay) {
            table = this.tableView;
            columnInfos = this.idsView;
            selectionValue = this.chkHeaderSelectAllToDisplay.isSelected();
        } else if (source == this.chkHeaderSelectAllToExport) {
            table = this.tableExport;
            columnInfos = this.idsExport;
            selectionValue = this.chkHeaderSelectAllToExport.isSelected();
        } else {
            table = null;
            columnInfos = null;
            selectionValue = false;
        }
        if (table != null && columnInfos != null) {
            for (int j = 0; j < table.getRowCount(); ++j) {
                table.setValueAt(selectionValue, j, 1);
            }
            if (source == this.chkHeaderSelectAllToDisplay) {
                this.viewModel.fireTableRowsUpdated(0, this.idsView.size() - 1);
            } else if (source == this.chkHeaderSelectAllToExport) {
                this.exportModel.fireTableRowsUpdated(0, this.idsExport.size() - 1);
            }
        }
    }

    private void sortTableElements(ItemEvent e) {
        boolean orderIncremental;
        List<AbstractRoisPanel.BaseColumnInfo> columnInfos;
        JTable table;
        Object source = e.getSource();
        if (source == this.btnHeaderColumnsToDisplay) {
            table = this.tableView;
            columnInfos = this.idsView;
            orderIncremental = this.btnHeaderColumnsToDisplay.isSelected();
        } else if (source == this.btnHeaderColumnsToExport) {
            table = this.tableExport;
            columnInfos = this.idsExport;
            orderIncremental = this.btnHeaderColumnsToExport.isSelected();
        } else {
            table = null;
            columnInfos = null;
            orderIncremental = false;
        }
        if (table != null && columnInfos != null) {
            int i2;
            List<AbstractRoisPanel.BaseColumnInfo> selected = this.getSelected(table, columnInfos);
            List<AbstractRoisPanel.BaseColumnInfo> included = this.getIncluded(table, columnInfos);
            List<AbstractRoisPanel.BaseColumnInfo> notIncluded = this.getNotIncluded(table, columnInfos);
            included.sort(Comparator.comparingInt(info -> info.order));
            for (i2 = 0; i2 < included.size(); ++i2) {
                included.get((int)i2).order = i2;
            }
            notIncluded.sort(orderIncremental ? Comparator.comparing(i -> i.descriptor.getName().toLowerCase()) : Comparator.comparing(i -> i.descriptor.getName().toLowerCase()).reversed());
            for (i2 = 0; i2 < notIncluded.size(); ++i2) {
                notIncluded.get((int)i2).order = included.size() + i2;
            }
            this.sortLists();
            this.restoreSelected(table, columnInfos, selected);
            if (source == this.btnHeaderColumnsToDisplay) {
                this.viewModel.fireTableRowsUpdated(0, this.idsView.size() - 1);
            } else if (source == this.btnHeaderColumnsToExport) {
                this.exportModel.fireTableRowsUpdated(0, this.idsExport.size() - 1);
            }
        }
    }

    private List<AbstractRoisPanel.BaseColumnInfo> getIncluded(JTable table, List<AbstractRoisPanel.BaseColumnInfo> columnInfos) {
        int[] included;
        ArrayList<AbstractRoisPanel.BaseColumnInfo> result = new ArrayList<AbstractRoisPanel.BaseColumnInfo>();
        for (int index : included = this.getIncludedIndices(table)) {
            result.add(columnInfos.get(index));
        }
        return result;
    }

    private int[] getIncludedIndices(JTable table) {
        int[] included = new int[table.getRowCount()];
        int pos = 0;
        for (int j = 0; j < table.getRowCount(); ++j) {
            if (!((Boolean)table.getValueAt(j, 1)).booleanValue()) continue;
            included[pos++] = j;
        }
        return Arrays.copyOf(included, pos);
    }

    private List<AbstractRoisPanel.BaseColumnInfo> getNotIncluded(JTable table, List<AbstractRoisPanel.BaseColumnInfo> columnInfos) {
        int[] notIncluded;
        ArrayList<AbstractRoisPanel.BaseColumnInfo> result = new ArrayList<AbstractRoisPanel.BaseColumnInfo>();
        for (int index : notIncluded = this.getNotIncludedIndices(table)) {
            result.add(columnInfos.get(index));
        }
        return result;
    }

    private int[] getNotIncludedIndices(JTable table) {
        int[] notIncluded = new int[table.getRowCount()];
        int pos = 0;
        for (int j = 0; j < table.getRowCount(); ++j) {
            if (((Boolean)table.getValueAt(j, 1)).booleanValue()) continue;
            notIncluded[pos++] = j;
        }
        return Arrays.copyOf(notIncluded, pos);
    }
}

