/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.blocks.lang;

import java.util.List;
import plugins.adufour.blocks.lang.Loop;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarInteger;

public class RangeLoop
extends Loop {
    private VarInteger startIndex;
    private VarInteger endIndex;
    private VarInteger step;
    private VarInteger index;

    public VarInteger getEndIndex() {
        return this.endIndex;
    }

    public VarInteger getIndex() {
        return this.index;
    }

    public VarInteger getStartIndex() {
        return this.startIndex;
    }

    public VarInteger getStep() {
        return this.step;
    }

    @Override
    public void initializeLoop() {
        this.index.setValue((Object)this.startIndex.getValue());
    }

    @Override
    public void beforeIteration() {
    }

    @Override
    public void afterIteration() {
        this.index.setValue((Object)(this.index.getValue() + this.step.getValue()));
    }

    @Override
    public boolean isStopConditionReached() {
        if (super.isStopConditionReached()) {
            return true;
        }
        if (this.step.getValue() > 0) {
            return this.index.getValue() >= this.endIndex.getValue();
        }
        return this.index.getValue() <= this.endIndex.getValue();
    }

    @Override
    public void declareInput(VarList inputMap) {
        super.declareInput(inputMap);
        this.startIndex = new VarInteger("start", 0);
        inputMap.add("start", (Var<?>)this.startIndex);
        this.step = new VarInteger("step", 1);
        inputMap.add("step", (Var<?>)this.step);
        this.endIndex = new VarInteger("end", 10);
        inputMap.add("end", (Var<?>)this.endIndex);
    }

    @Override
    public void declareOutput(VarList outputMap) {
        super.declareOutput(outputMap);
        this.index = new VarInteger("index", ((Integer)this.startIndex.getDefaultValue()).intValue());
        outputMap.add("index", (Var<?>)this.index);
    }

    @Override
    public void declareLoopVariables(List<Var<?>> loopVariables) {
        loopVariables.add((Var<?>)this.startIndex);
        loopVariables.add((Var<?>)this.endIndex);
        loopVariables.add((Var<?>)this.step);
        loopVariables.add((Var<?>)this.index);
        super.declareLoopVariables(loopVariables);
    }
}

