/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Int1D;
import mitiv.array.IntScalar;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedInt1D;
import mitiv.array.impl.StriddenInt1D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.IntFunction;
import mitiv.base.mapping.IntScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.IntGenerator;

public class FlatInt1D
extends Int1D {
    static final int order = 1;
    final int[] data;

    public FlatInt1D(int dim1) {
        super(dim1);
        this.data = new int[this.number];
    }

    public FlatInt1D(int[] dims) {
        super(dims);
        this.data = new int[this.number];
    }

    public FlatInt1D(Shape shape) {
        super(shape);
        this.data = new int[this.number];
    }

    public FlatInt1D(int[] arr, int dim1) {
        super(dim1);
        this.checkSize(arr);
        this.data = arr;
    }

    public FlatInt1D(int[] arr, int[] dims) {
        super(dims);
        this.checkSize(arr);
        this.data = arr;
    }

    public FlatInt1D(int[] arr, Shape shape) {
        super(shape);
        this.checkSize(arr);
        this.data = arr;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    private void checkSize(int[] arr) {
        if (arr == null || arr.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    final int index(int i1) {
        return i1;
    }

    @Override
    public final int get(int i1) {
        return this.data[i1];
    }

    @Override
    public final void set(int i1, int value) {
        this.data[i1] = value;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(int value) {
        for (int j = 0; j < this.number; ++j) {
            this.data[j] = value;
        }
    }

    @Override
    public void fill(IntGenerator generator) {
        for (int j = 0; j < this.number; ++j) {
            this.data[j] = generator.nextInt();
        }
    }

    @Override
    public void increment(int value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = this.data[n] + value;
        }
    }

    @Override
    public void decrement(int value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = this.data[n] - value;
        }
    }

    @Override
    public void scale(int value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = this.data[n] * value;
        }
    }

    @Override
    public void map(IntFunction function) {
        for (int j = 0; j < this.number; ++j) {
            this.data[j] = function.apply(this.data[j]);
        }
    }

    @Override
    public void scan(IntScanner scanner) {
        scanner.initialize(this.data[0]);
        for (int j = 1; j < this.number; ++j) {
            scanner.update(this.data[j]);
        }
    }

    @Override
    public final boolean isFlat() {
        return true;
    }

    @Override
    public int[] flatten(boolean forceCopy) {
        if (forceCopy) {
            int[] result = new int[this.number];
            System.arraycopy(this.data, 0, result, 0, this.number);
            return result;
        }
        return this.data;
    }

    @Override
    public int[] getData() {
        return this.data;
    }

    @Override
    public IntScalar slice(int idx) {
        idx = Helper.fixIndex(idx, this.dim1);
        return new IntScalar(this.data, idx);
    }

    @Override
    public IntScalar slice(int idx, int dim) {
        Helper.fixSliceIndex(dim, 1);
        return new IntScalar(this.data, Helper.fixIndex(idx, this.dim1));
    }

    @Override
    public Int1D view(Range rng1) {
        CompiledRange cr1 = new CompiledRange(rng1, this.dim1, 0, 1);
        if (cr1.doesNothing()) {
            return this;
        }
        return new StriddenInt1D(this.data, cr1.getOffset(), cr1.getStride(), cr1.getNumber());
    }

    @Override
    public Int1D view(int[] sel1) {
        int[] idx1 = Helper.select(0, 1, this.dim1, sel1);
        return new SelectedInt1D(this.data, idx1);
    }

    @Override
    public Int1D as1D() {
        return this;
    }
}

